;-----------------------------------------------------------
; 
;       Xetrion Source Code
;
;       (c) NeXO Software, Benoit SCHERRER
;       e-mail : p.c.scherrer@wanadoo.fr
;
;
;       File>           menu.xas
;       Utility>        Menu Management
;
;-----------------------------------------------------------

KM_FILE		equ	268
KM_SECURE	equ	269
KM_TOOLS	equ	270
KM_PLUGIN	equ	271

;-----------------------------------------------------------
; Main routine called for menu management
;
;Input> d0.w : key pressed
;-----------------------------------------------------------
MenuManagement:
	bsr     EnableMenus

	move.w	d0,d4			;save key for SelectMenu
	cmp.w   #KM_FILE,d0
	beq     FileMenu
	cmp.w   #KM_SECURE,d0
	beq     SecureMenu
	cmp.w	#KM_TOOLS,d0
	beq	ToolsMenu
	cmp.w   #KM_PLUGIN,d0
	beq     PluginMenu
	bra     EndMenu


;-----------------------------------------------------------
; File Menu
;-----------------------------------------------------------
FileMenu:
	lea     mnuFileHeader(PC),a0
	lea     mnuFileData(PC),a1
	bsr     DrawMenu
	cmp.w   #13,d0
	bne.s   \exit

	tst.w   d1
	beq     Copy2
	cmp.w   #1,d1
	beq     Move2
	cmp.w   #2,d1
	beq     Rename2
	cmp.w   #3,d1
	beq     Delete2
	cmp.w   #4,d1
	beq     CreateFolder2
;#ifdef TIPLUS
	cmp.w   #6,d1
	beq     Archive
	cmp.w   #7,d1
	beq     Unarchive
	cmp.w   #9,d1
;#else
	cmp.w   #6,d1
;#endif
	beq     Exit          

\exit   clr.w   d1                      ;offset
	bra     CommonMenu

;-----------------------------------------------------------
; Tools Menu
;-----------------------------------------------------------
SecureMenu:
	lea     mnuSecureHeader(PC),a0
	lea     mnuSecureData(PC),a1
	bsr     DrawMenu
	cmp.w   #13,d0
	bne.s   \exit

	tst.w	d1
	beq	Lock2
	cmp.w	#1,d1
	beq	Hide2
	cmp.w   #3,d1
	beq     ProtectNow


;	cmp.w   #4,d1
;	bne.s   \nohome
;	lea     VirtualList(PC),a6
;	bsr     InitStyle
;	bra.s   \lp

\exit   moveq.w #4,d1                   ;offset
	bra     CommonMenu


;-----------------------------------------------------------
; Option Menu
;-----------------------------------------------------------
ToolsMenu:
	lea     mnuToolsHeader(PC),a0
	lea     mnuToolsData(PC),a1
	bsr     DrawMenu
	cmp.w	#$2122,d0
	beq.s	\newfilter
	cmp.w	#$2121,d0
	beq.s	ToolsMenu

	cmp.w   #13,d0
	bne.s   \exit

	tst.w   d1
	beq     SelectFile
	cmp.w   #1,d1
	beq     SelectAll
	cmp.w   #2,d1
	beq	_DeselectAll
	cmp.w	#4,d1
	beq	SetupWindow
	cmp.w   #6,d1
	beq     AboutWin

\exit   moveq.w #8,d1                           ;offset
	bra     CommonMenu

\newfilter
	bsr	SetNewVarStyleIfNeeded
	bra	LoopRDListArea

;----------------------------------
; format : left,right
;----------------------------------
ConvertPadToFn:
	dc.w    KM_PLUGIN,KM_SECURE
	dc.w	KM_FILE,KM_TOOLS
	dc.w	KM_SECURE,KM_PLUGIN
	dc.w	KM_TOOLS,KM_FILE

;-----------------------------------------------------------
; Common function called after a key was pressed
; in a menu
;-----------------------------------------------------------
CommonMenu:
	lea     ConvertPadToFn(PC),a0
	adda.w  d1,a0
	
	cmp.w   #PAD_LEFT,d0
	bne.s   \no_left
	move.w  (a0),d0
\no_left cmp.w  #PAD_RIGHT,d0
	bne.s   \no_right
	move.w  2(a0),d0
\no_right
	cmp.w   #264,d0
	bne.s   \no_esc
	clr.w   d0
\no_esc bra     MenuManagement

;--------------------------------------------------------------
; Save the screen, run the menu component and restore 
; the screen
;
;Input> a0.l : api92ListView struct
;       a1.l : Data
;--------------------------------------------------------------

DrawMenu:
	movem.l	a2-a3,-(a7)
	move.l	#apilib::MenuComponent,a3
	bsr	_drawmenu
	movem.l	(a7)+,a2-a3
	rts

_drawmenu:	;used also in pmenu.mdl for the plugin menu
	bsr	SelectMenu			;Select menu
	clr.w   d1
	bsr     FontSet
	bsr	_drawmnu
	bsr	SelectMenu			;Select menu
	rts

_drawmnu:
	suba.w  #3850,a7
	exg.l   a1,a2
	move.l  a7,a1
	jsr     apilib::ScreenToBuffer
	exg.l   a1,a2
	jsr	(a3)
	exg.l   a1,a2
	jsr     apilib::BufferToScreen
	adda.w  #3850,a7

	move.l  d1,-(a7)                ;Save d1
	moveq.w #1,d1
	bsr     FontSet
	move.l  (a7)+,d1
	rts
	
;-----------------------------------------------------------
; Common api92CB_lvKey callback function called by the
; menu component
;-----------------------------------------------------------
mnuGeneralKeys:
	cmp.w   #264,d0
	beq.s   \exit

	cmp.w   #13,d0
	bne.s   \noenter
	move.l  $14(a6),a0      ;MNU_ITEMPROP
	move.l  a0,d2
	beq.s   \exit
	adda.w  d6,a0
	btst.b  #0,(a0)
	bne.s   \exit

\noenter cmp.w  #PAD_LEFT,d0
	beq.s   \exit
	cmp.w   #PAD_RIGHT,d0
	beq.s   \exit
	cmp.w   #KM_FILE,d0
	beq.s   \exit
	cmp.w   #KM_SECURE,d0
	beq.s   \exit
	cmp.w   #KM_TOOLS,d0
	beq.s   \exit
	cmp.w	#KM_PLUGIN,d0
	beq.s	\exit
	clr.w   d0
\exit   rts


mnuToolsKeys:
	cmp.w	#5,d6
	bne.s	\skip
	cmp.w	#13,d0
	beq.s	\memf
	cmp.w	#PAD_RIGHT,d0
	bne.s	\skip

\memf	bsr     SelectSavedFilter
	add.w	#$2121,d0		;$2122=ok
	bra.s	\exit

\skip	bsr	mnuGeneralKeys
\exit	rts


;------------------------------------------------------
;input>	a0.l : addr of MenuItems state structure
;
; 8 bytes : File
; 2 bytes : Secure
; 4 bytes : Tools
;------------------------------------------------------
SetMenuItemsState:
	movem.l	a0-a1,-(a7)

	lea	mnuFileProperties(PC),a1
	move.l	(a0)+,(a1)+
;#ifdef TIPLUS
	move.l	(a0)+,(a1)+
;#else
	move.w	(a0)+,(a1)+
	addq.l	#2,a0
;#endif
	lea	mnuSecureProperties(PC),a1
	move.w	(a0)+,(a1)+

	lea	mnuToolsProperties(PC),a1
	move.l	(a0)+,(a1)+

	movem.l	(a7)+,a0-a1
	rts


;-----------------------------------------------------------
;input>	d4.w : key value
;-----------------------------------------------------------
SelectMenu:
	movem.l	d4/a0,-(a7)
	sub.w	#KM_FILE,d4		;index
	cmp.w	#3,d4
	bhi.s	\exit
	lsl.w	#2,d4
	lea	mnu_rects1(PC,d4),a0
	jsr	apilib::sInvertArea
	lea	mnu_rects2(PC,d4),a0
	jsr	apilib::sInvertArea
\exit	movem.l	(a7)+,d4/a0
	rts

;#ifdef FRENCH
SLCT_MENU_F	equ	32
SLCT_MENU_S	equ	34
SLCT_MENU_O	equ	24
SLCT_MENU_P	equ	30
;#else
;#ifdef SPANISH
SLCT_MENU_F	equ	34
SLCT_MENU_S	equ	39
SLCT_MENU_O	equ	32
SLCT_MENU_P	equ	30
;#else
SLCT_MENU_F	equ	22
SLCT_MENU_S	equ	30
SLCT_MENU_O	equ	24
SLCT_MENU_P	equ	30
;#endif
;#endif

mnu_rects1:
	dc.b	IM_FILE-2,2,SLCT_MENU_F,9
	dc.b	IM_SECURE-2,2,SLCT_MENU_S,9
	dc.b	IM_TOOLS-2,2,SLCT_MENU_O,9
	dc.b	IM_PLUGINS-2,2,SLCT_MENU_P,9

mnu_rects2:
	dc.b	IM_FILE-2,2,SLCT_MENU_F-1,8
	dc.b	IM_SECURE-2,2,SLCT_MENU_S-1,8
	dc.b	IM_TOOLS-2,2,SLCT_MENU_O-1,8
	dc.b	IM_PLUGINS-2,2,SLCT_MENU_P-1,8


;=========================================================
; Definition of structures
;=========================================================

;#ifdef TI89
FMENUX  equ     5
SMENUX	equ	25
TMENUX  equ     55
PMENUX  equ     53
;#else
FMENUX  equ     5
SMENUX	equ	50
TMENUX  equ     100
PMENUX  equ     135
;#endif

OMENUX	equ	PMENUX		;tmp


;---------------------------------------------------------
; File Menu
;---------------------------------------------------------
	ds.w    0
mnuFileHeader:
;#ifdef TIPLUS
	dc.w    10                      ;archive/unarchive
;#else
	dc.w    7			;NbItems
;#endif
	dc.w    FMENUX,12               ;X,Y
	dc.w    0                       ;Save Position
	dc.w    74                      ;Width
	dc.b    %00000110
	dc.b    0
	dc.l    mnuGeneralKeys          ;Keys
	dc.l    0                       ;DrawItem
	dc.l    mnuFileProperties       ;Properties
	dc.l    mnuFileShortKey         ;ShortCut
mnuFileShortKey:
	dc.w    57              ;X offset
	dc.b    127,"C",0
	dc.b    127,"M",0
	dc.b    127,"R",0
	dc.b    "<-",0
	dc.b    127,"N",0
;#ifdef TIPLUS
	dc.b    0
	dc.b    127,"A",0
;#ifdef TI89
	dc.b    "2+U",0
;#else
	dc.b    127,"U",0
;#endif
;#endif
	dc.b    0
	dc.b    "ESC",0

	ds.w    0               ;align it
mnuFileProperties:
	dc.b    1,1,1,1,1,1,1,1,1,1


;---------------------------------------------------------
; Link Menu
;---------------------------------------------------------
mnuLinkHeader:
	dc.w	7
	dc.w    FMENUX,12               ;X,Y
	dc.w    0                       ;Save Position
	dc.w    90			;Width
	dc.b    %00000110
	dc.b    0
	dc.l    0         		;Keys
	dc.l    0                       ;DrawItem
	dc.l    mnuLinkProperties       ;Properties
	dc.l    mnuLinkShortKey         ;ShortCut
mnuLinkShortKey:
	dc.w    73              	;X offset
	dc.b    127,"R",0
	dc.b    0
	dc.b	"F5",0
	dc.b	0
	dc.b	0
	dc.b	0
	dc.b    "ESC",0

mnuLinkProperties:
	dc.b    1,1,1,1,1,1,1


;---------------------------------------------------------
; Secure Menu
;---------------------------------------------------------
	ds.w    0
mnuSecureHeader:
	dc.w    5                       ;NbItems
	dc.w    SMENUX,12               ;X,Y
	dc.w    0                       ;Save Position
	dc.w    75                      ;Width
	dc.b    %00000110
	dc.b    0
	dc.l    mnuGeneralKeys          ;Keys
	dc.l    0                       ;DrawItem
	dc.l    mnuSecureProperties     ;Properties
	dc.l    mnuSecureShortKey       ;ShortCut
mnuSecureShortKey:
	dc.w    60                      ;X offset
	dc.b    127,"L",0
	dc.b    127,"H",0
	dc.b    0
	dc.b    127,"P",0
	dc.b    0

	; mnuSecureProperties in cfgfile

	ds.w	0			;align it



;---------------------------------------------------------
; Tools Menu
;---------------------------------------------------------
	ds.w    0
mnuToolsHeader:
	dc.w	7                       ;NbItems
	dc.w    TMENUX,12               ;X,Y
	dc.w    0                       ;Save Position
	dc.w    84                      ;Width
	dc.b    %00000110
	dc.b    0
	dc.l    mnuToolsKeys		;Keys
	dc.l    0                       ;DrawItem
	dc.l    mnuToolsProperties        ;Properties
	dc.l    mnuToolsShortKey          ;ShortCut
mnuToolsShortKey:
	dc.w    70                      ;X offset
	dc.b    "F5",0
	dc.b    0
	dc.b    0
	dc.b    0
	dc.b    0
	dc.b	0
	dc.b	0

	ds.w	0			;align it
mnuToolsProperties:
	dc.b    1,1,1,1,1,1,1


	ds.w	0
