;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		cfgfile.mdl
;	Utility>	Configuration File Management
;
;-----------------------------------------------------------

CFGFILE_SLENGTH	equ	8	;Signature & Version length

CFGFILE_VERSION equ	$0102	;version of v0.97




;--------------------------------------------------------------
; Configuration File Management :
;
; 0      -----------------------
;	|  DATA SAVED 	     	|
;	| BETWEEN TWO SESSIONS  |
;	 -----------------------
;	| Association		|
;	|   Programs		|
;	 -----------------------
;	| Filters		|
;	 -----------------------
;
; Offset of :	signature 			: 2
;		Data				: 2+CFGFILE_SLENGTH
;		Association Prog		: 2+CFGFILE_SLENGTH+PCT_DATA-PCT_SAVED_DATA
;		Filters				: variable
;
;--------------------------------------------------------------


;--------------------------------------------------------------
; Read data from CFG File to restore them in PCTOOLS
;Input>	/
;Out>	d0.w : 0 if error
;--------------------------------------------------------------
CFG_ReadData:
	movem.l	d1/a0,-(a7)
	;-----------------------------------
	; Get Addr and check if just created
	;-----------------------------------
	bsr	CFG_DataAddr
	tst.w	d0
	beq.s	\exit
	tst.w	d1				;if just created, reset DATA section
	bne.s	\reset				;


	;-----------------------------------
	; Copy data from file to PCTOOLS
	;-----------------------------------
	lea	PCT_SAVED_DATA(PC),a1
	moveq.w	#(PCT_DATA-PCT_SAVED_DATA)-1,d1
\copy	move.b	(a0)+,(a1)+
	dbra.s	d1,\copy

\exit	movem.l	(a7)+,d1/a0
	rts

	;-----------------------------------
	; Reset data section
	;-----------------------------------
\reset	bsr	CFG_ResetData
	bra.s	\exit


;--------------------------------------------------------------
; Save data to CFG File
;Input>	/
;Out>	d0.w : 0 if error 
;--------------------------------------------------------------
CFG_SaveData:
	movem.l	d1/a0,-(a7)
	;-----------------------------------
	; Get Addr
	;-----------------------------------
	bsr	CFG_DataAddr
	tst.w	d0
	beq.s	\exit
	
	;-----------------------------------
	; Copy data from PCTOOLS to the file
	;-----------------------------------
	lea	PCT_SAVED_DATA(PC),a1
	moveq.w	#(PCT_DATA-PCT_SAVED_DATA)-1,d1
\copy	move.b	(a1)+,(a0)+
	dbra.s	d1,\copy

\exit	movem.l	(a7)+,d1/a0
	rts


;--------------------------------------------------------------
; Reset the DATA section of CFG file
;Input>	/
;Out>	d0.w : 0 if error 
;--------------------------------------------------------------
CFG_ResetData:
	movem.l	d0/a0-a1,-(a7)

	lea	DEFAULTDATA(PC),a0
	lea	PCT_SAVED_DATA(PC),a1
	moveq.w	#(PCT_DATA-PCT_SAVED_DATA)-1,d0

\copy	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy

	movem.l	(a7)+,d0/a0-a1
	rts

;--------------------------------------------------------------
; Look for the CFG file in the MAIN directory of the calculator
; Create it if not found
;
;Input> Nothing
;Out>	d0.w : Handle of the file, 0 if error
;	d1.w : if 1, Just created
;	a0.l : Addr of data
;--------------------------------------------------------------
Find_CFG_File:

	movem.l	d2-d4/a1-a2,-(a7)

	;-------------------------------------
	;Look for file in MAIN
	;-------------------------------------
	API92_MAINHDL d0
	lea	CFGFile(PC),a0
	jsr	apilib::vat_Find
	move.w	d1,d0			;if not found create
	beq	\create

;#ifdef TIPLUS
	;-------------------------------------
	; Check if it is archived, and 
	; unarchives it if necessary
	;-------------------------------------
	move.l	d0,-(a7)
	btst.b  #ARCH_BIT,ENTRYFLG(a1)
	beq.s   \noarch
	subq.w	#1,d2
	API92_MAINHDL d0
	jsr	apilib::vat_UnarchiveVar
\noarch	move.l	(a7)+,d0
;#endif

	;-------------------------------------
	; If found, check if signature valid
	;-------------------------------------
	bsr	DEREFd0a0		;Get Addr
	lea	2(a0),a1		;Save addr for next use

	cmp.l	#'PCTC',(a1)+
	bne.s	\delete
	cmp.w	#'FG',(a1)+
	bne.s	\delete

	;-------------------------------------
	; Check if version is valid
	;-------------------------------------
	cmp.w	#CFGFILE_VERSION,(a1)+
	bne.s	\delete

	;-------------------------------------
	; Check if extension is valid
	;-------------------------------------
	move.w	(a0),d1			;file size
	lea	2(a0,d1.l),a2		;get end of file
	cmp.b	#$F8,-(a2)		;Check extension
	bne.s	\delete			;if not valid, delete file
	tst.b	-(a2)
	bne.s	\delete
	cmp.b	#'G',-(a2)
	bne.s	\delete
	cmp.b	#'F',-(a2)
	bne.s	\delete
	cmp.b	#'C',-(a2)
	bne.s	\delete

	clr.l	d1			;not created

\ok	bsr	DEREFd0a0		;return addr in a0, hdl in d0
	
\exit	movem.l	(a7)+,d2-d4/a1-a2
	rts

	;-------------------------------------
	; If error return 0
	;-------------------------------------
\error	clr.l	d0			;Error
	bra.s	\exit


	;-------------------------------------
	; Delete the file if invalid
	;-------------------------------------
\delete	API92_MAINHDL d0
	lea	CFGFile(PC),a0
	jsr	apilib::vat_Find
	tst.w	d2
	beq.s	\error
	subq.w	#1,d2
	jsr	apilib::vat_Delete

	;-------------------------------------
	; Create the file if it doesn't exist
	;-------------------------------------
\create	bsr	Create_CFG_File
	tst.w	d1			;If Error during creation
	bne.s	\error
	moveq.l	#1,d1			;File just created
	bra.s	\ok


;--------------------------------------------------------------
; Get Data addr in CFG File
;
;Input> Nothing
;Out>	d0.w : Handle of the file, 0 if error
;	d1.w : if 1, Just created
;	a0.l : Addr
;--------------------------------------------------------------
CFG_DataAddr:
	bsr	Find_CFG_File
	adda.w	#2+CFGFILE_SLENGTH,a0
	rts

;--------------------------------------------------------------
; Get 'Asociation Program' array addr in CFG File
;
;Input> Nothing
;Out>	d0.w : Handle of the file, 0 if error
;	a0.l : Addr of nb items in the array
;--------------------------------------------------------------
CFG_AssoAddr:
	move.l	d1,-(a7)
	bsr	Find_CFG_File
	adda.w	#(PCT_DATA-PCT_SAVED_DATA)+2+CFGFILE_SLENGTH+2,a0
	move.l	(a7)+,d1
	rts

;--------------------------------------------------------------
; Get 'Filter' array addr in CFG File
;
;Input> Nothing
;Out>	d0.w : Handle of the file, 0 if error
;	a0.l : Addr
;--------------------------------------------------------------
CFG_FilterAddr:
	move.l	d1,-(a7)

	bsr	Find_CFG_File
	tst.w	d0				;Check if error
	beq.s	\exit

	bsr	CFG_FilterOffset
	adda.w	d2,a0
	
\exit	move.l	(a7)+,d1
	rts

;--------------------------------------------------------------
;Input>	d0.w : Handle of CFG file
;Out>	d2.w : Offset
;--------------------------------------------------------------
CFG_FilterOffset:
	move.l	a0,-(a7)
	bsr	DEREFd0a0			;Get Addr
	adda.w	#(PCT_DATA-PCT_SAVED_DATA)+2+CFGFILE_SLENGTH,a0		;asso offset
	move.w	(a0),d2				;Get size of the 'Association Programs' array
	mulu.w	#ASSOITEM_SIZE,d2
	add.w	#(PCT_DATA-PCT_SAVED_DATA)+2+CFGFILE_SLENGTH+4,d2		;+4 for the Asso array
	move.l	(a7)+,a0
	rts


;--------------------------------------------------------------
; Create CFG File in the MAIN directory
;
;Input> Nothing
;Out>	d0.w : Handle of the file, 0 if error
;	d1.w : Error Code
;	a0.l : Addr of the file
;--------------------------------------------------------------
Create_CFG_File:
	movem.l	d2-d4/a1-a2,-(a7)

	;-------------------------------------
	; Create the var in the VAT
	;-------------------------------------
	API92_MAINHDL d0		;folder
	moveq.w	#0,d1				;flag
	move.w	#(PCT_DATA-PCT_SAVED_DATA)+8+CFGFILE_SLENGTH,d2	;size
	lea	CFGFile(PC),a0			;Name
	jsr	apilib::vat_CreateVar		;Create Var
	tst.w	d1
	bne.s	\error

	bsr	DEREFd0a0			;Get addr

	;-------------------------------------
	; Put extension
	;-------------------------------------
	lea	(PCT_DATA-PCT_SAVED_DATA)+8+CFGFILE_SLENGTH+2(a0),a1
	move.b	#$F8,-(a1)			;put string
	clr.b	-(a1)
	move.b	#'G',-(a1)
	move.b	#'F',-(a1)
	move.b	#'C',-(a1)
	clr.b	-(a1)

	;-------------------------------------
	; Put Signature
	;-------------------------------------
	addq.l	#2,a0
	move.l	#'PCTC',(a0)+
	move.w	#'FG',(a0)+
	
	;-------------------------------------
	; Put Version
	;-------------------------------------
	move.w	#CFGFILE_VERSION,(a0)+


	;-------------------------------------
	; Copy default data
	;-------------------------------------


	;-------------------------------------
	; Create 'Association Programs' array
	; (see associat.mdl)
	;-------------------------------------
	moveq.w	#ASSOITEM_SIZE,d1
	moveq.w	#(PCT_DATA-PCT_SAVED_DATA)+2+CFGFILE_SLENGTH,d2	;offset
	jsr	apilib::array_fCreate				;d0 already file hdl
	tst.w	d0
	beq.s	\error

	bsr	DEREFd0a0					;its addr
	adda.w	#(PCT_DATA-PCT_SAVED_DATA)+2+CFGFILE_SLENGTH+2,a0	;+2 to skip first word of the array
	move.w	#(end_DefaultAssoFile-DefaultAssoFile)-1,d1
	lea	DefaultAssoFile(PC),a1
\copydefault move.b (a1)+,(a0)+
	dbra.s	d1,\copydefault


	;-------------------------------------
	; Create 'Filters' array
	; (see Filter_w.mdl)
	;-------------------------------------
	moveq.w	#FILTERENTRY_SIZE,d1		;size of each item
	bsr	CFG_FilterOffset		;return offset in d2
	jsr	apilib::array_fCreate		;
	tst.w	d0
	beq.s	\error

	;-------------------------------------
	; If successful...
	;-------------------------------------
	bsr	DEREFd0a0			;Get addr for output
	clr.l	d1				:No Error
\exit	movem.l	(a7)+,d2-d4/a1-a2
	rts


\error	clr.w	d0
	bra.s	\exit


;--------------------------------------------------------------
; Save style and file/folder selection for next session
;
;Input> d6,d7,a6 : global registers
;Out>	
;--------------------------------------------------------------
SaveUserPosition:
	movem.l	d0/a4,-(a7)
	lea	session_style(PC),a4

	;-----------------------------------
	; save session_style for next session
	; If link or plugin style, come
	; back to virtual style
	;-----------------------------------
	bsr	GetCurrentStyleID
	cmp.w	#STYLEID_TREEF,d0
	ble.s	\nozero
	clr.w	d0
\nozero	move.w	d0,(a4)				;set session ID

	;-----------------------------------
	; all styles:save d6/d7 position
	;-----------------------------------
	move.w	d6,2(a4)
	move.w	d7,4(a4)


	cmp.w	#STYLEID_TREEF,d0
	beq.s	\treefile
	cmp.w	#STYLEID_TREE,d0
	bne.s	\exit

	;-----------------------------------
	; Tree, folder side
	;-----------------------------------
	move.w	file_d6(PC),8(a4)		;save file pos
	move.w	file_d7(PC),10(a4)
	move.w	file_lasthdl,6(a4)	;
	bra.s	\exit

\treefile move.w folder_d6(PC),2(a4)		;save folder pos
	move.w	folder_d7(PC),4(a4)
	move.w	d6,8(a4)
	move.w	d7,10(a4)
	move.w	ListReal_Hdl(PC),6(a4)		;

\exit	movem.l	(a7)+,d0/a4
	rts


;--------------------------------------------------------------
; Restore style and file/folder selection
;
;Input> Nothing
;Out>	A6.l 	: style addr
;	d6,d7	: global registers
;--------------------------------------------------------------
RestoreUserPosition:
	move.l	a4,-(a7)

	lea	session_style(PC),a4

	tst	(a4)			;test session_style
	beq.s	\exit

	move.w	2(a4),d6		;Set d6/d7
	move.w	4(a4),d7

	cmp.w	#STYLEID_TREEF,(a4)	;if tree, file side
	beq.s	\treefile
	cmp.w	#STYLEID_TREE,(a4)
	bne.s	\exit

	move.w	8(a4),file_d6
	move.w	10(a4),file_d7
	move.w	6(a4),file_lasthdl
	bra.s	\exit

\treefile
	move.w	8(a4),file_d6
	move.w	10(a4),file_d7
	move.w	6(a4),file_lasthdl
	bsr	tree_SetFocusOnFile

\exit	move.l	(a7)+,a4
	rts

CFGFile:	dc.b	"pctdata",0

	ds.w	0

;----------------------------------------------------------------
PCT_SAVED_DATA:

; NormalExit is set to 1 at PCTools launching, et set to 0 before
; exiting.
; So if NormalExit=1 at lauching, it will reset some saved data
; (ListBuf_Hdl, ListReal_Hdl, session_savedx, session_style)

NormalExit		dc.w	0			;


ListBuf_Hdl		dc.w	0
ListReal_Hdl		dc.w	0

FilterProperties:	dcb.b	NB_EXT,%00000111
			ds.w	0
AdvFilterProperties:
			dc.b	%00000111,%00000111,%00000011
			dc.b	%00000111,%00000111,%00000111
			dc.b	%00000111
			ds.w	0

FilterList_CheckArray:	dcb.b	NB_EXT,1
			ds.w	0


strPassword	dc.b	0,0,0,0,0,0,0,0,0,0,0,0

mnuShortByProperties:	dc.b    7,3,3,3
mnuStyleProperties:	dc.b    3,3,7,3
mnuSecureProperties:	dc.b    1,1,1,1,3
optIProperties:		dc.b	7,7

session_style		dc.w	0			;save which style was used

session_saved6		dc.w	0			;session_saved6
session_saved7		dc.w	0			;session_saved7

session_tree_hdl	dc.w	0
session_tree_d6		dc.w	0
session_tree_d7		dc.w	0

;------------------------------
; For future use
;------------------------------
			dc.w	0
			dc.l	0
			dc.l	0
			dc.l	0
			dc.l	0

	ds.w	0

;----------------------------------------------------------------
PCT_DATA:


DEFAULTDATA:
			dc.w	0

			dc.w	0
			dc.w	0

			dcb.b	NB_EXT,%00000111
			ds.w	0

			dc.b	%00000111,%00000111,%00000011
			dc.b	%00000111,%00000111,%00000111
			dc.b	%00000111
			ds.w	0

			dcb.b	NB_EXT,1
			ds.w	0


			dc.b	0,0,0,0,0,0,0,0,0,0,0,0

			dc.b    7,3,3,3
			dc.b    3,3,7,3
			dc.b    1,1,1,1,3
			dc.b	7,7

			dc.w	0			;session_saved6
			dc.w	0			;session_saved7

			dc.w	0			;session_style

			dc.w	0			;session_tree_fhdl

;------------------------------
; For future use
;------------------------------
			dc.w	0
			dc.l	0
			dc.l	0
			dc.l	0
			dc.l	0
			dc.l	0


save_a7		dc.l	0
NbItem		dc.w	0
PluginTableAddr	dc.l	0


;----------------------------------------------------------------

	ds.w	0
