;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		gfx.xas
;	Utility>	Definition of GFXs
;
;-----------------------------------------------------------



;-------------------------------------------------
;ST_Message
;input> a2.l : addr of msg
;-------------------------------------------------
ST_Message:
	movem.l d0-d2/a0-a1,-(a7)
	move.l  a2,-(a7)
;#ifdef TIPLUS
	TIOS_CALL ST_helpMsg        ;else it crash
;#else
	TIOS_CALL ST_showHelp
;#endif
	addq.l  #4,a7

;#ifdef TIPLUS
;#else
	bclr.b  #7,tios::ST_flags+2
;#endif

	move.w  #$00,-(a7)
	TIOS_CALL ST_busy
	addq.l  #2,a7

	movem.l (a7)+,d0-d2/a0-a1
	rts


;---------------------------------------------------
;Clear the status bar
;---------------------------------------------------
ClearBar:
ClearStatusBar:
	movem.l d0-d1/a0,-(a7)

;#ifdef TI89
	move.l	#LCD_MEM+94*30,a0
;#else
	move.l  #LCD_MEM+3660,a0
;#endif
	moveq.w #44,d0          	;(6*30)/4 -1 laps
\clr    clr.l   (a0)+
	dbra.s  d0,\clr

	movem.l (a7)+,d0-d1/a0
	rts

;-------------------------------------------------
; Redraw all the interface
;-------------------------------------------------
RedrawInterface:
	movem.l d0-d4/a0-a2,-(a7)

	INTERRUPT_OFF

	move.l  #LCD_MEM,a0
	move.w  #225,d0
\clr    clr.l   (a0)+
	dbra.s  d0,\clr

	lea     ieInterface(PC),a0
	jsr     apilib::InterfaceEngine

	moveq.w #ANGLE1_GFX,d2
	clr.w   d0
	clr.w   d1
	bsr     PutImg
	moveq.w #ANGLE2_GFX,d2
	moveq.w #(WLCD/8)-1,d0
	bsr     PutImg

	bsr     StyleInterface          ;draw interface of current style
	bsr     Refresh_UpBar           ;refresh UpBar

	INTERRUPT_ON

	movem.l (a7)+,d0-d4/a0-a2
	rts

;-------------------------------------------------
; Redraw the screen
;-------------------------------------------------
RedrawScreen:
	movem.l d0-d5/a0-a2,-(a7)
	bsr.s   RedrawInterface
	bsr     RedrawListArea
	movem.l (a7)+,d0-d5/a0-a2
	rts

;-------------------------------------------------
; Redraw the list, without re-creating it
;-------------------------------------------------
RedrawList_WML:
	bsr     GetListBufAddr
	move.l  a0,a2
	bra	_Rd_WML


;----------------------------------------------------
; Print the char d2
; at x=d0 and y=d1
;----------------------------------------------------
printchar:
        jmp     apilib::draw_CharSpecial

;-----------------------------------------------------
;       printf
; input :       a0 : adress of data & string
; format :      x,y,text
;-----------------------------------------------------
printf:
        jmp     apilib::draw_sString

;---------------------------------------------------
;input>         a0.l : address of struct
;---------------------------------------------------
printlist:
	clr.w   d3
	move.b  (a0)+,d3
	clr.w   d0
\Print  move.b  (a0)+,d0        ;
	bsr.s   printf
	adda.w  d0,a0
	dbra.s  d3,\Print
	rts

;-------------------------------------------------
;Set the d1 Font
;------------------------------------------------
FontSet:
	movem.l	d0-d2/a0-a2,-(a7)
	move.w  d1,-(a7)
	TIOS_CALL FontSetSys
	addq.l  #2,a7
	movem.l	(a7)+,d0-d2/a0-a2
	rts

;-----------------------------------------------
;The most PCT prints must use this function
;
;input> d0.w : X
;       d1.w : Y
;       a1.l : addr of text
;----------------------------------------------- 
PrintSp:
        jmp     apilib::draw_StringSpecial



;----------------------------------------------------
;       inverse
; Input :       d0.w : X (0<X<30)
;               d1.w : Y (0<Y<128)
;               d2.w : Width-1 (between 1 & 30)
;               d3.w : height-1
;----------------------------------------------------
inverse:
	movem.l d0-d3/a0,-(a7)

	move.l  #LCD_MEM,a0
	mulu.w  #30,d1
	adda.w  d1,a0
	adda.w  d0,a0

\line   move.w  d2,d1
\row    not.b   0(a0,d1.w)
	dbra.s  d1,\row
	lea     30(a0),a0       ;adda.w #30,a0
	dbra.s  d3,\line

	movem.l (a7)+,d0-d3/a0
	rts
;-----------------------------------------------------
; PutImg
; d0.w : col
; d1.w : row
; d2.w : GFX to put (num) 
;  DON'T CHANGE REGISTERS
;-----------------------------------------------------
PutImg:
	movem.l a0-a1/d0-d3,-(a7)
	lea     GFX_ADR(PC),a0
	lsl.w   #3,d2
	adda.w  d2,a0

_PutImg:
	move.l  #LCD_MEM,a1
	mulu.w  #30,d1
	add.w   d1,d0
	adda.w  d0,a1
	moveq.w #7,d3
\cpy    move.b  (a0)+,(a1)
	lea     30(a1),a1       ;adda.w #30,a1
	dbra.s  d3,\cpy
	movem.l (a7)+,a0-a1/d0-d3
	rts

;-----------------------------------------------------
; PutImg
; d0.w : col
; d1.w : row
; a0.l : address of 8x8 picture
;  DON'T CHANGE REGISTERS
;-----------------------------------------------------
PutImgAddr:
	movem.l a0-a1/d0-d3,-(a7)
	bra.s	_PutImg

;-----------------------------------------------------
;       DrawRect
; input :       a0 : adress of data 
; format :      x1,y1,x2,y2
;-----------------------------------------------------
DrawRect:
        jmp     apilib::draw_sSolidRect
        


GFX_ADR:

TI_GFX		equ	0
FOLD_GFX 	equ	1
BACK_GFX 	equ	2
FILE_GFX	equ	3
FARG_GFX	equ	4
EXE_GFX		equ	4
IMG_GFX		equ	5
TXT_GFX		equ	6
PSW_GFX		equ	7
LIB_GFX		equ	8
ANGLE1_GFX	equ	9
ANGLE2_GFX	equ	10
SYSTEM_GFX	equ	11
HOME_GFX	equ	12
LINK_GFX	equ	13
PLUGIN_GFX	equ	14
FOLD+_GFX	equ	15
FOLD-_GFX	equ	16
TI89_GFX	equ	17
TI92_GFX	equ	18


; TI92 picture
tigfx:	

;#ifdef TI89
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%00111100
	dc.b	%00000000
;#else
	dc.b	%00000000
	dc.b	%01111110
	dc.b	%10100101
	dc.b	%10111101
	dc.b	%10000001
	dc.b	%10000001
	dc.b	%01111110
	dc.b	%00000000
;#endif

; Folder picture
dirgfx:	
	dc.b	%00000000
	dc.b	%01100000
	dc.b	%10011100
	dc.b	%10000010
	dc.b	%10000010
	dc.b	%10000010
	dc.b	%01111110
	dc.b	%00000000

; Back picture
backgfx:	
	dc.b	%00000000
	dc.b	%00111100
	dc.b	%00011100
	dc.b	%00111100
	dc.b	%01110100
	dc.b	%01100000
	dc.b	%01000000
	dc.b	%00100000


filegfx:
	dc.b	%01111000
	dc.b	%01000100
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%01111110
	dc.b	%00000000

execgfx
	dc.b	%00000000
	dc.b	%01111110
	dc.b	%01111110
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%01111110
	dc.b	%00000000

imggfx:
	dc.b	%01111000
	dc.b	%01000100
	dc.b	%01011010
	dc.b	%01011010
	dc.b	%01011010
	dc.b	%01000010
	dc.b	%01111110
	dc.b	%00000000

txtgfx:
	dc.b	%01111000
	dc.b	%01000100
	dc.b	%01011010
	dc.b	%01000010
	dc.b	%01011010
	dc.b	%01000010
	dc.b	%01111110
	dc.b	%00000000

passgfx:
	dc.b	%00000000
	dc.b	%01100000
	dc.b	%10011100
	dc.b	%10000010
	dc.b	%10111010
	dc.b	%10000010
	dc.b	%01111110
	dc.b	%00000000


libgfx	dc.b	%00000000
	dc.b	%00111110
	dc.b	%00100010
	dc.b	%11111010
	dc.b	%10001110
	dc.b	%10001000
	dc.b	%11111000
	dc.b	%00000000


;pctgfx	dc.b	%00000000
;	dc.b	%01111110
;	dc.b	%11000011
;	dc.b	%01011010
;	dc.b	%11011011
;	dc.b	%01011010
;	dc.b	%11000011
;	dc.b	%01111110


angle1gfx
	dc.b	%00000001
	dc.b	%00000111
	dc.b	%00011111
	dc.b	%00111111
	dc.b	%01111111
	dc.b	%01111111
	dc.b	%11111111
	dc.b	%11111111

angle2gfx
	dc.b	%10000000
	dc.b	%11100000
	dc.b	%11111000
	dc.b	%11111100
	dc.b	%11111110
	dc.b	%11111110
	dc.b	%11111111
	dc.b	%11111111

systgfx	dc.b	%01111110
	dc.b	%11011011
	dc.b	%01000010
	dc.b	%11000011
	dc.b	%01000010
	dc.b	%11000011
	dc.b	%01111110
	dc.b	%00000000

homegfx	dc.b	%00111100
	dc.b	%01000010
	dc.b	%10101001
	dc.b	%10111001
	dc.b	%10101001
	dc.b	%01000010
	dc.b	%00111100
	dc.b	%00000000

linkgfx	dc.b	%00000000
	dc.b	%00010000
	dc.b	%00101000
	dc.b	%00111000
	dc.b	%00101000
	dc.b	%01101100
	dc.b	%01111100
	dc.b	%01111100

plggfx	dc.b	%00000000
	dc.b	%00111000
	dc.b	%00101000
	dc.b	%11101110
	dc.b	%10000010
	dc.b	%11101110
	dc.b	%00101000
	dc.b	%00111000

foldp:	dc.b	%00000000
	dc.b	%01100000
	dc.b	%10011100
	dc.b	%10010010
	dc.b	%10111010
	dc.b	%10010010
	dc.b	%01111110
	dc.b	%00000000

foldm:	dc.b	%00000000
	dc.b	%01100000
	dc.b	%10011100
	dc.b	%10000010
	dc.b	%10111010
	dc.b	%10000010
	dc.b	%01111110
	dc.b	%00000000

ti89gfx:
	dc.b	%01111110
	dc.b	%01100110
	dc.b	%01111110
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%01000010
	dc.b	%00111100
	dc.b	%00000000
ti92gfx:
	dc.b	%00000000
	dc.b	%01111110
	dc.b	%10100101
	dc.b	%10111101
	dc.b	%10000001
	dc.b	%10000001
	dc.b	%01111110
	dc.b	%00000000



gfxBatteries:
	dc.w	%1111111111111110
	dc.w	%1111000000000010
	dc.w	%1110000000000011
	dc.w	%1110000000000011
	dc.w	%1100000000000010
	dc.w	%1111111111111110

	dc.w	%1111111111111110
	dc.w	%1111111000000010
	dc.w	%1111110000000011
	dc.w	%1111110000000011
	dc.w	%1111100000000010
	dc.w	%1111111111111110


	dc.w	%1111111111111110
	dc.w	%1111111100000010
	dc.w	%1111111000000011
	dc.w	%1111111000000011
	dc.w	%1111110000000010
	dc.w	%1111111111111110


	dc.w	%1111111111111110
	dc.w	%1111111111100010
	dc.w	%1111111111000011
	dc.w	%1111111111000011
	dc.w	%1111111110000010
	dc.w	%1111111111111110

	dc.w	%1111111111111110
	dc.w	%1111111111111110
	dc.w	%1111111111111111
	dc.w	%1111111111111111
	dc.w	%1111111111111110
	dc.w	%1111111111111110

