;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.10
; FILE DESCRIPTION      : HexView
;			(I program HexView when I was
;			 16 years old, so it is not
;			 very well programed. however,
;			 it works. 
;			 I think I should release a 
;			 totally new versio of HexView
;			 one day
;=====================================================================

	include "tios.h"                ;library includes files
	include	"APILib.h"
	include "APILibCT.h"


	xdef	_main
	xdef	_comment


;#ifdef TI89

NB_LINE	equ	9
Y_START equ	19
OX	equ	-40
OY	equ	-10
PAD_UP          equ     337
PAD_DOWN        equ     340
PAD_LEFT        equ     338
PAD_RIGHT       equ     344

KEY_INFO	equ	'9'
KEY_ADD		equ	'='
KEY_HDL		equ	'8'
KEY_ADDR	equ	'7'
KEY_EDIT	equ	'/'
KEY_FIND	equ	'|'
KEY_VAR		equ	'0'

;#else

NB_LINE	equ	12
Y_START	equ	21
OX	equ	0
OY	equ	0

PAD_UP          equ     338
PAD_DOWN        equ     344
PAD_LEFT        equ     337
PAD_RIGHT       equ     340

KEY_INFO	equ	'i'
KEY_ADD		equ	'a'
KEY_HDL		equ	'h'
KEY_ADDR	equ	'g'
KEY_EDIT	equ	'e'
KEY_FIND	equ	'f'
KEY_VAR		equ	'v'

;#endif

;#ifdef TIPLUS
;#ifdef TI89
	xdef	_ti89
;#else
	xdef	_ti92plus
;#endif
;#endif

;#ifdef TIPLUS
MAINLIST_HDL    equ     tios::MainHandle
;#else
MAINLIST_HDL    equ     $0C
;#endif

	include "pctplug.h"             ;and after we include pctplug.h

;-----------------------------------------------------
; Plugin Header
;-----------------------------------------------------

	PRG_AS_PLUGIN

EXTENSION_FILTER:
	dc.b	0
	ds.w	0

PLUGIN_TABLE:
	dc.l	NOT_USED		;start_of_pct98
	dc.l	NOT_USED		;end_of_pct98
	dc.l	KeyPressed		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	NOT_USED		;enter_pressed
	dc.l	NOT_USED		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	MenuString		;menu_string
	dc.l	MenuFunction		;menu_function
	dc.l	NOT_USED		;compression_service
	dc.l	HideMenu		;hide_menu


END_PLUGIN_TABLE:

;-----------------------------------------------------
; Start of HexView code
;-----------------------------------------------------
StartHexview:
	suba.w	#2200,a7	;stack frame for font & Buff
	move.l	a7,FontAdr	;save stack frame addr


\nokey	tst.w	KEY_PRESSED_FLAG
	beq.s	\skipkey
	jsr	apilib::WaitKey
	bra.s	\nokey
\skipkey

;#ifdef TIPLUS
	move.w	#100,-(a7)
	jsr	tios::OSInitKeyInitDelay
	move.w	d0,d3
	move.w	#15,(a7)
	jsr	tios::OSInitBetweenKeyDelay
	addq.l	#2,a7
	move.w	d0,-(a7)		;save values on the stack
	move.w	d3,-(a7)
;#endif
	
	bclr.b	#2,$600001	;no protected mode error

;#ifdef TIPLUS
        bsr     Read_CFG_File
;#endif
	bsr	InitScreen	;InitInterface
	bsr	SetMode
	bsr	SetMenu

	clr.w	findnext	;no FindNext search
	bsr	Font2Buf	;Copy font to the buffer
	bsr	ShowAll

	;----------------------
	; General Loop:
	; wait for a key hit
	;----------------------
Loop:
\WaitKey tst.b	refresh
	beq.s	\norefresh
	bsr 	ShowAll
\norefresh

;#ifdef TIPLUS
	tst.w	KEY_PRESSED_FLAG
	beq.s	\WaitKey

	jsr	apilib::WaitKey
;#else
	tst.w	tios::kb_vars+$1c
	beq.s	\WaitKey
	move.w	tios::kb_vars+$1e,d0
	clr.w	tios::kb_vars+$1c
;#endif

	cmp.w	#PAD_UP,d0			;Pad UP
	beq	key_up
	cmp.w	#PAD_DOWN,d0			;Pad DOWN
	beq	key_down

	cmp.w	#265,d0
	beq	MainMenu
	cmp.w	#KEY_INFO,d0
	beq	info

	tst.b	mode
	bne.s	\skip

	cmp.w	#KEY_VAR,d0
	beq	gotofile
	cmp.w	#KEY_ADD,d0
	beq	add
	cmp.w	#KEY_ADDR,d0
	beq	go
	cmp.w	#KEY_HDL,d0
	beq	hdl
	cmp.w	#KEY_EDIT,d0
	beq	modifie
	cmp.w	#KEY_FIND,d0		;[F]
	beq	FindN
;#ifdef TIPLUS
	cmp.w	#KEY_DIAMOND+KEY_FIND,d0
	beq	FindN
;#else
	cmp.w	#8262,d0
	beq	Find
;#endif

;#ifdef TIPLUS
	cmp.w	#KEY_DIAMOND+268,d0
	bcs.s	\noDF1
	cmp.w	#KEY_DIAMOND+275,d0
	bls	set_bookmark
;#else
	cmp.w	#8460,d0
	bcs.s	\noDF1
	cmp.w	#8467,d0
	bls	set_bookmark
;#endif

\noDF1	cmp.w	#268,d0
	bcs.s	\noF1
	cmp.w	#275,d0
	bls	go_bookmark

\noF1	lea	PadCodes(PC),a0
	lea	Offsets(PC),a1
	moveq.w	#7,d1			;8-1
\scan	cmp.w	(a0)+,d0
	bne.s	\nopad
	add.l	(a1),a4
	bsr	ShowAll
	bra.s	\skip
\nopad	addq.l	#4,a1
	dbra.s	d1,\scan

\skip	cmp.w	#264,d0			;ESC ?
	bne	Loop

	;----------------------
	; End of program
	;----------------------


Exit:
;#ifdef TIPLUS
	
	jsr	tios::OSInitKeyInitDelay
	addq.l	#2,a7
	jsr	tios::OSInitBetweenKeyDelay
	addq.l	#2,a7
;#endif

	tst.b	mode
	bne.s	\hdlmode
	move.l	a4,hex_addr		;save addr for next session
	bra.s	\end
\hdlmode move.l	a4,hdl_addr

\end	bset.b	#2,$600001		;restore mem protect violation

;#ifdef TIPLUS
        bsr     Save_CFG_File
;#endif

	adda.w	#2200,a7		;delete stack frame
	rts

;-------------------------------------------------------------
; Info
;-------------------------------------------------------------
info:
	lea	win_About(PC),a0
	jsr	apilib::InterfaceEngine
	bsr	ShowAll
	bra	Loop

;-------------------------------------------------------------
; Set mode handle/hexa
;-------------------------------------------------------------
SetMode:
	move.l	a0,-(a7)

	lea	MainMenuProperties(PC),a0

	tst.b	mode
	bne.s	\hdlmode

	move.w	#$0101,(a0)
	move.l	hex_addr(PC),a4
	bra.s	\exit

\hdlmode move.w	#$0,(a0)
	move.l	hdl_addr(PC),a4
	move.l	a4,d0
	bne.s	\exit
	move.l	tios::Heap,a4
	clr.l	d7			;PosScreen

\exit	move.l	(a7)+,a0
	rts


hdl_select:
	move.w  d7,d0				;PosScreen
	lsl.w   #3,d0				;*8
	add.w   #Y_START,d0			;
	mulu.w  #30,d0
	
	move.l  #LCD_MEM,a0
	adda.w  d0,a0

	moveq.w	#7,d0
\loop		move.l	a0,a1
		moveq.w	#6,d1
\line			not.l	(a1)+
			dbra.s	d1,\line
		not.w	(a1)+
		lea	30(a0),a0
	dbra.s	d0,\loop

	rts

hdl_ShowComment:
	movem.l d0-d2/a0-a1,-(a7)

	move.w	#$700,d0
	trap	#1
	move.l	d0,-(a7)

	suba.w	#50,a7
	move.l	a7,a3			;stack frame
	move.w	#$2000,(a3)			;null message

	move.l	a4,d0
	sub.l	tios::Heap,d0
	lsr.w	#2,d0			
	add.w	d7,d0			;d1=selected handle
	beq.s	\skip
	move.l	a3,a0
	jsr	apilib::GetTIOSFileName	;if error or success ok
	
\skip	move.l  a3,-(a7)
;#ifdef TIPLUS
	jsr     tios::ST_helpMsg        ;else it crash
;#else
	jsr     tios::ST_showHelp
;#endif
	addq.l  #4,a7

;#ifdef TIPLUS
;#else
	bclr.b  #7,tios::ST_flags+2
;#endif

	adda.w	#50,a7

	move.l	(a7)+,d0
	trap	#1

	movem.l (a7)+,d0-d2/a0-a1
	rts

;-------------------------------------------------------------
; Pad DOWN routine
;-------------------------------------------------------------
scr_scrolldown:
	move.l	#LCD_MEM+Y_START*30,a0
	move.l	a0,a1
	adda.w	#240,a1
	move.w	#((NB_LINE-1)*8*30)/4-1,d3

\loop	move.l	(a1)+,(a0)+
	dbra.s	d3,\loop
	rts

hdl_scrolldown:
	movem.l	d0-d4/a0-a2,-(a7)

	bsr	hdl_select			;deselect current item

	cmp.w	#NB_LINE-1,d7
	beq.s	\scroll
	addq.l	#1,d7
	bra.s	\exit

\scroll	bsr	scr_scrolldown
	addq.l	#4,a4
	move.l	a4,a0
	lea	(NB_LINE-1)*4(a0),a0
	moveq.w	#((NB_LINE-1)*8+Y_START),d2
	bsr	hdl_ShowLine

\exit	bsr	hdl_select			;select
	bsr	hdl_ShowComment
	movem.l	(a7)+,d0-d4/a0-a2
	rts

hex_scrolldown:
	movem.l	d0-d4/a0-a2,-(a7)

	;------------------------------
	; First scroll screen
	;------------------------------
	bsr	scr_scrolldown
	
	;------------------------------
	; And show next line
	;------------------------------
	addq.l	#8,a4
	move.l	a4,a0
	lea	(NB_LINE-1)*8(a0),a0
	moveq.w	#((NB_LINE-1)*8+Y_START),d2
	bsr	hex_ShowLine

	movem.l	(a7)+,d0-d4/a0-a2
	rts

key_down:
	move.w	#$700,d0		;disable interrupt to make
	trap	#1			;it faster
	move.l	d0,-(a7)

	tst.b	mode
	bne.s	\hdlmode
	bsr.s	hex_scrolldown
	bra.s	\exit

\hdlmode bsr.s	hdl_scrolldown

\exit	move.l	(a7)+,d0
	trap	#1
	bra	Loop

;-----------------------------------------------------
; Pad UP Routine
;-----------------------------------------------------
scr_scrollup:
	move.l	#LCD_MEM+((NB_LINE-1)*8+Y_START)*30,a0
	move.l	a0,a1
	adda.w	#240,a1
	move.w	#((NB_LINE-1)*8*30)/4-1,d3

\loop	move.l	-(a0),-(a1)
	dbra.s	d3,\loop
	rts

hdl_scrollup:
	movem.l	d0-d4/a0-a2,-(a7)

	move.l	d7,d0
	lsl.w	#2,d0			;d0*4
	lea	0(a4,d0.w),a0
	cmp.l	tios::Heap,a0
	beq.s	\end	

	bsr	hdl_select

	tst.w	d7
	beq.s	\scroll
	subq.w	#1,d7
	bra.s	\exit

\scroll	bsr	scr_scrollup
	subq.l	#4,a4
	move.l	a4,a0
	moveq.w	#Y_START,d2
	bsr	hdl_ShowLine

\exit	bsr	hdl_select
	bsr	hdl_ShowComment
\end	movem.l	(a7)+,d0-d4/a0-a2
	rts


hex_scrollup:
	movem.l	d0-d4/a0-a2,-(a7)

	;------------------------------
	; First scroll screen
	;------------------------------
	bsr	scr_scrollup

	;------------------------------
	; And show previous line
	;------------------------------
	subq.l	#8,a4
	move.l	a4,a0
	moveq.w	#Y_START,d2
	bsr	hex_ShowLine

	movem.l	(a7)+,d0-d4/a0-a2
	rts

key_up:
	move.w	#$700,d0		;disable interrupt to make
	trap	#1			;it faster
	move.l	d0,-(a7)

	tst.b	mode
	bne.s	\hdlmode
	bsr.s	hex_scrollup
	bra.s	\exit

\hdlmode bsr.s	hdl_scrollup

\exit	move.l	(a7)+,d0
	trap	#1
	bra	Loop
	
;-----------------------------------------------------
; Go to a saved bookmark
;-----------------------------------------------------
go_bookmark:
	sub.w	#268,d0
	lsl.w	#2,d0
	lea	bookmarks(PC),a0
	move.l	0(a0,d0.w),a4
goLoop:	bsr	ShowAll
	bra	goLoop2

;-----------------------------------------------------
; Set a new bookmark
;-----------------------------------------------------
set_bookmark
;#ifdef TIPLUS
	sub.w	#KEY_DIAMOND+268,d0
;#else
	sub.w	#8460,d0
;#endif
	lsl.w	#2,d0
	lea	bookmarks(PC),a0
	move.l	a4,0(a0,d0.w)
goLoop2: bra	Loop

;-----------------------------------------------------
; Set a new bookmark
;ret : d0,d1
;-----------------------------------------------------
ShowBookMark:
	clr.w	d0
	jsr	apilib::SetFont

	lea	win_BookMark(PC),a0
	jsr	apilib::InterfaceEngine

	lea	header_ShowBookMark(PC),a0
	lea	bookmarks(PC),a1
	jsr	apilib::ListViewComponent

	move.l	d0,-(a7)
	moveq.w	#1,d0
	jsr	apilib::SetFont
	move.l	(a7)+,d0

	rts

lv_BookMarkItem:
	suba.w	#30,a7
	move.l	a7,a3

	movem.l	d0-d2/a0-a1,-(a7)
	addq.w	#1,d6
	move.w	d6,-(a7)
	move.l	(a1),-(a7)
	pea	bm(PC)
	move.l	a3,-(a7)
	jsr	tios::sprintf
	lea	14(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1
	move.l	a3,a1
	jsr	apilib::draw_StringSpecial

	adda.w	#30,a7
	clr.w	d0	;avoid it
	rts

bm:	dc.b	"0h%06lx   F%d",0
	ds.w	0

;-----------------------------------------------------
; Goto function
;-----------------------------------------------------
go	lea	win_GotoAddr(PC),a0
	jsr	apilib::InterfaceEngine

	move.w	#140+OX,d0
	moveq.w	#60+OY,d1
	moveq.w	#5,d2
	bsr	InputHex
	tst.w	d0
	beq.s	\cancel
	move.l	d1,a4

\cancel	bsr	ShowAll
\exit	bra	goLoop2

;-----------------------------------------------------
; Add function
;-----------------------------------------------------
add:	lea	win_Add(PC),a0
	jsr	apilib::InterfaceEngine

	move.w	#100+OX,d0
	moveq.w	#60+OY,d1
	moveq.w	#5,d2
	bsr	InputHex
	tst.w	d0
	beq.s	\cancel
	add.l	d1,a4

\cancel	bsr	ShowAll
\exit	bra	goLoop2


;-----------------------------------------------------
; Goto File
;-----------------------------------------------------
gotofile:
	lea	ie_GotoFile(PC),a0
	jsr	apilib::InterfaceEngine
	lea	header_GotoFile(PC),a0
	jsr	apilib::SelectFileComponent	
	tst.w	d0
	beq.s	\exit

	move.w	d1,d0
	jsr	apilib::DEREFd0a0
	move.l	a0,a4

\exit	bsr	ShowAll
	bra	Loop

;---------------------------------------------------------------------
;Input>	a0.l : addr of struct
;Out>	d0.w = 0 if run, else handle to edit
;---------------------------------------------------------------------
EditHdlOrRun:
	movem.l	d1/a0,-(a7)

	clr.w	d0

	move.l	$8(a0),a1		;addr of STYLE
	btst.b	#0,(a1)			;
	beq.s	\exit			;if no true VAT

	move.w	$10(a0),d0		;get selected handle
	bne.s	\exit			;if not null, it is a file

	tst.w	4(a0)			;item pos
	bne.s	\folder			;if not first item
	move.w	14(a0),d0		;handle of real list buffer
	bra.s	\exit

\folder	move.w	12(a0),d0		;hdl of tmp buffer
	beq.s	\exit
	move.w	4(a0),d1		;item pos
	subq.w	#1,d1
	mulu.w	#VAT_ENTRYSIZE,d1	;VAT_ENTRYSIZE*itempos
	jsr	apilib::DEREFd0a0	;get addr
	add.w	d1,a0
	move.w	VAT_ENTRYHDL+4(a0),d0

\exit	movem.l	(a7)+,d1/a0
	rts

;---------------------------------------------------------------------
; Function called when a key is pressed in PCT98
;---------------------------------------------------------------------
KeyPressed:
	cmp.w	#274,2(a0)	;F7
	beq.s	\validkey
	rtplugin 0

\validkey


MenuFunction:
	bsr	EditHdlOrRun
	tst.w	d0
	beq.s	\run

	jsr	apilib::DEREFd0a0		;if not null, get addr
	move.l	a0,a2
	bsr	Get_CFG_Addr
	move.l	a2,(a0)

\run	clr.b	mode			;hex mode
	bsr	StartHexview
  	rtplugin (REDRAW_SCREEN+SKIP_NEXTPLUGINS+REFRESH_PLUGIN_TABLE)

;-----------------------------------------------------
; Plugin Function :	Called to see which string
;			to show in the menu
;-----------------------------------------------------
HideMenu:
	bsr	EditHdlOrRun

	lea	mnu_s1(PC),a1
	tst.w	d0
	bne.s	\skip
	lea	mnu_s2(PC),a1

\skip	lea	MenuString(PC),a0
\copy	move.b	(a1)+,(a0)+		;copy string
	bne.s	\copy
\copy2	move.b	(a1)+,(a0)+		;and copy shortcut
	bne.s	\copy2

\exit	rtplugin SKIP_NEXTPLUGINS


;----------------------------------------------------
; THE edit function
;
; NOT OPTIMIZED AT ALL !!
;----------------------------------------------------
modifie:
	pea	hlp_Edit(PC)
;#ifdef TIPLUS
	jsr     tios::ST_helpMsg        ;else it crash
;#else
	jsr     tios::ST_showHelp
;#endif
	addq.l  #4,a7

	lea	win_Warning(PC),a0
	jsr	apilib::InterfaceEngine
	bsr	ShowAll

	clr.w	d3		;initial pos
	move.b	editmode,d5	;d5 is editmode for
				;ALL this subroutine

	bsr	DrawCursor
	
	
\loop	bsr	GetKey		;read a key
	move.w	d3,d6
	cmp.w	#266,d0
	beq	\swapmode
	cmp.w	#PAD_RIGHT,d0
	beq	\rg
	cmp.w	#PAD_LEFT,d0
	beq	\lft
	cmp.w	#PAD_DOWN,d0
	beq	\dn
	cmp.w	#PAD_UP,d0
	beq	\up
	cmp.w	#264,d0
	bne.s	\isvalid
	

	clr.w	-(a7)
	move.l	a7,-(a7)
;#ifdef TIPLUS
	jsr     tios::ST_helpMsg        ;else it crash
;#else
	jsr     tios::ST_showHelp
;#endif
	addq.l  #4+2,a7

	bsr	DrawCursor
	move.b	d5,editmode
	bra	Loop		;exit edit mode

\isvalid
	move.l	a4,a0		;save a4
	move.w	d3,d1
	tst.b	d5
	bne.s	\nodiv
	lsr.w	#1,d1		;d3/2
\nodiv	adda.w	d1,a0

;#ifdef TIPLUS
	move.l	#$03FFFF,d1
;#else
	move.l	#$01FFFF,d1
	btst.b	#0,$600000		;test if 256kB or
	beq.s	\no256			;128kB of RAM
	move.l	#$03FFFF,d1
;#endif

\no256	cmp.l	d1,a0
	bhi.s	\loop

	tst.b	d5
	beq.s	\left1

	cmp.w	#255,d0
	bhi.s	\loop
	move.b	d0,(a0)

	move.w	d3,d2		;Show the new line
	lsr.w	#3,d2
	bra.s	\skip1

\left1	bsr	GetHexaNb
	tst.w	d0
	beq	\loop

	bsr	Str2Hex

	move.w	#240,d1
	btst.w	#0,d3
	bne.s	\pair
	lsl.w	#4,d0
	moveq.w	#15,d1
\pair	and.b	d1,(a0)
	eor.b	d0,(a0)
	
	move.w	d3,d2		;Show the new line
	lsr.w	#4,d2

\skip1	move.w	d2,d0
	mulu.w	#8,d2
	add.w	#Y_START,d2	;d2:Y
	lsl.w	#3,d0	;mulu.w	#8,d0
	move.l	a4,a0
	adda.w	d0,a0
	bsr	hex_ShowLine
	bsr	DrawCursor

\rg	moveq.w	#16,d0
	move.w	#(2*NB_LINE*8)-1,d1
	tst.b	d5
	beq.s	\rgl
	moveq.w	#8,d0
	moveq.w	#(NB_LINE*8)-1,d1
\rgl	cmp.w	d1,d3
	beq.s	\scrolld
	addq.w	#1,d6
	bra.s	\AffCurs

\lft	moveq.w	#16,d0
	tst.b	d5
	beq.s	\l1
	moveq.w	#8,d0
\l1	tst.w	d3
	beq.s	\scrollup
	subq.w	#1,d6
	bra.s	\AffCurs

\dn	moveq.w	#16,d0
	tst.b	d5		;if ascii mode
	beq.s	\dnl		;then
	moveq.w	#8,d0		;d0=8
\dnl	move.w	d0,d1
	mulu.w	#NB_LINE-1,d1	;88 or 176
	cmp.w	d1,d3
	bcc.s	\scrolld
	add.w	d0,d6
	bra.s	\AffCurs
\scrolld bsr	hex_scrolldown
	sub.w	d0,d3
	bra.s	\AffCurs

\up	moveq.w	#16,d0
	tst.b	d5
	beq.s	\upl
	moveq.w	#8,d0
\upl	cmp.w	d0,d3
	bcs.s	\scrollup
	sub.w	d0,d6
	bra.s	\AffCurs
\scrollup bsr	hex_scrollup
	add.w	d0,d3		;it will first clear it
	
\AffCurs
	bsr.s	DrawCursor	;clear old curs
	move.w	d6,d3
	bsr.s	DrawCursor	;aff new

\goloop	bra	\loop
\swapmode
	bsr.s	DrawCursor	;clear old curs
	bchg.b	#0,d5
	tst.b	d5
	beq.s	\left
	lsr.w	#1,d3
	bra.s	\go
\left	lsl.w	#1,d3
\go	bsr.s	DrawCursor	;draw new curs
	bra.s	\goloop


	

;------------------------------------------------
;Draw the cursor
;input>	d3.w : X position
;------------------------------------------------
DrawCursor:
	movem.l	d0-d3/a0,-(a7)
	move.w	d3,d1

	tst.b	d5
	beq.s	\left

	and.w	#7,d1		;d1=X
	move.w	d3,d2	
	lsr.w	#3,d2

	mulu.w	#6,d1

;#ifdef TI89
	add.w	#110,d1
;#else
	add.w	#188,d1		;right
;#endif
	bra.s	\skip1

\left	and.w	#15,d1		;d1=X
	move.w	d3,d2	
	lsr.w	#4,d2

;#ifdef TI89
;#else
	move.w	d1,d3	;truc pour 'sauter les creux'
	lsr.w	#1,d3	;dans l'affichage hexa
	add.w	d3,d1
;#endif

;#ifdef TI89
	mulu.w	#4,d1
;#else
	mulu.w	#6,d1
;#endif
	add.w	#44,d1


\skip1	mulu.w	#8,d2
	add.w	#Y_START,d2
	mulu.w	#30,d2

	move.w	d1,d3		;save d1		
	lsr.w	#3,d1
	add.w	d1,d2
	move.l	#LCD_MEM,a0
	adda.w	d2,a0
	and.w	#7,d3
	move.b	#$C0,d0
	lsr.b	d3,d0

;#ifdef TI89
	moveq.w	#5,d3
;#else
	moveq.w	#7,d3
;#endif
\draw	eor.b	d0,(a0)
	lea	30(a0),a0
	dbra.s	d3,\draw
	
	movem.l	(a7)+,d0-d3/a0
	rts


;-----------------------------------------------------
; Get a handle
;-----------------------------------------------------
hdl:	lea	win_GotoHdl(PC),a0
	jsr	apilib::InterfaceEngine

	move.w	#140+OX,d0
	moveq.w	#60+OY,d1
	moveq.w	#3,d2
	bsr	InputHex
	tst.w	d0
	beq.s	\cancel
	tios::DEREF d1,a4

\cancel	bsr	ShowAll
	bra	Loop


;--------------------------------------------------------
; Show one line of data
;
;input>	a0.l : Address of datas
;	d2.w : Y pos
;--------------------------------------------------------
hex_ShowLine:
;#ifdef TI89
	movem.l	d0-d4/a0-a3,-(a7)
	move.l	BufAddr,a1	;lea	buf(PC),a1
	move.l	a1,a2		;save a0

	move.l	a0,d0		;Print the adress
	moveq.l	#5,d1		;6 characters
	bsr	Hex2Str		;go subroutine
	clr.b	(a1)+
	moveq.w	#2,d0		;x	
	bsr	fast_print_font2 ;y, a2 already set

	move.l	BufAddr,a1
	lea	24(a1),a3
	moveq.w	#7,d4		;8 boucles
	clr.l	d0
\ByteLine
	move.b	(a0)+,d0	
	moveq.l	#1,d1		;2 characters
	bsr	Hex2Str		;Convert
	subq.w	#1,a1		;delete space

	move.b	d0,(a3)
	tst.b	d0
	bne.s	\nozero
	move.b	#46,(a3)

\nozero	addq.l	#1,a3
	dbra.s	d4,\ByteLine
	clr.b	(a3)+
	clr.b	(a1)+

	moveq.w	#43,d0		;x	
	bsr	fast_print_font1 ;y, a2 already set
	lea	24(a2),a2
	moveq.w	#110,d0		;x	
	bsr	fast_print_font2 ;y, a2 already set

	movem.l	(a7)+,d0-d4/a0-a3
	addq.l	#8,a0
	rts

;#else
	movem.l	d0-d4/a0-a3,-(a7)
	move.l	BufAddr,a1	;lea	buf(PC),a1
	move.l	a1,a2		;save a0

	move.l	a0,d0		;Print the adress
	moveq.l	#5,d1		;6 characters
	bsr	Hex2Str		;go subroutine

	lea	24(a1),a3
	moveq.w	#7,d4		;8 boucles
	clr.l	d0
\ByteLine
	move.b	(a0)+,d0	
	moveq.l	#1,d1		;2 characters
	bsr	Hex2Str		;Convert

	move.b	d0,(a3)
	tst.b	d0
	bne.s	\nozero
	move.b	#46,(a3)

\nozero	addq.l	#1,a3
	dbra.s	d4,\ByteLine

	clr.b	(a3)+

	moveq.w	#2,d0		;x	
	bsr	fast_print_font2 ;y, a2 already set

	movem.l	(a7)+,d0-d4/a0-a3
	addq.l	#8,a0
	rts
;#endif


;input>	a0.l : Address of datas
;	d2.w : Y pos
hdl_ShowLine:
	movem.l	d0-d4/a0-a3,-(a7)

	suba.w	#50,a7
	move.l	a7,a3

	move.l	a0,d4
	sub.l	tios::Heap,d4
	lsr.w	#2,d4			;d4=handle

	move.l	(a0),a2			;a2=hdl addr



	movem.l	d0-d2/a0-a1,-(a7)


	move.l	d4,d1			;handle
	jsr	apilib::vat_FindHdlEverywhere
	tst.w	d2
	beq.s	\novat
	pea	hdl_vat(PC)
	bra.s	\vat2
\novat	pea	hdl_s(PC)
\vat2

	move.w	d4,d0
	beq.s	\nolock
	bsr	GetLock
	tst.w	d0
	beq.s	\nolock
	pea	hdl_lock
	bra.s	\lock2
\nolock	pea	hdl_s(PC)
\lock2


	move.l	a2,-(a7)	
	move.w	d4,-(a7)
	pea	hdl_str(PC)
	move.l	a3,-(a7)
	jsr	tios::sprintf
	lea	22(a7),a7


	movem.l	(a7)+,d0-d2/a0-a1
	
	move.l	a3,a1

;#ifdef TI89
	moveq.w	#2,d0
;#else
	moveq.w	#10,d0
;#endif
	move.w	d2,d1
	jsr	apilib::draw_StringSpecial

	adda.w	#50,a7
	movem.l	(a7)+,d0-d4/a0-a3
	addq.l	#4,a0

	rts

;d0 : hdl
GetLock:
	move.l	d1,-(a7)

	jsr	apilib::DEREFd0a0
	clr.w	d0			;default:no locked
	suba.w	#2,a0

	move.l	a0,d1
	btst.b	#0,d1
	bne.s	\exit			;avoid addr error
	move.w	(a0),d0
	andi.w	#$8000,d0

\exit	move.l	(a7)+,d1
	rts

;#ifdef TI89
hdl_str	dc.b	"%04X  %08lX %7s %3s",0
;#else
hdl_str	dc.b	"%04X  %08lX  %7s %3s",0
;#endif

hdl_vat	dc.b	"VAT",0
hdl_lock dc.b	"Locked",0
hdl_s	dc.b	"       ",0
	ds.w	0

;-----------------------------------------------------
; Show all lines of data
;-----------------------------------------------------
ShowAll:
	movem.l	d0-d4/a0-a2,-(a7)

	move.w	#$700,d0		;disable interrupt
	trap	#1			;to make it faster
	move.l	d0,-(a7)

;#ifdef TI89
	move.l	#LCD_MEM+Y_START*30,a0
	move.w	#((NB_LINE)*8*30)/4-1,d3
\clr	clr.l	(a0)+
	dbra.s	d3,\clr
;#else
	tst.b	mode
	beq.s	\skip
	move.l	#LCD_MEM+Y_START*30,a0
	move.w	#((NB_LINE)*8*30)/4-1,d3
\clr	clr.l	(a0)+
	dbra.s	d3,\clr
\skip
;#endif

	moveq.w	#Y_START,d2		;initial Y POS
	move.l	a4,a0
	
	moveq.w	#NB_LINE-1,d3

	tst.b	mode
	bne.s	\loop2

\loop1	bsr	hex_ShowLine
	addq.w	#8,d2
	dbra.s	d3,\loop1
	bra.s	\exit

\loop2	bsr	hdl_ShowLine
	addq.w	#8,d2
	dbra.s	d3,\loop2
	bsr	hdl_select
	bsr	hdl_ShowComment
\exit	move.l	(a7)+,d0
	trap	#1

	movem.l	(a7)+,d0-d4/a0-a2
	rts

;-----------------------------------------------------
; Initialization of the screen
;-----------------------------------------------------
InitScreen:
	lea	main_interface(PC),a0
	jsr	apilib::InterfaceEngine	
	rts

;-----------------------------------------------------
;	printf
; input :	a0 : adress of data & string
; format :	x,y,text
;-----------------------------------------------------
printf:
	jmp	apilib::draw_sString


GetKey:
	jmp	apilib::WaitKey

;--------------------------------------------------------
; Hex2Str
;Input>	d0.l : Number
;	d1.w : nb of charact
;	a1.l : output buffer
;--------------------------------------------------------
Hex2Str:
	movem.l	d0-d3,-(a7)
\loop
	move.l	d0,d3		; save the number
	move.l	d1,d2		; d2=Nb of charac-1
	lsl.l	#2,d2		; d2 = 4*loopcount (# bits to shift)
	lsr.l	d2,d0
	and.l	#$0000000F,d0

	cmp.l	#9,d0		;d0=9?
	bhi.s	\letter
	add.l	#48,d0		;d0=48
	bra.s	\char
\letter	
	add.l	#55,d0		;d0=d0+55
\char
	move.b	d0,(a1)+
	move.l	d3,d0		; restore the number
	dbf.w	d1,\loop

	move.b	#32,(a1)+
	movem.l	(a7)+,d0-d3
	rts


;-----------------------------------------------------
; 
;Input>	d0.w : X
;	d1.w : Y
;	d2.w : nb-1
;-----------------------------------------------------
InputHex:
	movem.l	d2-d7/a0-a1,-(a7)
	move.l	BufAddr,a0	;lea	buf(PC),a0
	move.w	d0,d5		;save X
	
	move.l	a0,a1
	move.w	d2,d0
\lp	move.b	#48,(a1)+
	dbra.s	d0,\lp
	clr.b	(a1)+
	bsr	printHex

	move.l	a0,a1
	add.l	d2,a1
	addq.w	#1,d2
	clr.w	d6
	clr.w	d7		;number

\loop	bsr	GetKey

	cmp.w	#257,d0
	beq.s	\back
	cmp.w	#13,d0
	beq.s	\exit
	cmp.w	#264,d0
	bne.s	\isvalid

\esc	clr.l	d7
	clr.l	d0
\exit	move.l	d7,d1
	movem.l	(a7)+,d2-d7/a0-a1
	rts

\isvalid bsr	GetHexaNb
	tst.w	d0
	beq.s	\loop

\key	cmp.w	d2,d6
	beq	\loop
	cmp.w	#48,d0		;est ce '0'?
	bne	\nozero
	tst.w	d6
	beq	\loop
\nozero	addq.w	#1,d6
	move.w	d2,d3
	subq.w	#2,d3
	clr.w	d4
\mv	move.b	1(a0,d4.w),0(a0,d4.w)
	addq.w	#1,d4
	dbra.s	d3,\mv

	move.b	d0,(a1)
	bsr	printHex

	lsl.l	#4,d7
	bsr	Str2Hex
\nolet	or.w	d0,d7
	bra	\loop

\back	tst.w	d6
	beq	\loop
	subq.w	#1,d6
	move.w	d2,d3
	subq.w	#2,d3
\mv2	move.b	0(a0,d3),1(a0,d3)
	dbra	d3,\mv2

	move.b	#48,(a0)
	bsr	printHex
	lsr.l	#4,d7
	bra	\loop

;-----------------------------------------------------
; subroutine
;-----------------------------------------------------
printHex:
	movem.l	d0-d2/a0-a1,-(a7)
	
	move.w	#4,-(a7)
	move.l	a0,-(a7)
	move.w	d1,-(a7)
	move.w	d5,-(a7)
	jsr 	tios::DrawStrXY
	lea 	10(a7),a7

	movem.l	(a7)+,d0-d2/a0-a1
	rts

;-------------------------------------------------
;Return if a char is a valid hexa nb (0..9 and A..F)
;Input>	d0.w : the char
;out>	d0.w : the char if ok
;		0 is error
;
;--------------------------------------------------
GetHexaNb:
	cmp.w	#48,d0
	bcs.s	\nochif
	cmp.w	#57,d0
	bls.s	\exit

\nochif	cmp.w	#97,d0
	bcs.s	\error
	sub.w	#32,d0
	cmp.w	#70,d0		;102-32
	bls.s	\exit
\nolett	
\error	clr.w	d0
\exit	rts

;---------------------------------------------
;Transforme la lettre/chiffre (0..9/A..F) en
;chiffre 1..15
;
;input>	d0.w : the letter/number
;out>	d0.w : the number
;----------------------------------------------
Str2Hex:
	sub.w	#48,d0
	cmp.w	#10,d0
	bcs.s	\nolet
	subq.w	#7,d0
\nolet	rts

FindN:
	move.w	findnext,d0
	tst.w	d0
	beq.s	Find

	lea	inputbuf(PC),a5
	move.l	a4,a0
	addq.l	#1,a0
	bra.s	search


inputbuf dcb.b	18,0

;-----------------------------------------------------
; Find Function
;-----------------------------------------------------
Find:	
	lea	win_Find(PC),a0
	jsr	apilib::InterfaceEngine

	lea	header_Edit(PC),a0
	lea	inputbuf(PC),a1
	move.l	a1,a5
	jsr	apilib::EditComponent
	bsr	ShowAll

	tst.w	d0
	beq.s	exitf

	subq.w	#1,d0
	move.l	a4,a0
search	clr.w	d4		;cmpt

\loop	move.l	a0,a2		;current
	move.l	a5,a3		;searc txt
	move.w	d0,d1

\cmp	cmp.b	(a3)+,(a2)+
	bne.s	\next
	dbra.s	d1,\cmp

	move.w	d0,findnext
	move.l	a0,a4
	bra	exfind		;aff all

\next	tst.w	d4		;cmpt
	bne.s	\noaff

	movem.l	d0-d3/a0-a2,-(a7)
	move.l	a0,d0		;nb
	moveq.l	#5,d1
	move.l	BufAddr,a1
	move.l	a1,a2
	bsr	Hex2Str
	clr.b	(a1)
;#ifdef TI89
	move.w	#100,d0
;#else
	move.w	#180,d0		;x
;#endif
	moveq.w	#8,d2		;y
	bsr	fast_print_font2
	move.w	#$1000,d4
	movem.l	(a7)+,d0-d3/a0-a2

\noaff	addq.l	#1,a0
	subq.w	#1,d4

;#ifdef TIPLUS
	tst.w	KEY_PRESSED_FLAG
	beq.s	\loop
	move.l	d0,-(a7)
	bsr	GetKey
	move.w	d0,d1
	move.l	(a7)+,d0
;#else
	tst.w	tios::kb_vars+$1C
	beq.s	\loop
	clr.w	tios::kb_vars+$1C
	move.w	tios::kb_vars+$1E,d1
;#endif
	cmp.w	#264,d1
	bne.s	\noaff

exitf	clr.w	findnext
exfind	lea	main_i2(PC),a0
	jsr	apilib::InterfaceEngine
	bsr	ShowAll
	bra	Loop


;------------------------------------------------------
; Main Menu
;------------------------------------------------------
MainMenu:
	suba.w	#3840,a7
	move.l	a7,a1
	move.l	a1,a3
	jsr	apilib::ScreenToBuffer
	
\loop	bsr	SetMenu

	lea	ie_Menu(PC),a0
	jsr	apilib::InterfaceEngine
	lea	header_MainMenu(PC),a0
	lea	str_MainMenu(PC),a1
	jsr	apilib::ListViewComponent
	cmp.w	#264,d0
	beq	\exit

	;-----------------------------------------
	; Util Menu
	;-----------------------------------------
	cmp.w	#0,d1
	bne.s	\noutil
	lea	ie_MenuUtil(PC),a0
	jsr	apilib::InterfaceEngine
	lea	header_UtilMenu(PC),a0
	lea	str_UtilMenu(PC),a1
	jsr	apilib::ListViewComponent
	cmp.w	#264,d0
	beq	\aff_menu

	adda.w	#3840,a7
	tst.w	d1
	beq	go
	cmp.w	#1,d1
	beq	hdl
	cmp.w	#2,d1
	beq	add
	cmp.w	#3,d1
	bne.s	\noedit
	bsr	ShowAll
	bra	modifie
\noedit	cmp.w	#4,d1
	beq	gotofile	
	cmp.w	#5,d1
	beq	Find
	cmp.w	#6,d1
	beq	FindN

	suba.w	#3840,a7
	bra.s	\exit

	;-----------------------------------------
	; BookMarks menu
	;-----------------------------------------
\noutil	cmp.w	#1,d1
	bne.s	\nobookmark
	lea	ie_MenuBk(PC),a0
	jsr	apilib::InterfaceEngine
	lea	header_BookMarkMenu(PC),a0
	lea	str_BookMarkMenu(PC),a1
	jsr	apilib::ListViewComponent
	cmp.w	#264,d0
	beq.s	\aff_menu

	move.w	d1,d2
	bsr	ShowBookMark
	cmp.w	#264,d0
	beq.s	\exit
	lea	bookmarks(PC),a0
	lsl.w	#2,d1
	adda.w	d1,a0

	tst.w	d2
	bne.s	\setbm
	move.l	(a0),a4
	bra.s	\exit
\setbm	move.l	a4,(a0)
	bra.s	\exit

	;-----------------------------------------
	; Mode menu
	;-----------------------------------------
\nobookmark cmp.w #2,d1
	bne.s	\nomode

	tst.b	mode
	beq.s	\m_hexa
	clr.b	mode
	move.l	a4,hdl_addr
	bsr	InitScreen
	bra.s	\m_skip
\m_hexa move.b	#1,mode
	move.l	a4,hex_addr
\m_skip	bsr	SetMode

\nomode	
\exit	adda.w	#3840,a7
	bsr	ShowAll
	cmp.w	#3,d1
	beq	Exit
	Bra	Loop

\aff_menu:
	move.l	a3,a1
	jsr	apilib::BufferToScreen
	bra	\loop


SetMenu:
	lea	str_MM_Mode+5(PC),a0

	lea	mode_Handle(PC),a1
	tst.b	mode
	beq.s	\hexa
	lea	mode_Hexview(PC),a1
\hexa	move.b	(a1)+,(a0)+
	bne.s	\hexa
	rts

menu_kd:
	move.w	d6,d1

	move.l	$24(a6),a0
	tst.b	0(a0,d6.w)
	beq.s	\skip

	cmp.w	#264,d0
	beq.s	\exit
	cmp.w	#$D,d0
	beq.s	\exit

	tst.w	d6
	beq.s	\ok
	cmp.w	#1,d6
	bne.s	\skip
\ok	cmp.w	#PAD_RIGHT,d0
	beq.s	\exit
	
\skip	clr.w	d0
\exit	rts

menu_kd2:
	move.w	d6,d1

	cmp.w	#264,d0
	beq.s	\exit
	cmp.w	#$D,d0
	beq.s	\exit
	cmp.w	#PAD_LEFT,d0
	beq.s	\esc
	clr.w	d0
\exit	rts

\esc	move.w	#264,d0
	bra.s	\exit


mode_Hexview dc.b	"HexView",0
mode_Handle dc.b	"Handle ",0

;-------------------------------------------------------------
; d0 : X / d2 : Y / a2 : addr
;-------------------------------------------------------------
fast_print_font2:
	movem.l	d0-d3/a0-a2,-(a7)

	move.l	FontAdr,a1
	
\loop	clr.l	d3
	move.b	(a2)+,d3
	tst.b	d3
	beq.s	\exit
	move.l	a1,a0
	lsl.w	#3,d3
	adda.w	d3,a0
	bsr	Put8x8
	addq.w	#6,d0
	bra.s	\loop

\exit	movem.l	(a7)+,d0-d3/a0-a2
	rts

;-------------------------------------------------------------

;-------------------------------------------------------------
;#ifdef TI89
fast_print_font1:
	movem.l	d0-d3/a0-a2,-(a7)

;\loop	clr.l	d3
;	move.b	(a2)+,d3
;	tst.b	d3
;	beq.s	\exit
;	move.l	a1,a0
;	mulu.w	#6,d3
;	adda.w	d3,a0
;	bsr	Put8x8
;	addq.w	#5,d0
;	bra.s	\loop

	move.l	d0,-(a7)
	clr.w	d0
	jsr	apilib::SetFont
	move.l	(a7)+,d0

	move.l	a2,a1
	move.w	d2,d1
	jsr	apilib::draw_StringSpecial

	moveq.w	#1,d0
	jsr	apilib::SetFont

\exit	movem.l	(a7)+,d0-d3/a0-a2
	rts
;#endif


;-----------------------------------------------------
; Copy font data to the buffer
;-----------------------------------------------------
Font2Buf:
	move.l	FontAdr,a0

;#ifdef TIPLUS
	move.l	#tios::font_medium,a1
;#else
	lea	tios::SF_font,a1
	adda.w	#$600,a1
;#endif

	move.w	#511,d3		;((256*8)/4)-1
\cpy	move.l	(a1)+,(a0)+
	dbra.s	d3,\cpy
	move.l	a0,BufAddr
	rts

;-------------------------------------------------
; Put a 8x8 sprite
; Input :	d0.w : X
;		d2.w : Y
;		a0.l : adress of data
;------------------------------------------------
Put8x8:
	movem.l	a0-a1/d0-d7,-(a7)

	move.l	#LCD_MEM,a1
	mulu.w	#30,d2
	add.w	d2,a1
	move.w	d0,d2		;copy x
	lsr.w	#3,d2		;int(x/8)	
	add.w	d2,a1
	lsl.w	#3,d2
	sub.w	d2,d0
	move.w	#$FF00,d5
	ror.w	d0,d5
	moveq.w	#8,d6
	sub.w	d0,d6
	move.w	#$FF00,d7
	rol.w	d6,d7

	moveq.w	#7,d2
\line	move.b	(a0)+,d3	
	tst.w	d0		;if on a byte
	bne.s	\nozero		;no problem
	move.b	d3,(a1)+
	bra.s	\loop
\nozero	move.b	d3,d4
	lsr.b	d0,d3
	and.b	d5,(a1)
	or.b	d3,(a1)+
	lsl.b	d6,d4
	and.b	d7,(a1)
	or.b	d4,(a1)
\loop	lea	29(a1),a1	;adda.w	#29,a1
	dbra.s	d2,\line

	movem.l	(a7)+,a0-a1/d0-d7
	rts




;=====================================================
; CFG File Support
;
; ------------------------------
; | Signature (hxvcfg) 6 bytes |
; | Version (2 bytes)          |
; ------------------------------
; |  hex_addr                  |
; |  hdl_addr                  |
; |  bookmarks ( 8*4 bytes)    |
; ------------------------------
;=====================================================

;#ifdef TIPLUS

CFGFILE_SIZE    equ     (END_SAVEDDATA-SAVEDDATA)+8+8

;--------------------------------------------------------------
;
;--------------------------------------------------------------
Read_CFG_File:
	movem.l	d0-d2/a0-a1,-(a7)

	bsr	Get_CFG_Addr
	tst.w	d0
	beq.s	\exit
	tst.w	d1				;if just created, exit
	bne.s	\exit				;

        lea     SAVEDDATA(PC),a1

        move.w  #(END_SAVEDDATA-SAVEDDATA)-1,d0

\copy	move.b	(a0)+,(a1)+
	dbra.s	d0,\copy


\exit	movem.l	(a7)+,d0-d2/a0-a1
	rts

;--------------------------------------------------------------
;
;--------------------------------------------------------------
Save_CFG_File:
	movem.l	d0-d2/a0-a1,-(a7)

	bsr	Get_CFG_Addr
	tst.w	d0
	beq.s	\exit

        lea     SAVEDDATA(PC),a1
        move.w  #(END_SAVEDDATA-SAVEDDATA)-1,d0

\copy	move.b	(a1)+,(a0)+
	dbra.s	d0,\copy


\exit	movem.l	(a7)+,d0-d2/a0-a1
	rts


;--------------------------------------------------------------
;Input>
;Out>	d0.w : Handle, 0 if error
;	d1.w : if 1, Just created
;	a0.l : Addr
;--------------------------------------------------------------
Get_CFG_Addr:

	movem.l	d2-d4/a1-a2,-(a7)

	;-------------------------------------
	;Look for file
	;-------------------------------------
	move.w	#MAINLIST_HDL,d0
	lea	CFGFile(PC),a0
	jsr	apilib::vat_Find
	move.w	d1,d0			;if not found create
	beq	\create

;#ifdef TIPLUS
	;-------------------------------------
	; Check if it is archived, and 
	; unarchives it if necessary
	;-------------------------------------
	move.l	d0,-(a7)
	btst.b  #VAT_ARCHBIT,VAT_ENTRYFLAG(a1)
	beq.s   \noarch
	subq.w	#1,d2
	move.w	#MAINLIST_HDL,d0
	jsr	apilib::vat_UnarchiveVar
\noarch	move.l	(a7)+,d0
;#endif

	;-------------------------------------
	; If found, check if valid
	;-------------------------------------
        jsr     apilib::DEREFd0a0
	lea	2(a0),a1
	
	cmp.l	#'HXVC',(a1)+
	bne.s	\delete
	cmp.w	#'FG',(a1)+
	bne.s	\delete
	cmp.w	#$0100,(a1)+
	bne.s	\delete

	lea	2(a0),a1
	clr.l	d1			;
	move.w	(a0),d1			;file size
	lea	2(a0,d1.l),a2		;get end of file
	cmp.b	#$F8,-(a2)		;Check extension
	bne.s	\delete			;if not valid, delete file
	tst.b	-(a2)
	bne.s	\delete
	cmp.b	#'G',-(a2)
	bne.s	\delete
	cmp.b	#'F',-(a2)
	bne.s	\delete
	cmp.b	#'C',-(a2)
	bne.s	\delete
	clr.w	d1			;not just created

\ok     jsr     apilib::DEREFd0a0
	lea	8+2(a0),a0		;skip signature and file size
\exit	movem.l	(a7)+,d2-d4/a1-a2
	rts

\error	clr.w	d0
	bra.s	\exit

	;-------------------------------------
	; Delete the file if invalid
	;-------------------------------------
\delete	move.w	#MAINLIST_HDL,d0
	lea	CFGFile(PC),a0
	jsr	apilib::vat_Find
	tst.w	d2
	beq.s	\error
	subq.w	#1,d2
	jsr	apilib::vat_Delete

	;-------------------------------------
	; Create the file if it doesn't exists
	;-------------------------------------
\create	move.w 	#MAINLIST_HDL,d0	;folder
	moveq.w	#0,d1			;flag
        moveq.w #((END_SAVEDDATA-SAVEDDATA)+8+8),d2       ;size
	lea	CFGFile(PC),a0
	jsr	apilib::vat_CreateVar
	tst.w	d1
	bne.s	\error

        jsr     apilib::DEREFd0a0               ;get addr
	lea	2(a0),a1
	move.l	#'HXVC',(a1)+
	move.w	#'FG',(a1)+
	move.w	#$0100,(a1)+
        lea     (END_SAVEDDATA-SAVEDDATA)+8+8+2(a0),a1
	move.b	#$F8,-(a1)		;put string
	clr.b	-(a1)
	move.b	#'G',-(a1)
	move.b	#'F',-(a1)
	move.b	#'C',-(a1)
	clr.b	-(a1)

	moveq.w	#1,d1			;just created
	bra	\ok



CFGFile:        dc.b    "hexvcfg",0

	ds.w	0
;#endif

;*****************************************************
; Program data
;*****************************************************

SAVEDDATA:

hex_addr	dc.l	0
hdl_addr	dc.l	0

bookmarks	dcb.l	8,0


END_SAVEDDATA:

FontAdr		dc.l	0

BufAddr		dc.l	0
AddCursX	dc.w	44

PadCodes dc.w	4434,4440,8530,8536,16722,16728,33106,33112
Offsets	dc.l	$FFFFFF00,$100,$FFFFF000,$1000,$FFFF0000,$10000,$FFF00000,$100000

findnext	dc.w	0
			
refresh		dc.b	0
editmode	dc.b	0
mode		dc.b	0

MenuString	dc.b	"                            ",0
mnu_s1		dc.b	"Edit with HexView",0,"F7",0
mnu_s2		dc.b	"Run HexView",0,"F7",0

folderfile	dc.b	"%s\%s",0

win_About:	dc.b		IE_ANIMEDWIN2,50,50+OX,40+OY,189+OX,80+OY,"About...",0
		dc.b		IE_SETFONT,1
		dc.b		IE_STRING,58+OX,53+OY,"HexView",0
		dc.b		IE_SETFONT,0
		dc.b		IE_STRING,58+OX,66+OY,"Ibrahim/Benoit Scherrer",0
		dc.b		IE_STRING,58+OX,72+OY,"benoitscherrer@gmail.com",0
		dc.b		IE_SOLIDRECT,58+OX,62+OY,178+OX,63+OY
		dc.b		IE_SETFONT,1
		dc.b		IE_WAITKEY
		dc.b		IE_END

win_Warning	dc.b		IE_WIN2,50+OX,35+OY,189+OX,85+OY,"Edit Mode",0
		dc.b		IE_SETFONT,1
		dc.b		IE_STRING,55+OX,48+OY,"WARNING",0
		dc.b		IE_SETFONT,0
		dc.b		IE_STRING,55+OX,58+OY,"You can very easly crash your TI by",0
		dc.b		IE_STRING,55+OX,64+OY,"using the Edit Mode.",0
		dc.b		IE_STRING,55+OX,70+OY,"Do it at your own risks.",0
		dc.b		IE_STRING,75+OX,77+OY,"(ESC exit the Edit Mode)",0
		dc.b		IE_SETFONT,1
		dc.b		IE_WAITKEY
		dc.b		IE_END

hlp_Edit:	dc.b		"Press [MODE] to use HEX/ASCII edition",0

win_GotoAddr	dc.b	IE_WIN2,50+OX,40+OY,189+OX,80+OY,"Goto Address",0
		dc.b	IE_STRING,58+OX,60+OY,"Goto Address:",0
		dc.b	IE_END

win_GotoHdl	dc.b	IE_WIN2,50+OX,40+OY,189+OX,80+OY,"Goto Handle",0
		dc.b	IE_STRING,58+OX,60+OY,"Goto Handle:",0
		dc.b	IE_END

win_Find	dc.b	IE_WIN2,50+OX,40+OY,189+OX,80+OY,"Find",0
		dc.b	IE_STRING,58+OX,55+OY,"Find String:",0
		dc.b	IE_END


win_Add	dc.b	IE_WIN2,50+OX,40+OY,189+OX,80+OY,"Add To Address",0
		dc.b	IE_STRING,58+OX,60+OY,"Add :",0
		dc.b	IE_END

ie_Menu		dc.b	IE_SOLIDRECT,53+OX,49+OY,50+81+OX,50+35+OY
		dc.b	IE_SETFONT,1
		dc.b	IE_END

ie_MenuUtil	dc.b	IE_SOLIDRECT,83+OX,29+OY,80+111+OX,30+7*9-1+OY
		dc.b	IE_END

ie_MenuBk	dc.b	IE_SOLIDRECT,65+OX,59+OY,62+131+OX,60+2*9-1+OY
		dc.b	IE_END

ie_GotoFile	dc.b	IE_SOLIDRECT,63+OX,44+OY,60+121+OX,45+5*9-1+OY
		dc.b	IE_END

	ds.w	0

header_MainMenu:
	dc.w	4
	dc.w	4
	dc.w	50+OX,50+OY
	dc.l	0
	dc.w	80
	dc.w	0
	dc.w	0
	dc.b	%00000110
	dc.b	0
	dc.l	0,menu_kd,0,0,MainMenuProperties

MainMenuProperties:
	dc.b	1,1,1,1

header_UtilMenu:
	dc.w	7
	dc.w	7
	dc.w	80+OX,30+OY
	dc.l	0
	dc.w	110
	dc.w	0
	dc.w	0
	dc.b	%00000110
	dc.b	0
	dc.l	0,menu_kd2,0,0,0

header_BookMarkMenu:
	dc.w	2
	dc.w	2
	dc.w	62+OX,60+OY
	dc.l	0
	dc.w	130
	dc.w	0
	dc.w	0
	dc.b	%00000110
	dc.b	0
	dc.l	0,menu_kd2,0,0,0

header_ShowBookMark:
	dc.w	8
	dc.w	8
	dc.w	92+OX,40+OY
	dc.l	0
	dc.w	54
	dc.w	4
	dc.w	0
	dc.b	%00000110
	dc.b	0
	dc.l	0,0,0,lv_BookMarkItem,0

header_GotoFile
	dc.w	60+OX,45+OY
	dc.w	5
	dc.w	120
	dc.w	0
	dc.b	%00011010,0
	dc.l	0,0,0,0,0

header_Edit:
	dc.w	58+OX,63+OY
	dc.w	15
	dc.b	0,0
	dc.l	0,0


str_MainMenu	dc.b	"Util        ",18,0
		dc.b	"Bookmarks   ",18,0
str_MM_Mode	dc.b	"Mode HexView",0
		dc.b	"Exit",0

str_UtilMenu	dc.b	"Goto Address    G",0
		dc.b	"Goto Handle     H",0
		dc.b	"Add to Address  A",0
		dc.b	"Edit Mode       E",0
		dc.b	"Goto Var        V",0
		dc.b	"Find            F",0
		dc.b	"Find Next      ",127,"F",0

str_BookMarkMenu dc.b	"Goto BookMark     F?",0
		dc.b	"Set BookMark Here ",127,"F?",0

win_BookMark	dc.b	IE_WIN2,90+OX,30+OY,149+OX,93+OY,"BookMarks",0
		dc.b	IE_END

;#ifdef TI89
BAR_WIDTH	equ	159
;#else
BAR_WIDTH	equ	239
;#endif

main_interface	dc.b	IE_CLRSCR
main_i2		dc.b	IE_WIN,0,0,BAR_WIDTH,16,"HexView 2.0.6",0
		dc.b	IE_SETFONT,0
		dc.b	IE_STRING,10,9,"[APPS]:Menu       [I]:Info",0
		dc.b	IE_SETFONT,1
		dc.b	IE_END

HexWin:
	dc.b	0,0,239,16

_comment
	dc.b	"HexView v2.0.6",0


;*************** End of Fargo program ****************

	
	end


