;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		link_pro.mdl
;	Utility>	Function for link-support
;
;-----------------------------------------------------------


;	GetDirectory
;	RequestVar




ID_CALC	equ	$89
; TI92+  > ? : $89
; TI92+ > ? : $88
; TI89  > ? : $98

; PC > TI92  : $09
; PC > TI92+ : $08
; PC > TI89  : $08

ID_89	equ	$98
ID_92P	equ	$88
ID_92	equ	$89

IS_READY_SIZE		equ	4
is_ready_data:	dc.b	$08,$68,$00,$00
REQUEST_DIR_SIZE	equ	12
request_dir_data 	dc.b	$08,$A2,$06,$00,$00,$00,$00,$00,$19,$00,$19,$00
SEND_ACK_SIZE		equ	4
send_ack_data		dc.b	$08,$56,$00,$00
WAIT_DATA_SIZE	equ	4
wait_data_data	dc.b	$08,$09,$00,$00

EOT_SIZE		equ	4
eot_data	dc.b	$08,$92,$00,$00

link_error_catcher_a7 dc.l	0
link_error_handler	dc.l	0


	ds.w	0
ProgressBar:
	dc.w	0			;Value
	dc.w	76+XO,68+YO		;X,Y
	dc.w	10			;nb square
	dc.w	0			;max value

ProgressBar2:
	dc.w	0
	dc.w	76+XO,80+YO
	dc.w	10
	dc.w	0



;===========================================================================
;           ROUTINES FOR LINK DEBUGGING
;===========================================================================
;#ifdef DBGLINK

dbglink_filename	dc.b	"dbglink",0
dbglink_hdl			dc.w	0
dbglink_addr		dc.l	0

strdbglink_send		dc.b "Send : ",0
strdbglink_rec			dc.b "Rec : ",0
strdbglink_waitack			dc.b "WaitAck : ",0
strdbglink_request			dc.b "Request : ",0
strdbglink_continueornot			dc.b "Continue or not : ",0
strdbglink_getlinkheader			dc.b "GetLinkHeader: ",0
strdbglink_getvatentry			dc.b "GetVatEntry: ",0
	ds.w	0
;-----------------------------------------------------
; Init link
;-----------------------------------------------------
dbglink_init:
	movem.l	d0-d2/a0-a2,-(a7)
	
	;------------------------------------------
	; Look for variable
	;------------------------------------------
	lea		dbglink_filename(PC),a0
	API92_MAINHDL	d0						;Handle of 'Main' folder
	jsr		apilib::vat_Find					;find 'nested' file
	tst.w	d2
	bne		\exit

	;------------------------------------------
	; if not found create it
	;------------------------------------------
\create	
	API92_MAINHDL	d0						;Handle of 'Main' folder*
	clr.w	d1								;flags
	move.w	#8192,d2						;size
	lea		dbglink_filename(PC),a0				;address of filename
	jsr		apilib::vat_CreateVar

	;------------------------------------------
	; Lock variable and get its addr
	;------------------------------------------
\exit	move.w	d0,dbglink_hdl
	bne.s	\getadr
	clr.l	d0
	move.l	d0,a0
	bra.s	\end
\getadr

	movem.l	d0-d2/a0-a2,-(a7)
	move.w	d0,-(a7)
	jsr		tios::HeapLock
	addq.l	#2,a7
	movem.l	(a7)+,d0-d2/a0-a2
	
	bsr	DEREFd0a0
	move.w	#8190,(a0)+
	move.b	#$0,-2+8190(a0)
	move.b	#$E0,-1+8190(a0)
	move.b	#$08,8190(a0)
	
	move.w	#$000A,(a0)+
	move.b	#$20,(a0)+
	
\end move.l	a0,dbglink_addr

	movem.l	(a7)+,d0-d2/a0-a2
	rts
	
;-----------------------------------------------------
; print text message
; msg : A1.l
;-----------------------------------------------------
dbglink_printmsg:
	movem.l	d0-d4/a0-a4,-(a7)
	move.l	dbglink_addr(PC),a0
\msg move.b (a1)+,(a0)+
	bne.s	\msg
	subq.l	#1,a0	
	move.l	a0,dbglink_addr
	movem.l	(a7)+,d0-d4/a0-a4
	rts
	
dbglink_printsend:
	move.l	a1,-(a7)
	lea		strdbglink_send(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts

dbglink_printrec:
	move.l	a1,-(a7)
	lea		strdbglink_rec(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts
	
dbglink_waitack:
	move.l	a1,-(a7)
	lea		strdbglink_waitack(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts
	
dbglink_request:
	move.l	a1,-(a7)
	lea		strdbglink_request(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts
	
dbglink_continueornot:
	move.l	a1,-(a7)
	lea		strdbglink_continueornot(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts

dbglink_getvatentry:
	move.l	a1,-(a7)
	lea		strdbglink_getvatentry(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts
	
dbglink_getlinkheader:
	move.l	a1,-(a7)
	lea		strdbglink_getlinkheader(PC),a1
	bsr		dbglink_printmsg
	move.l	(a7)+,a1
	rts
	
dbglink_printline:
	move.l	a0,-(a7)
	move.l	dbglink_addr(PC),a0
	move.b	#$0D,-1(a0)
	move.b	#$20,(a0)+
	move.l	a0,dbglink_addr
	move.l	(a7)+,a0
	rts
	
;-----------------------------------------------------
; byte : d0.b
;-----------------------------------------------------
dbglink_printbyte:
	movem.l	d0-d4/a0-a4,-(a7)
	move.l	dbglink_addr(PC),a0
	
	and.l	#$FF,d0
	moveq.w	#1,d4
\loop
	move.l	d0,d3		; save the number
	move.l	d4,d2		; d2=Nb of charac-1
	lsl.l	#2,d2		; d2 = 4*loopcount (# bits to shift)
	lsr.l	d2,d0
	and.l	#$0000000F,d0

	cmp.l	#9,d0		;d0=9?
	bhi.s	\letter
	add.l	#48,d0		;d0=48
	bra.s	\char
\letter	
	add.l	#55,d0		;d0=d0+55
\char
	move.b	d0,(a0)+
	move.l	d3,d0		; restore the number
	dbf.w	d4,\loop

	move.b	#32,(a0)+
	move.l	a0,dbglink_addr
	movem.l	(a7)+,d0-d4/a0-a4
	rts
		
;-----------------------------------------------------
; dbglink_printbytes ( ULONG size, void *data )
;-----------------------------------------------------
dbglink_printbytes:
	movem.l	d0-d2/a0-a2,-(a7)
	move.l	6*4+8(a7),d2			;size
	beq.s	\exit
	subq.l	#1,d2
	move.l	6*4+4(a7),a1			;data
	
\loop 
	move.b	(a1)+,d0
	bsr		dbglink_printbyte
	dbra.s	d2,\loop
	
\exit movem.l	(a7)+,d0-d2/a0-a2	
	rts
;#endif

;-----------------------------------------------------
;Input>	d0.w : Base Folder
;	a0.l : Address of CallBack function
;-----------------------------------------------------
;Input>	a1.l : Addr of item (file or folder)
;	d0.w : Handle of folder
;Out>	d0.w : 0 = stop, else continue
;-----------------------------------------------------
BrowseFolders:
	movem.l	d0-d4/a0-a4,-(a7)

	move.l	a0,a4			;Addr of CallBack function

	;------------------------------------------
	;  Lock handle
	;------------------------------------------
	move.w	d0,-(a7)
	TIOS_CALL HeapLock

	move.w	(a7),d0
	bsr	DEREFd0a0		;get addr of folder VAT
	lea	2(a0),a3
	move.w	(a3)+,d3		;nb folders in d3
	beq.s	\exit

	subq.w	#1,d3			;for dbra

	;------------------------------------------
	; Call function for the folder
	;------------------------------------------
\folder	move.w	(a7),d0			;Handle of base folder
	movem.l	d1-d7/a0-a6,-(a7)
	move.l	a3,a1
	jsr	(a4)
	movem.l	(a7)+,d1-d7/a0-a6
	tst.w	d0
	beq.s	\exit

	;------------------------------------------
	; Get associated file VAT 
	;------------------------------------------
	move.w	VAT_ENTRYHDL(a3),d0
	move.w	d0,-(a7)
	TIOS_CALL HeapLock

	move.w	(a7),d0
	bsr	DEREFd0a0
	lea	2(a0),a1
	move.w	(a1)+,d4
	beq.s	\nextfolder
	subq.w	#1,d4

	;------------------------------------------
	; Browse files in the folder & call function
	;------------------------------------------
\file	move.w	(a7),d0			;Handle of folder
	movem.l	d1-d7/a0-a6,-(a7)
	jsr	(a4)
	movem.l	(a7)+,d1-d7/a0-a6
	tst.w	d0
	bne.s	\continue
	clr.w	d3
	bra.s	\nextfolder

\continue lea	VAT_ENTRYSIZE(a1),a1
	dbra.s	d4,\file

\nextfolder TIOS_CALL HeapUnlock
	addq.l	#2,a7

	lea	VAT_ENTRYSIZE(a3),a3
	dbra.s	d3,\folder

\exit	;------------------------------------------
	; Unlock Handle
	;------------------------------------------
	TIOS_CALL HeapUnlock
	addq.l	#2,a7


	movem.l	(a7)+,d0-d4/a0-a4
	rts


;-----------------------------------------------------
; Get which calc is connected
;Out>	d0.w : 	ID_89
;		ID_92P
;		ID_92
;		0 if error
;-----------------------------------------------------
;WhichCalcConnected:
;	movem.l d2-d5/a0-a4,-(a7)
;	move.l	a7,link_error_catcher_a7		;for ErrorCatcher
;
;	move.w	#IS_READY_SIZE,-(a7)
;	pea	is_ready_data(PC)
;	jsr	tios::OSWriteLinkBlock
;	addq.l	#6,a7

;	bsr	GetByte		;Get ID_CALC
;	move.w	d0,-(a7)	;save it
;	bsr	GetByte
;	bsr	GetByte
;	bsr	GetByte
;	move.w	(a7)+,d0

;	movem.l (a7)+,d2-d5/a0-a4
;	rts

ResetLink:

	rts

LinkDelay:
	move.l	d0,-(a7)
	move.w	#30000,d0
\delay nop
    nop
    dbra.s	d0,\delay
	move.l	(a7)+,d0
	rts

;-----------------------------------------------------
;RequestVar
;
;Input>	a0.l : addr of var name : "folder\file",0
;	d0.w :  0 if keep original folder
;		else Handle of dest folder
;
;Out>		d0.w : if successful hdl of created var
;		d1.w : Error Code
;		d2.w : Handle of dest folder
;-----------------------------------------------------
RequestVar_Error:
	move.l	d1,-(a7)
	bsr	DelLinkVar
	move.l	(a7)+,d1

	move.w	d6,d2				;hdl of dest folder
	movem.l (a7)+,d3-d6/a0-a4
	rts

DelLinkVar:
	movem.l	d0/d2/a0-a2,-(a7)

	move.w	d5,d1				;Handle of file
	beq.s	\exit
	jsr	apilib::vat_FindHdlEverywhere	;Look for it
	tst.w	d2				;Successful ???
	bne.s	\ok
	moveq.w	#EC_HDLNOTFOUND,d1
	bra.s	\exit

\ok	subq.w	#1,d2
	jsr	apilib::vat_DeleteVar
	
\exit	clr.w	d5
	movem.l	(a7)+,d0/d2/a0-a2
	rts

RequestVar:
	movem.l d3-d6/a0-a4,-(a7)
	;--------------------------------------
	; Install Link Error catcher
	;--------------------------------------
	move.l	a7,link_error_catcher_a7
	lea	RequestVar_Error(PC),a1
	move.l	a1,link_error_handler

	move.w	d0,d6				;save it

	suba.w	#50,a7
	move.l	a0,a3
	move.l	a7,a4			;addr of buffer
	clr.l	d5			;hdl of created var
	
	;--------------------------------------
	; Get string len in d3
	;--------------------------------------
	clr.l	d3
\strlen	tst.b	(a0)+
	beq.s	\eos
	addq.l	#1,d3
	bra.s	\strlen
\eos
	;--------------------------------------
	; Open Link
	;--------------------------------------
	bsr	ResetLink

	;--------------------------------------
	; Check if calc is ready
	;--------------------------------------
	bsr	IsCalcReady
	tst.w	d0
	beq	\failed

	;--------------------------------------
	; Create Request Message
	;--------------------------------------
	move.w	d3,d4			;strlen
	add.w	#4+4+2,d4		;complete size of message
	move.l	a4,a1			;addr of buffer
	move.w	#$08A2,(a1)+		;Request Var
	move.w	d4,d0			;Message Length
	subq.w	#4,d0			;without first 5 bytes
	move.b	d0,(a1)+		;Message Length
	lsr.w	#8,d0
	move.b	d0,(a1)+
	clr.l	(a1)+
	clr.b	(a1)+			;Var Type
	move.b	d3,(a1)+		;StrLen
	subq.w	#1,d3
	move.l	a3,a2			;save a3
\copy	move.b	(a2)+,(a1)+
	dbra.s	d3,\copy

	;--------------------------------------
	; Calcul checksum and put it in message
	;--------------------------------------
	move.w	d4,d0
	move.l	a4,a0
	addq.l	#4,a0
	subq.w	#4,d0
	bsr	CreateCheckSum
	move.b	d0,(a0)+
	lsr.w	#8,d0
	move.b	d0,(a0)+

	;--------------------------------------
	; Send Request Message
	;--------------------------------------
;#ifdef DBGLINK
	bsr	dbglink_request
;#endif
	
	add.w	#2,d4			;add checksum size
	and.l	#$FFFF,d4
	move.l	d4,-(a7)		;Message Size
	move.l	a4,-(a7)		;Message addr
;#ifdef DBGLINK
	bsr	dbglink_printbytes
;#endif
	TIOS_CALL LIO_SendData
	addq.l	#8,a7
	bsr	WaitForAck
	tst.w	d0
	beq	\failed

	;--------------------------------------
	;GetVarHeader & Var Name
	;--------------------------------------
	bsr	GetByte
	bsr	GetByte
	cmp.b	#$06,d0
	bne	\failed
	bsr	GetWord

	bsr	GetWord			;GetVarSize
	clr.l	d3
	move.w	d0,d3			;d3.L = var size
	bsr	GetWord
	bsr	GetByte			;VarType
	bsr	GetByte			;VarName length

	move.w	d0,d1
	subq.w	#1,d1			;for dbra
	move.l	a4,a0			;buffer
\copy2	bsr	GetByte
	move.b	d0,(a0)+
	dbra.s	d1,\copy2
	clr.b	(a0)+			;null terminated string
	bsr	GetByte			;get "0" ?

	bsr	GetWord			;Get the checksum

	;--------------------------------------
	; Check if keep original folder
	;--------------------------------------
	move.w	d6,d0			; destination Handle
	bne.s	\folderok

	;--------------------------------------
	; If keep, extract folder name
	;--------------------------------------
	suba.w	#10,a7			;create stack frame
	move.l	a7,a1			;buffer addr
	move.l	a3,a0			;'folder\file' string
	bsr	ExtractFolderName	;extract folder name
	
	;--------------------------------------
	; And create folder (if needed)
	;--------------------------------------
	move.w	#%10000000,d0		;Folder Flags
	move.l	a1,a0			;FolderName
	jsr	apilib::vat_CreateFolder
	cmp.w	#EC_FOLDEREXIST,d1
	beq.s	\fok1
	tst.w	d1
	beq.s	\fok1
\ferror	adda.w	#10,a7
	bra	\error

	;--------------------------------------
	; Gets its Handle
	;--------------------------------------
\fok1	API92_FOLDHDL d0
	move.l	a7,a0
	jsr	apilib::vat_Find
	tst.w	d2
	bne.s	\fok2
	moveq.w	#EC_HDLNOTFOUND,d1
	bra.s	\ferror

\fok2	move.w	d1,d6			;Save folder handle in d6
	adda.w	#10,a7

	;--------------------------------------
	; Create file
	;--------------------------------------
\folderok subq.l	#1,d3		;-2+1 because size of data

	clr.w	d1			;flags
	move.w	d3,d2			;file size
	move.l	a4,a0			;var name
	move.w	d6,d0			;Destination Folder
	jsr	apilib::vat_CreateVar	;Return a0.l
	tst.w	d1
	bne	\error
	move.w	d0,d5			;Handle of created file

	bsr	DEREFd0a0
	move.l	a0,a2			;dest file memory
	;--------------------------------------
	; Accept and wait
	;--------------------------------------
	bsr	SendAck
	bsr	SendWaitData
	bsr	WaitForAck
	tst.w	d0
	beq	\failed

	;--------------------------------------
	; Receive var
	;--------------------------------------
	bsr	GetByte			;
	bsr	GetByte
	cmp.b	#$15,d0
	bne	\failed
	bsr	GetWord			;data length

	bsr	GetWord
	bsr	GetWord


	;--------------------------------------
	; Construct dest file and src file
	; strings  
	;--------------------------------------
	move.l	a3,srclink
	suba.w	#30,a7
	move.l	a7,a0			;buffer addr
	move.w	d5,d0			;hdl
	jsr	apilib::GetTIOSFileName
	move.l	a0,dstlink
	lea	ieRequestVar(PC),a0
	jsr	InterfaceEngine
	adda.w	#30,a7

	;--------------------------------------
	; Initialize progress bar 
	;--------------------------------------
	lea	ProgressBar2(PC),a0
	move.w	d3,d0			;Max Value
	divu.w	#100,d0			; = size of file / 100
	bne.s	\nozero
	moveq.w	#1,d0
\nozero	move.w	d0,8(a0)
	clr.w	(a0)			;Current Value

	;--------------------------------------
	; Draw progress bar 
	;--------------------------------------
\draw_progressbar
	lea	ProgressBar2(PC),a0
	addq.w	#1,(a0)			;current value
	moveq.w	#101,d2			;counter
	jsr	apilib::ProgressBarComponent

	;--------------------------------------
	; Copy bytes
	;--------------------------------------
\copy3	subq.l	#1,d2
	beq.s	\draw_progressbar
	bsr	GetByte
	move.b	d0,(a2)+

	dbra.s	d3,\copy3

	;--------------------------------------
	; Get CheckSum
	;--------------------------------------
	bsr	GetWord					;GetChecksum

	;--------------------------------------
	; End of transmission
	;--------------------------------------
	bsr	SendAck					;ack checksum
	bsr	ContinueOrNot			;get EOT
	bsr	SendAck					;ACK	

	clr.w	d1			;No error

\exit	move.w	d6,d2
	adda.w	#50,a7
	
	movem.l	d0-d2/a0-a2,-(a7)
	bsr		LinkDelay
	
	TIOS_CALL OSLinkOpen
	clr.w	-(a7)
	move.l	a7,a2
\wait	move.w	#1,-(a7)			;only one byte
	move.l	a2,-(a7)			;buffer addr
	TIOS_CALL OSReadLinkBlock
	addq.l	#6,a7
	tst.w	d0				;0 bytes read ?
	bne.s	\wait				;wait
	TIOS_CALL OSLinkClose
	addq.l	#2,a7				;delete stack frame
	
	
	movem.l	(a7)+,d0-d2/a0-a2
	
	move.w	d5,d0			;hdl of created var or 0 if failed
	movem.l (a7)+,d3-d6/a0-a4	
	rts

	;--------------------------------------
	; If failed, free hdl if created, and
	; exit with d5=0
	;--------------------------------------
\failed	bsr	DelLinkVar
	moveq.w	#EC_LINKERROR,d1
	bra.s	\exit

\error	clr.w	d5
	bra.s	\exit

;-----------------------------------------------------
; GetDirectory
;Input>
;Out>	d0.w : 	Handle of directory
;		0 if error
;	d1.w : Error Code
;-----------------------------------------------------
GetDir_Error:
	move.w	d4,d0
	beq.s	\nohdl
	bsr	DeleteLinkDir
\nohdl	clr.w	d0
	movem.l (a7)+,d2-d6/a0-a4
	rts

GetDirectory:
	movem.l d2-d6/a0-a4,-(a7)
	move.l	a7,link_error_catcher_a7
	lea	GetDir_Error(PC),a0
	move.l	a0,link_error_handler

	suba.w	#50,a7
	move.l	a7,a4			;addr of buffer

;#ifdef DBGLINK
	bsr	dbglink_init
;#endif

	;--------------------------------------
	; Reset & Open Link
	;--------------------------------------
	bsr	ResetLink

	;--------------------------------------
	; Create buffer to put data into
	;--------------------------------------
	moveq.w #VAT_ENTRYSIZE,d1			;create buffer
	jsr	apilib::array_Create
	move.w	d0,d4					;save hdl in d4
	beq	\memerror
	clr.w	d5			;bu default

	;--------------------------------------
	; Check if calc is ready
	;--------------------------------------
	bsr	IsCalcReady
	bsr	IsCalcReady
	tst.w	d0
	beq	\failed

	;--------------------------------------
	; Request Calc Directory
	;--------------------------------------
	move.l	#REQUEST_DIR_SIZE,-(a7)
	pea	request_dir_data(PC)
	
;#ifdef DBGLINK
	bsr	dbglink_printsend
	bsr	dbglink_printbytes
	bsr	dbglink_printline
;#endif

	TIOS_CALL LIO_SendData
	addq.l	#8,a7
	bsr	WaitForAck
	tst.w	d0
	beq	\failed

	;--------------------------------------
	; Get Current Directory
	;--------------------------------------
	bsr	GetLinkHeader
	tst.w	d0
	beq	\failed

	;--------------------------------------
	; Draw a nice Window
	;--------------------------------------
	lea	ieReceiveDirectory(PC),a0
	jsr	apilib::InterfaceEngine

	;--------------------------------------
	; Loop that receive directory
	;--------------------------------------
\loop	bsr	SendAck
	bsr	SendWaitData
	bsr	WaitForAck
	tst.w	d0
	beq	\failed

	;--------------------------------------
	; Get Entry
	;--------------------------------------
	move.l	a4,a0					;addr of buffer
	bsr	GetVatEntry				;Get Entry
	tst.w	d0
	beq	\failed

	;--------------------------------------
	; Create a new file list if we are on a folder
	;--------------------------------------
	move.w	d5,d0					;File list hdl
	lea	ProgressBar(PC),a2

	btst.b #7,VAT_ENTRYFLAG(a4)
	beq.s	\file

	move.w	d1,8(a2)				;Put Nb Files
	clr.w	(a2)					;Clear counter

	move.l	a4,ieName				;draw folder name
	lea	ieDrawName(PC),a0
	jsr	apilib::InterfaceEngine

	moveq.w #VAT_ENTRYSIZE,d1			;create new File List
	jsr	apilib::array_Create			;Create new file list
	move.w	d0,d5					;save hdl in d5
	beq.s	\memerror				;if error...
	move.w	d5,VAT_ENTRYHDL(a4)			;Insert handle
	
	move.w	d4,d0					;Folder list hdl
	bra.s	\add

\file	addq.w	#1,(a2)
	move.w	d1,VAT_ENTRYHDL(a4)			;Put File Size

	;--------------------------------------
	; And add it to file/folder list
	;--------------------------------------
\add	move.l	a2,a0
	jsr	apilib::ProgressBarComponent

	tst.w	d0			;test if handle is null
	beq.s	\failed
	move.w	a4,a0
	moveq.w #VAT_ENTRYSIZE,d1
	jsr	apilib::array_AddItem
	tst.w	d1
	bne.s	\memerror

	;--------------------------------------
	; Continue ??
	;--------------------------------------
	bsr	SendAck
	bsr	ContinueOrNot
	tst.w	d0
	bne	\loop



\endoflink bsr SendAck

\exit	adda.w	#50,a7
	movem.l	d0-d2/a0-a2,-(a7)
	TIOS_CALL OSLinkReset
	movem.l	(a7)+,d0-d2/a0-a2	
	move.w	d4,d0					;return hdl
	movem.l (a7)+,d2-d6/a0-a4
	rts

\memerror moveq.w #EC_OUTOFMEMORY,d1
	bra.s	\ex
\failed moveq.w	#EC_LINKERROR,d1
\ex	clr.w	d0
	bra.s	\exit



;-----------------------------------------------------
;DeleteLinkDir:
;Input>	d0.w : Handle of base folder
;-----------------------------------------------------
DeleteLinkDir:
	movem.l	d0-d4/a0-a2,-(a7)

	;----------------------------------
	; Lock Handle
	;----------------------------------
	move.w	d0,-(a7)
	TIOS_CALL HeapLock

	;----------------------------------
	; Get Addr
	;----------------------------------
	move.w	(a7),d0			;handle
	bsr	DEREFd0a0
	lea	2(a0),a2

	move.w	(a2)+,d3		;nb folders
	beq.s	\skip
	subq.w	#1,d3			;for dbra

	;----------------------------------
	; Delete Handles
	;----------------------------------
\del	move.w	VAT_ENTRYHDL(a2),-(a7)
	bsr	_HeapFree
	addq.l	#2,a7
	lea	VAT_ENTRYSIZE(a2),a2
	dbra.s	d3,\del

	;----------------------------------
	; UnLock Handle & delete it
	;----------------------------------
\skip	TIOS_CALL HeapUnlock
	bsr	_HeapFree
	addq.l	#2,a7

	movem.l	(a7)+,d0-d4/a0-a2
	rts

;-----------------------------------------------------
; Link Error Catcher
;
;-----------------------------------------------------
LinkErrorCatcher:
	move.l	link_error_catcher_a7(PC),a7
	TIOS_CALL GKeyFlush		;if ON was pressed>flush

;delete d4 etc...
	lea	ieLinkErrorCatcher(PC),a0
	jsr	apilib::InterfaceEngine

	bsr	ResetLink
	; TIOS_CALL OSLinkClose
	clr.w	d0			;failed
	moveq.w	#EC_LINKERROR,d1

	move.l	link_error_handler(PC),a0
	jmp	(a0)

;	movem.l (a7)+,d2-d6/a0-a4
;	rts

;-----------------------------------------------------
; Check if the calc is ready
;Out>	d0.w : 0 = false 1 = true
;-----------------------------------------------------
IsCalcReady
	movem.l d1-d2/a0-a2,-(a7)
	move.l	#IS_READY_SIZE,-(a7)
	pea	is_ready_data(PC)
;#ifdef DBGLINK
	bsr		dbglink_printsend
	bsr		dbglink_printbytes
	bsr		dbglink_printline
;#endif
	TIOS_CALL LIO_SendData
	addq.l	#8,a7

	bsr	WaitForAck
	movem.l (a7)+,d1-d2/a0-a2
	rts

;-----------------------------------------------------
; Check if the calc is ready
;Out>	d0.w : 0 = false 1 = true
;-----------------------------------------------------
EndOfTransmission:
	movem.l d1-d2/a0-a2,-(a7)
	move.l	#EOT_SIZE,-(a7)
	pea		eot_data(PC)
;#ifdef DBGLINK
	bsr		dbglink_printsend
	bsr		dbglink_printbytes
	bsr		dbglink_printline
;#endif
	TIOS_CALL LIO_SendData
	addq.l	#8,a7

	bsr		GetByte
	bsr		GetByte
	movem.l (a7)+,d1-d2/a0-a2
	rts
	
	
;-----------------------------------------------------
; GetLinkHeader
;Input>
;Out>		
;-----------------------------------------------------
GetLinkHeader:
	movem.l d0-d2,-(a7)

;#ifdef DBGLINK
	bsr	dbglink_getlinkheader
;#endif

	bsr	GetByte	;Get ID_CALC
	bsr	GetByte
	cmp.b	#$06,d0
	bne.s	\failed
	
	bsr	GetWord	;get size of data

	move.w	d0,d2
	subq.w	#1,d2		;for dbra

\receive bsr	GetByte
	dbra.s	d2,\receive

	bsr	GetWord	;checksum
	moveq.w #1,d0
\exit	movem.l (a7)+,d0-d2

;#ifdef DBGLINK
	bsr	dbglink_printline
;#endif
	rts

\failed clr.w	d0
	bra.s	\exit

;-----------------------------------------------------
; GetVatEntry
;Input>	a0.l : addr of buffer
;Out>		d0.w : 0=failed 1=success
;		d1.w : Nb Files in folder / File Size
;-----------------------------------------------------
GetVatEntry:
	movem.l	d2/a0-a2,-(a7)

;#ifdef DBGLINK
	bsr		dbglink_getvatentry
;#endif

	move.l	a0,a2			;save addr

	bsr	GetByte		;Get ID_CALC
	bsr	GetByte
	cmp.b	#$15,d0		;$15
	bne.s	\failed
	bsr	GetWord
	cmp.w	#$12,d0		;only ti92+/ti89 ?
	bne.s	\exit

	bsr	GetByte
	bsr	GetByte
	bsr	GetByte
	bsr	GetByte

	moveq.w #7,d2
	move.l	a2,a0
\name	bsr	GetByte
	move.b	d0,(a0)+
	dbra.s	d2,\name

	clr.w	(a0)+
;#ifdef TIPLUS
	clr.w	(a0)+			;flag
;#endif
	bsr	GetByte
	cmp.b	#$1F,d0
	bne.s	\norep
	bset.b	#7,-1(a0)
\norep	bsr	GetByte
	bsr	GetWord			;Get File Size / Nb Folders
	move.w	d0,d1			;Save it

	bsr	GetWord
	bsr	GetWord			;checksum

	moveq.w #1,d0			;success
\exit	movem.l (a7)+,d2/a0-a2


;#ifdef DBGLINK
	bsr	dbglink_printline
;#endif
	rts

\failed clr.w	d0
	bra.s	\exit


;-----------------------------------------------------
;Out>	d0.w : Byte
;-----------------------------------------------------
GetByte:
	movem.l d1-d2/a0-a2,-(a7)

	clr.w	-(a7)
	move.l	a7,a2

	move.l	#50,-(a7)
	move.l	#1,-(a7)
	move.l	a2,-(a7)
	TIOS_CALL LIO_RecvData
	lea	12(a7),a7

	tst.w	d0
	bne	LinkErrorCatcher

	clr.l	d0
	move.b	(a2),d0

	addq.l	#2,a7
	
;#ifdef DBGLINK
	bsr	dbglink_printbyte
;#endif
	
	movem.l (a7)+,d1-d2/a0-a2
	rts

;-------------
; OLD VERSION
;-------------
	movem.l d1-d3/a0-a2,-(a7)
	clr.w	-(a7)
	move.l	a7,a2
	move.l #$5000,d3			;timer

\wait	move.w	#1,-(a7)			;only one byte
	move.l	a2,-(a7)			;buffer addr
	TIOS_CALL OSReadLinkBlock
	addq.l	#6,a7

	subq.l	#1,d3
	beq	LinkErrorCatcher

	tst.w	d0				;0 bytes read ?
	beq.s	\wait				;wait
	
	clr.w	d0
	move.b	(a2),d0
	addq.l	#2,a7				;delete stack frame
	movem.l (a7)+,d1-d3/a0-a2
	rts


;-----------------------------------------------------
;Out>	d0.w : Word
;-----------------------------------------------------
GetWord:
	move.l	d1,-(a7)
	bsr	GetByte
	move.w	d0,d1
	bsr	GetByte
	lsl.w	#8,d0
	move.b	d1,d0
	move.l	(a7)+,d1
	rts

;-----------------------------------------------------
;Out>	d0.w : Word
;-----------------------------------------------------
GetLong:
	move.l	d1,-(a7)
	bsr	GetWord
	move.w	d0,d1
	bsr	GetWord
	lsl.l	#8,d0
	lsl.l	#8,d0
	move.w	d1,d0
	move.l	(a7)+,d1
	rts

;-----------------------------------------------------
; WaitForAck
;Input>
;Out>		d0.w : 0=false  1=true
;-----------------------------------------------------
WaitForAck:
;#ifdef DBGLINK
	bsr	dbglink_waitack
;#endif
	bsr	GetByte		;Get ID_CALC
	bsr	GetByte
	cmp.b	#$56,d0
	bne.s	\failed
	bsr	GetByte
	bsr	GetByte
	moveq.w #1,d0
\exit
;#ifdef DBGLINK
	bsr		dbglink_printline
;#endif
	rts
	
\failed clr.w	d0
	bra.s	\exit

;-----------------------------------------------------
; ContinueOrNot
;Input>
;Out>		d0.w : 0=false  1=true
;-----------------------------------------------------
ContinueOrNot:
;#ifdef DBGLINK
	bsr	dbglink_continueornot
;#endif

	bsr	GetByte		;Get ID_CALC
	bsr	GetByte
	cmp.b	#$78,d0
	bne.s	\stop
	bsr	GetByte
	bsr	GetByte
	moveq.w #1,d0
	
\exit
;#ifdef DBGLINK
	bsr		dbglink_printline
;#endif
	rts
	
\stop	clr.w	d0
	bra.s	\exit

;-----------------------------------------------------
; SendAck
;Input>
;Out>		
;-----------------------------------------------------
SendAck:
;#ifdef DBGLINK
	bsr	dbglink_printsend
;#endif

	movem.l d0-d2/a0-a2,-(a7)
	move.l	#IS_READY_SIZE,-(a7)
	pea	send_ack_data(PC)
;#ifdef DBGLINK
	bsr	dbglink_printbytes
	bsr	dbglink_printline
;#endif
	TIOS_CALL LIO_SendData
	addq.l	#8,a7
	movem.l (a7)+,d0-d2/a0-a2
	rts

;-----------------------------------------------------
; SendWaitData
;Input>
;Out>		
;-----------------------------------------------------
SendWaitData:
;#ifdef DBGLINK
	bsr	dbglink_printsend
;#endif

	movem.l d0-d2/a0-a2,-(a7)
	move.l	#WAIT_DATA_SIZE,-(a7)
	pea	wait_data_data(PC)
;#ifdef DBGLINK
	bsr	dbglink_printbytes
	bsr	dbglink_printline
;#endif
	TIOS_CALL LIO_SendData
	addq.l	#8,a7
	movem.l (a7)+,d0-d2/a0-a2
	rts

;-----------------------------------------------------
;CreateCheckSum
;Input>	a0.l : input string,buffer must be large enough
;	to add the 2 bytes checksum
;	d0.w : len of the string
;Out>	a0.l : addr where to put ck
;	d0.w : Checksum
;-----------------------------------------------------
CreateCheckSum:
	movem.l	d1-d2,-(a7)
	clr.l	d1
	clr.l	d2

	tst.w	d0
	beq.s	\exit
	subq.w	#1,d0			;for dbra

\calc	move.b	(a0)+,d2
	add.w	d2,d1			;add two WORDS
	dbra.s	d0,\calc

\exit	move.w	d1,d0
	movem.l	(a7)+,d1-d2
	rts
