

;--------------------------------------------------
;Function called with Diamond+P to turn
;off the calc and protect it with a 
;password
;--------------------------------------------------
ProtectNow:
	movem.l d0-d7/a0-a6,-(a7)

	jsr	apilib::util_GetAPD
	move.l	d0,-(a7)
	moveq.l	#20*3,d0
	jsr	apilib::util_SetAPD

\invalid jsr     apilib::ClearScreen
	trap   #4		              ;turn off the calc
	bsr     AskPasswordWin
	tst.w   d0
	beq.s   \invalid

	move.l	(a7)+,d0
	jsr	apilib::util_SetAPD

	bsr     RedrawScreen
	movem.l (a7)+,d0-d7/a0-a6
	bra     Loop


;-----------------------------------------------------
; d0.w : handle of EXPR
;-----------------------------------------------------
ShowEXPR1D:
;#ifdef TIPLUS
	movem.l	d0-d2/a0-a2,-(a7)
	
	move.w	d0,d2

	lea	-60(a7),a7		;ErrorFrame
	move.l	a7,-(a7)			
	TIOS_CALL ER_catch
	addq.l	#4,a7
	tst.w	d0			;Check if error
	bne	\expr_error

	move.w	d2,d0


	move.w	d0,-(a7)
	TIOS_CALL HeapLock
	TIOS_CALL HToESI		;get the expr ESI 
	move.l	a0,-(a7)
	TIOS_CALL QSysProtected
	addq.l	#4,a7
	tst.w	d0
	bne.s	\exit

	move.w	#WLCD-20,d0		;LCD width
	lsr.l	#2,d0			;/4
	move.w	d0,-(a7)
	clr.w	-(a7)
	move.l	a0,-(a7)		;pushes ESI
	TIOS_CALL Parse1DExpr	;return in d0=hdl
	addq.l	#8,a7
	tst.w	d0
	beq.s	\exit

\ok	move.w	d0,-(a7)		;
	TIOS_CALL HLock		;Lock and dereference handle
	move.l	a0,-(a7)
	TIOS_CALL ST_helpMsg
	addq.l	#4,a7
	bsr	_HeapFree		;delete handle
	addq.l	#2,a7

\exit	TIOS_CALL HeapUnlock
	addq.l	#2,a7
	TIOS_CALL ER_success

\expr_error
	lea	60(a7),a7
	movem.l	(a7)+,d0-d2/a0-a2
;#endif
	rts




;--------------------------------------------------
; Function called by PCTools98 for size
; optimization.
;--------------------------------------------------
DEREFd0a0:
	move.l	d0,-(a7)
        jsr	apilib::DEREFd0a0
	move.l	a0,d0
	btst.l	#0,d0
	bne	EC_Align
\exit	move.l	(a7)+,d0
	rts



;---------------------------------------------------
;       Run a program and redraw screen 
;	when it exits
;	(redraw program info  bar)
;Input> d0.w    : handle of the program
;Out>	d0.w   : return value
;----------------------------------------------------
ExecFileAndRedraw:
	bsr	ExecFile		;exec the file

;---------------------------------------------------
;	Redraw without clearing the status
;	bar
;
;Input> /
;Out>	/
;----------------------------------------------------
RedrawKeepingStatusBar:
	movem.l	d0-d2/a0-a4,-(a7)

	suba.w	#(30*8),a7		;create the stack frame
	move.l	a7,a1
	move.l	a1,a3

	move.l	#LCD_MEM,a0		;addr of LCD
	adda.w	#(30*(HLCD-6)),a0	;
	move.l	a0,a2			;save a0

	moveq.w	#44,d1			;Copy info bar in the stack frame
\cpy	move.l	(a2)+,(a3)+		;8*30/4 -1 =59
	dbra.s	d1,\cpy

	bsr	RedrawScreen		;Redraw Screen

	tst.w	d0			;if there were an error
	beq.s	\exit			;
	moveq.w	#44,d1			;Restore info bar
\cpy2	move.l	(a1)+,(a0)+
	dbra.s	d1,\cpy2
\exit	adda.w	#(30*8),a7

	movem.l	(a7)+,d0-d2/a0-a4
	rts


;----------------------------------------------------
;Input>	d0.w : File Handle
;
;----------------------------------------------------
PasteInHome:
;#ifdef TIPLUS
	movem.l	d0-d4/a0-a3,-(a7)

	;-------------------------------
	; First find program string :
	; folder\file
	;-------------------------------
	suba.w	#24,a7
	move.l	a0,a2				;save it
	move.l	a7,a0				;buffer addr
	jsr	apilib::GetTIOSFileName
	tst.w	d0
	beq.s	\exit

	;-------------------------------
	; Create and clear event struct
	;-------------------------------
	suba.w	#30,a7			;EVENT struct
	move.l	a7,a0
	move.l	a0,a3			;clear it
	moveq.w	#29,d0
\clr	clr.b	(a0)+
	dbra.s	d0,\clr

	;-------------------------------
	;Get TIHOME AppID
	;-------------------------------
	pea	ev_tihome(PC)	
;	TIOS_CALL EV_getAppID
	addq.l	#4,a7

	;-------------------------------
	; Send CM_CLR event
	;-------------------------------
;	move.w	#CM_CLR,(a3)		;EVENT.Type
	move.l	a3,-(a7)		;&Event
	move.w	d0,-(a7)		;AppID
	TIOS_CALL EV_sendEvent

	;-------------------------------
	;Get string length
	;-------------------------------
	move.l	a2,a0
	clr.l	d0
\length	tst.b	(a0)+
	beq.s	\el
	addq.l	#1,d0
	bra.s	\length
\el	subq.l	#1,a0
	move.b	#'(',(a0)+
	clr.b	(a0)+
	addq.w	#1,d0

	;-------------------------------
	; Replace text in clipboard
	;-------------------------------
	clr.l	-(a7)			;0
	move.w	d0,-(a7)		;strlen
	move.l	a2,-(a7)		;string addr
	TIOS_CALL CB_replaceTEXT
	lea	10(a7),a7

	;-------------------------------
	; Send CM_MENU_PASTE event
	;-------------------------------
;	move.w	#CM_MENU_PASTE,(a3)
	TIOS_CALL EV_sendEvent
	addq.l	#6,a7

	adda.w	#30,a7			;del event struct

\exit	adda.w	#24,a7
	movem.l	(a7)+,d0-d4/a0-a3
	rts	

;        ev.Type = CM_CLR;
;        EV_sendEvent(EV_getAppID("TIHOME"),&ev);
;        sprintf(sbuffer,"%s\\%s()",interface.foldername,interface.filename);
;        CB_replaceTEXT(sbuffer, strlen(sbuffer), 0); 
;        ev.Type = CM_MENU_PASTE;
;        EV_sendEvent(EV_getAppID("TIHOME"),&ev);


ev_tihome dc.b	"TIHOME",0
	ds.w	0
;#endif


;------------------------------------------------------
;       ConvStr                 Jimmy Mardell
; Input :       d2.? : The number
;               a1.l : The pointer TO THE END of the string
; (I have a little beat change some part of the code for
;       using in PCTOOLS 92)
;------------------------------------------------------
ConvStr:
	movem.l d0/d2,-(a7)     
RepConv:                        
	divu     #10,d2         
	move.l  d2,d0
	swap    d0
	add.b    #48,d0
	move.b  d0,-(a1)
	and.l    #$FFFF,d2
	bne.s RepConv

	movem.l (a7)+,d0/d2
	rts


;-------------------------------------------------
; Print the number in d0 in decimal
; Input :       d2.w : the number
;               d0.w : X
;               d1.w : Y
;-------------------------------------------------
PrintNumber:
	movem.l d0-d2/a0-a2,-(a7)

	lea     endbuf(PC),a1
	bsr.s   ConvStr
	bsr     PrintSp

	movem.l (a7)+,d0-d2/a0-a2
	rts


roottxt:
	dc.b    "TI92:",0


;----------------------------------------------------
;PCTOOLS GetKey function
;APD Support
;[Diamond]+[ON] support
;
;Output : d0 : key
;----------------------------------------------------
GetKey:
	jmp	apilib::WaitKey

;------------------------------------------------
; copy file name from a2 in a1 with 8 char + 0
;
;input> a2.l : addr of source file name
;out>   a1.l : address of beg of buf
;------------------------------------------------
CpyFileName:
	lea     buf(PC),a1
	movem.l a0-a2/d0-d3,-(a7)

	moveq.w #7,d0           ;8 laps
\cpy    tst.b   (a2)
	beq.s   \out
	move.b  (a2)+,(a1)+
	dbra.s  d0,\cpy
	bra.s   \8char

\out    
\zer    move.b  #$20,(a1)+
	dbra.s  d0,\zer
\8char  clr.b   (a1)+

	movem.l (a7)+,a0-a2/d0-d3
	rts

;---------------------------------------------------------
;Draw Free RAM in the UpBar
;---------------------------------------------------------
DrawFreeRAM:
	movem.l	d0-d3/a0-a2,-(a7)
	jsr	apilib::GetFreeRAM

	suba.w	#40,a7
	move.l	a7,a1
	movem.l	d0-d2/a0-a1,-(a7)
	move.l	d0,-(a7)
	pea	freeram(PC)
	move.l	a1,-(a7)
	bsr	_sprintf
	lea	12(a7),a7
	movem.l	(a7)+,d0-d2/a0-a1

	moveq.w #8,d0           ;X
	moveq.w #15,d1          ;Y
	bsr     PrintSp
	adda.w	#40,a7

	movem.l	(a7)+,d0-d3/a0-a2
	rts
