;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		style3f.xas
;	Utility>	Routines for style3 File Show
;
;-----------------------------------------------------------

Style3_file:
	dc.b	%00000001,0
	dc.l	sg1_MakeList
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	s3f_DrawItem
	dc.l	s3f_DrawFirstItem
	dc.l	s3f_PadDown
	dc.l	s3f_PadUp
	dc.l	slf_SelectItem
	dc.l	s1_ClearList
	dc.l	s3f_DeleteItem
	dc.l	s3f_ShowComment
	dc.l	s3f_KeyEnter
	dc.l	sg1_EnableMenus
	dc.l	slf_DrawInterface
	dc.l	s3_InitStyle
	dc.l	sg1_GetItemXY
	dc.l	s3f_PadLeft
	dc.l	s_NOP_Loop
	dc.l	sg2_OtherKey
	dc.l	s1_BeforeDrawingList
	dc.l	s3f_RedrawListArea
	dc.l	s3f_RefreshUpBar

;-------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
tree_SetFocusOnFile:
	tst.w	d6				;Cannot enter a folder if
	beq.s	\skip				;d6=0

	;--------------------------------------
	; Get Hdl of folder where we want
	; to enter
	;--------------------------------------
	bsr     GetCurrentVATAddr
	move.w	VAT_ENTRYHDL(a0),d0

	bsr	Free_ListBuf			;free ListBuf_Hdl handle
	lea	Style3_file(PC),a6


	;--------------------------------------
	; Save folder pos
	; (folder_hdl contain already the hdl of
	; folder list)
	;--------------------------------------
	lea	folder_d6(PC),a0
	move.w	d6,(a0)+
	move.w	d7,(a0)+
	move.w	NbItem(PC),(a0)+

	move.w	d0,ListReal_Hdl			;Handle of folder to enter in

	;--------------------------------------
	; Restore position if needed
	;--------------------------------------
	clr.w	d6
	clr.w	d7
	cmp.w	file_lasthdl(PC),d0
	bne.s	\skip
	lea	file_d6(PC),a0
	move.w	(a0)+,d6
	move.w	(a0)+,d7

\skip
	rts


;-------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
s3f_DrawItem:
	bsr     CpyFileName     ;return a2 in a1 with 8 char+0
	move.w	#104,d0          ;X pos
	bsr     PrintSp         ;a1&d1 already set

;#ifdef TI89
;#else
	moveq.w	#13,d0			;offset
	bsr	sg1_DrawVATFlags
;#endif

	;-------------------------------------------
	; Selection attribute
	;-------------------------------------------
	btst.b  #SLCT_BIT,ENTRYFLG+1(a2)
	beq.s   \noslct
	moveq.w #15,d2          ;char=selected
	moveq.w #89,d0           ;X pos. Y already set
	bsr     printchar
\noslct

;#ifdef TI89
	move.w  ENTRYHDL(a2),d0		;File Handle
	bsr     DEREFd0a0		;File Address
	;-------------------------------------------
	; Get extension of file, supporting 
	; Zipped files
	;-------------------------------------------
	move.l	d1,-(a7)		;Save d1=Y
	bsr     GetFileExt_z		;Get file extension
\no_zip	move.l	(a7)+,d1		;restore d1=Y

;#else
	moveq.w	#1,d0
	bsr	sg1_DrawFileInformation		;return d2
;#endif

	;-------------------------------------------
	; Show file associated picture
	;-------------------------------------------
	jsr     apilib::vat_ExtID_Picture ;d2 is set, return a0
	moveq.w #12,d0           	;col (x=16) 
	bsr     PutImgAddr		;put picture giving its address  

;#ifdef TI89
;#else

;#endif

	rts

;-------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
s3f_DrawFirstItem:
	movem.l d0-d2/a0,-(a7)

	lea	titxt(PC),a0
	moveq.w	#TI_GFX,d2
;#ifdef NSTUB
	API92_FOLDHDL d0
	cmp.w	ListReal_Hdl(PC),d0
;#else
	API92_CMPFOLDHDL ListReal_Hdl
;#endif
	beq.s	\skip
	lea	backtxt(PC),a0
	moveq.w	#BACK_GFX,d2
\skip	move.b	#100,(a0)
	bsr	printf
	move.b	#17,(a0)
	moveq.w #11,d0
	moveq.w #LSTY,d1
	bsr     PutImg
	movem.l (a7)+,d0-d2/a0
	rts


;-------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
s3f_PadDown:
	INTERRUPT_OFF
	bsr     SelectItem		;Deselect the current item

	cmp.w   NbItem(PC),d6       
	bne.s	\skip
	clr.w	d6
	clr.w	d7
	bra.s	\rd

\skip	addq.w  #1,d6			;IPosScreen
	moveq.w	#1,d4			;RedrawList
	cmp.w   #NBVARPERPAGE-2,d7	;Need scroll ?
	ble.s   \noScroll		;if no, jump
\rd	bsr     RedrawList_WML
	bra.s	\exit
\noScroll addq.w	#1,d7
	bsr     SelectItem		;Select the item
	bsr     ShowComment		;Comment

\exit	INTERRUPT_ON
	rts

;-------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
s3f_PadUp:
	INTERRUPT_OFF
	bsr     SelectItem		;Deselect the current item

	tst.w	d6			;First Item ?
	bne.s	\skip
	move.w	NbItem(PC),d6
	move.w	#NBVARPERPAGE-1,d7
	cmp.w	d7,d6
	bhi.s	\skip2
	move.w	d6,d7
\skip2	bra.s	\rd

\skip	subq.w  #1,d6			;IPosScreen
	tst.w	d7			;Need scroll ?
	bne.s   \noScroll		;if no, jump
\rd	bsr     RedrawList_WML
	bra.s	\exit

\noScroll subq.w	#1,d7
	bsr     SelectItem		;Select the item
	bsr     ShowComment		;Comment

\exit	INTERRUPT_ON
	rts


;-------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
s3f_PadLeft:
	bsr	tree_SetFocusOnFolder
	bsr	RedrawList
\exit	bra	Loop


;-------------------------------------------------------------------------
; Encapsulate sg1_KeyEnter function to make a different effect if
; we press enter on the first item
;-------------------------------------------------------------------------
s3f_KeyEnter:
	tst.w	d6
	bne	sg1_KeyEnter
	bra	s3f_PadLeft


;-------------------------------------------------------------------------
;
;-------------------------------------------------------------------------
s3f_DeleteItem:
	movem.l	d0-d3/a0,-(a7)
	bsr	ItemScrPos
	lea	9(a0),a0

	moveq.w #7,d3           ;delete 8 lines
	
\line
;#ifdef TI89
	moveq.w	#17-10,d1
;#else
	moveq.w #27-10,d1		;and 8 cols
;#endif
\row	clr.b   1(a0,d1.w)
	dbra.s  d1,\row
	move.b	#%00000101,28-9(a0)
	lea     30(a0),a0       ;adda.w #30,a0
	dbra.s  d3,\line
	movem.l	(a7)+,d0-d3/a0	
	rts

;-------------------------------------------------------------------------
; Redraw the two parts of the tree and give focus to file side
;-------------------------------------------------------------------------
s3f_RedrawListArea:
	INTERRUPT_OFF

	lea	s1_Interface(PC),a0
	jsr	apilib::InterfaceEngine

	bsr	tree_SetFocusOnFolder
	bsr	RedrawList
	bsr	tree_SetFocusOnFile
	bsr	RedrawList

	INTERRUPT_ON
	rts

;-------------------------------------------------------------------------
;-------------------------------------------------------------------------
s3f_RefreshUpBar:
	movem.l	d0-d2/a0-a2,-(a7)

	INTERRUPT_OFF


	lea     UpBarRct(PC),a0				;clear old bar
	bsr     DrawRect

	moveq.w #0,d1
	bsr     FontSet

	bsr	DrawFreeRAM

;#ifdef TI89
	tst.w	d6
	beq.s	\noinfo
	bsr	GetCurrentVATAddr
	move.l	a0,a2
	moveq.w	#1,d0					;style3
	moveq.w	#15,d1					;Y
	bsr	sg1_DrawFileInformation

	moveq.w	#5,d0					;offset
	bsr	sg1_DrawVATFlags

\noinfo
;#endif

	moveq.w #1,d1
	bsr     FontSet

	INTERRUPT_ON

	movem.l	(a7)+,d0-d2/a0-a2
	rts

;-------------------------------------------------------------------------
;-------------------------------------------------------------------------
s3f_ShowComment:
;#ifdef TI89
	bsr	s3f_RefreshUpBar
;#endif
	jmp	sg1_ShowComment
