;/////////////////////////////////////////////////////////
;=========================================================
;       XETRION ASSEMBLY SOURCE CODE
;
;       (c) NeXO Sofware, Benoit SCHERRER
;       mail : p.c.scherrer@wanadoo.fr
;=========================================================
;/////////////////////////////////////////////////////////




PctLauncherComm	dc.l	0

;-----------------------------------------------------------
;///////////////////////////////////////////////////////////
; 		INITIALIZATIONS
;///////////////////////////////////////////////////////////
;-----------------------------------------------------------
pctprgm@0000:

	;------------------------------------------------
	; Save address of structure communication between
	; pct and the launcher
	;------------------------------------------------
	move.l	a0,PctLauncherComm

	;------------------------------------------------
	; If last time we exit pct it was to exec a file
	; then clean 
	;------------------------------------------------
	tst.w	(a0)
	beq.s	\normallaunch
	bsr	CleanAfterFileExecution


\normallaunch
	clr.w	(a0)

	;------------------------------------------------
	; DO SOME INITIALIZATIONS
	;------------------------------------------------

;#ifdef NSTUB
	bsr	nostub_InitPct
	tst.w	d0
	beq	PCTOOLS_RTS
;#endif

;#ifdef TIPLUS
;#else
	lea     22(a2),a2               ;adda.w #22,a2
	move.w  (a2),-(a7)              ;save the word
	move.l  a2,-(a7)                ;save the address
	clr.w   (a2)
;#endif

	;------------------------------------------------
	; Check whether this version is designed for
	; the current calculator
	;------------------------------------------------
;#ifdef TIPLUS
	bsr	WhichCalc
	
;#ifdef TI89
	cmp.w	#IDCALC_89,d0
	beq.s	\ok
	cmp.w	#IDCALC_89TI,d0
	beq.s	\ok
;#else
	cmp.w	#IDCALC_92P,d0
	beq.s	\ok
	cmp.w	#IDCALC_V200,d0
	beq.s	\ok
;#endif
	lea	ieInvalidCalc(PC),a0
	jsr	apilib::InterfaceEngine
	bra	END
\ok
;#endif

	;------------------------------------------------
	; Init Key Delays
	;------------------------------------------------
;#ifdef TIPLUS
	move.w	#100,-(a7)
	TIOS_CALL OSInitKeyInitDelay
	move.w	d0,d3			;save register
	move.w	#15,(a7)
	TIOS_CALL OSInitBetweenKeyDelay
	addq.l	#2,a7

	;------------------------------------------------
	; Save previous values of keys delay to restore 
	; them before returning to TIOS
	;------------------------------------------------
	move.w	d0,-(a7)
	move.w	d3,-(a7)
;#endif

	;------------------------------------------------
	; Create a stack frame for plugins list
	;------------------------------------------------
	suba.w  #512,a7                 ;create a stack frame
	move.l  a7,PluginTableAddr      ;512 bytes for 256 plugins at max
	clr.w	(a7)			;0 plugins (for unarchive fct)

	;------------------------------------------------
	; Save a7 for internal error catcher
	;------------------------------------------------
	move.l	a7,save_a7		;save a7 after plugins buffer
	clr.w	EC_NoLoop

	;------------------------------------------------
	; Get HW Version of the calc
	;------------------------------------------------
	jsr	apilib::util_GetHWVersion
	move.b	d0,HWVERSION

	;------------------------------------------------
	; Read CFG File of previous session of Pctools
	;------------------------------------------------
	bsr	CFG_ReadData

	;------------------------------------------------
	; If anormal exiting reset some values read from
	; CFG files to avoid bugs
	;------------------------------------------------
	move.w	NormalExit(PC),d0	;check if normal exit at previous session
	beq.s	\nopb
	clr.l	ListBuf_Hdl		;else reset some values
	; clr.w	ListReal_Hdl		;not usefull (cf clr.l)
	clr.l	session_saved6
	; clr.w	session_saved7
	clr.l	session_style
	; clr.w	session_treehdl

	;------------------------------------------------
	; Set NormalExit value in CFG file to track crashes
	;------------------------------------------------
\nopb	move.w	#1,NormalExit
	bsr	CFG_SaveData

	;------------------------------------------------
	; Configure menu state
	;------------------------------------------------
	bsr	SetMenuMemState
	bsr	SetAnimatedState

	;------------------------------------------------
	; Clear global registers : in the program
	; d6 = Zero based index of current item
	; d7 = Zero based index of screen pos
	; (and a6.l = Address of current style table)
	;------------------------------------------------
	clr.l	d6
	clr.l	d7

	lea     VirtualList(PC),a6	;by default

	;------------------------------------------------
	; If previous style = VirtualList skip
	;------------------------------------------------
	move.w	session_style(PC),d2	;previous session
	beq.s	\next			;0=VirtualList

	;------------------------------------------------
	; Get selected folder of previous session
	;------------------------------------------------
	move.w  ListReal_Hdl(PC),d1     ;Folder during last session
	cmp.w	#STYLEID_TREE,d2	;IF tree mode, folder side
	bne.s	\notree_fold		;check that selected file exists
	move.w	session_tree_hdl(PC),d1

\notree_fold
	;------------------------------------------------
	; Check that the folder exists
	;------------------------------------------------
	tst.w	d1			;if hdl=0 skip
	beq.s	\next
	API92_FOLDHDL d0
	cmp.l	d0,d1
	beq.s	\next
	jsr     apilib::vat_FindHdl      ;Check if still valid
	tst.w   d2
	beq.s   \vlist			;if not

	;------------------------------------------------
	; Set style only if folder exists
	; (else stay in Virtual List)
	;------------------------------------------------
	bsr	GetStyleAddr		;Get selected style table according to menu
	move.l	a0,a6			;

	;------------------------------------------------
	; If style is tree, file side, temporaly set
	; style to tree, folder side (for InitStyle)
	;------------------------------------------------
	cmp.w	#STYLEID_TREEF,session_style
	bne.s	\next
	lea	Style3(PC),a6
	bra.s	\next

\vlist	clr.w	session_style
\next	
	;------------------------------------------------
	; Do some initialisations
	;------------------------------------------------
	moveq.w #1,d1                   ;Set medium font
	bsr     FontSet                 ;

;#ifdef TIPLUS                          ;
	clr.w   ListBuf_Hdl             ;clear list buffer hdl
;#else
	bsr     Free_ListBuf
;#endif

	;------------------------------------------------
	; Create plugin table and load libraries used
	; by plugins
	;------------------------------------------------
	bsr     RefreshPluginTable
	bsr	loadPluginsLibraries
	
	;------------------------------------------------
	; Call PLUGIN - FUNCTION 0  =  Start of PCTools
	;------------------------------------------------
	moveq.w #0,d4                   ;function 0 = InitPCT98
	bsr     ExecPlugin
	tst.w   d0                      ;if error
	bne     Exit                    ; exit

	;------------------------------------------------
	; Check if the nested folder structure is valid
	; (ex: if a folder has been deleted)
	;------------------------------------------------
	jsr     apilib::nf_CheckIfValid


	clr.b   allownewfold


	;------------------------------------------------
	; PCTOOLS Bolt : ask for password if needed
	;------------------------------------------------
	btst.b  #2,4+mnuSecureProperties(PC) ;pct bolt ?
	beq.s   \nobolt
	bsr     AskPasswordWin
	tst.w   d0                      ;if error exit
	beq     Exit    

	;------------------------------------------------
	; Initialize current style 
	; (according to a6 = current style table)
	;------------------------------------------------
\nobolt bsr     InitStyle

	bsr	RestoreUserPosition

;	bsr	GetCurrentStyleID
;	tst.w	d0
;	beq.s	\setpos
;	cmp.w	#STYLEID_DETAILED,d0
;	beq.s	\setpos
;	cmp.w	#STYLEID_LIST,d0
;	beq.s	\setpos
;	cmp.w	#STYLEID_TREE,d0	;if TREE don't check ListReal
;	bne.s	\nos3
;\setpos	move.w	session_saved6(PC),d6	;if style3->Set d6/d7
;	move.w	session_saved7(PC),d7
;\nos3




;-----------------------------------------------------------
;///////////////////////////////////////////////////////////
; 		BIG LOOP OF THE PROGRAM
;///////////////////////////////////////////////////////////
;-----------------------------------------------------------

LoopRDScr bsr   RedrawScreen
	bra.s   Loop
LoopRDList: bsr RedrawList
	bra.s	Loop
LoopRDListArea: bsr	RedrawListArea

Loop	bsr     GetKey

	;---------------------------------------
	; CALL PLUGIN - FUNCTION 3 = Key Pressed
	;---------------------------------------
	move.l  d0,-(a7)        ;value of keycode
	moveq.w #3,d4           ;function 2 = KeyPressed
	bsr     ExecPlugin
	move.l  (a7)+,d0        ;restore it

	;------------------------------------------------
	; Main key manager
	;------------------------------------------------
	cmp.w   #PAD_UP,d0
	beq     up
	cmp.w   #PAD_DOWN,d0
	beq     down
	cmp.w   #$0D,d0
	beq     KeyEnter
	cmp.w   #PAD_RIGHT,d0
	beq     PadRight
	cmp.w   #PAD_LEFT,d0
	beq     PadLeft

	;------------------------------------------------
	; Call key manager of current style
	;------------------------------------------------
	bra     OtherKey

	;------------------------------------------------
	; If key hasn't been processed by style...
	;------------------------------------------------
OK_Continue:
	cmp.w   #KM_TOOLS_SELECT,d0
	beq     SelectFile
	cmp.w   #KM_SECURE_LOCK,d0	;[<>] [L]
	beq     Lock2    
	cmp.w   #KM_SECURE_HIDE,d0	;[<>] [H]
	beq     Hide2
	cmp.w   #KM_SECURE_PROTECT,d0	;[<>] [P]
	beq     ProtectNow
	cmp.w   #KM_FILE_NEWFOLDER,d0
	beq     CreateFolder2		;[<>] [N]
	cmp.w   #KM_FILE_DELETE,d0
	beq     Delete2			;[<-]
	cmp.w   #KM_FILE_RENAME,d0
	beq     Rename2			;[<>] [R]
	cmp.w   #KM_FILE_MOVE,d0        
	beq     Move2			;[<>] [M]
	cmp.w   #KM_FILE_COPY,d0
	beq     Copy2			;[<>] [C]

;#ifdef TIPLUS
	cmp.w   #KM_FILE_ARCHIVE,d0	
	beq     Archive
	cmp.w   #KM_FILE_UNARCHIVE,d0
	beq     Unarchive
;#endif

	;------------------------------------------------
	; Call menu key manager
	;------------------------------------------------
	bra     MenuManagement

	;------------------------------------------------
	; Should we exit PCTools ?
	;------------------------------------------------
EndMenu cmp.w   #KM_FILE_EXIT,d0	;[ESC]
	beq.s   Exit
	cmp.w   #4360,d0        	;[2nd]+[ESC]
	beq.s   Exit

	;---------------------------------------
	; CALL PLUGIN - FUNCTION 2 = Key Pressed
	; Call key manager of plugins
	; (don't use extensions)
	;---------------------------------------
	move.l  d0,-(a7)        ;value of keycode
	moveq.w #2,d4           ;function 3 = KeyPressed
	bsr     ExecPluginDiscardingExt
	addq.l  #4,a7

	btst.b	#0,d0
	bne.s	\skipprocess	
	bsr	ShowComment
\skipprocess
glp1    bra     Loop



;-----------------------------------------------------------
;///////////////////////////////////////////////////////////
; 		TERMINATE THE PROGRAM
;///////////////////////////////////////////////////////////
;-----------------------------------------------------------
Exit:
	;-----------------------------------
	;CALL PLUGIN - FUNCTION 1 = End of PCT
	;-----------------------------------
	moveq.w #1,d4
	bsr     ExecPlugin
	tst.w   d0
	bne.s   glp1


ExitWithoutPluginCall:

	;-----------------------------------
	; Deselect all files of current folder
	;-----------------------------------
	bsr     DeSelectAll

	;-----------------------------------
	; save session_style for next session
	;-----------------------------------
	bsr	GetCurrentStyleID
	cmp.w	#STYLEID_TREEF,d0
	ble.s	\nozero
	clr.w	d0
\nozero	move.w	d0,session_style

	;-----------------------------------
	; Save d6/d7 position
	;-----------------------------------
	bsr	SaveUserPosition

	;move.w	d6,session_saved6
	;move.w	d7,session_saved7

	;cmp.w	#STYLEID_TREEF,d0
	;bne.s	\notreef
	;move.w	folder_d6(PC),session_saved6
	;move.w	folder_d7(PC),session_saved7


	;------------------------------------------------
	; If fatal error has been intercepted it will
	; come back here
	; It is also the default clean up code while exiting
	;------------------------------------------------
CatchError:
	bsr	DeleteUnarchivedPlugins	;delete unarchived plugins

	;-----------------------------------
	; If link mode, delete virtual folder
	; list
	;-----------------------------------
	btst.b	#2,S_MODE(a6)
	beq.s	\nolink
	move.w	folder_hdl(PC),d0
	bsr	DeleteLinkDir
	clr.w	folder_hdl
	bra.s	\skip

\nolink	bsr     Free_ListBuf

	;-----------------------------------
	; Free folder list of tree style mode
	;-----------------------------------
\skip	move.w	folder_hdl(PC),-(a7)
	beq.s	\nodel
	bsr	_HeapFree
\nodel	addq.l	#2,a7
	clr.w	folder_hdl

	;------------------------------------------------
	; Save data for next session
	;------------------------------------------------
	clr.w	NormalExit		;Clear flag to track crashes
	bsr	CFG_SaveData

	;------------------------------------------------
	; Free plugins libraries
	;------------------------------------------------
	bsr	freePluginsLibraries

STOP_TRYING_NICE_EXIT:
	;------------------------------------------------
	; Delete stack frame of plugins table
	;------------------------------------------------
	adda.w  #512,a7                 ;delete the stack frame

	;------------------------------------------------
	; Restore key delays
	;------------------------------------------------
;#ifdef TIPLUS
	TIOS_CALL OSInitKeyInitDelay
	addq.l	#2,a7
	TIOS_CALL OSInitBetweenKeyDelay
	addq.l	#2,a7
;#endif

	TIOS_CALL	OSLinkReset
END:

;#ifdef TIPLUS
;#else
	move.l  (a7)+,a0
	move.w  (a7)+,(a0)
;#endif

	move.w  #$01,-(a7)
	TIOS_CALL ST_busy
	addq.l  #2,a7


;#ifdef NSTUB
	bsr	nostub_ExitPct
;#endif

PCTOOLS_RTS:
	rts



up      bsr     PadUP
	bra.s   goloop1
down    bsr     PadDOWN
goloop1 bra     Loop


MemoryCatcher:
	clr.w	d0		;interrupt ON if needed
	trap	#1
	move.l	save_a7(PC),a7
	lea	ieErrorCatcher(PC),a0
	bsr	InterfaceEngine
	bra	CatchError

;---------------------------------------------------------------
; Error Catcher
;Input>	a0.l : Special Message
;---------------------------------------------------------------
ErrorCatcher:
	move.l	a0,a2				;save a0=msg
	clr.w	d0				;interrupt ON if needed
	trap	#1
	move.l	save_a7(PC),a7

	tst.w	EC_NoLoop
	bne.s	STOP_TRYING_NICE_EXIT

	lea	ieEC_str(PC),a0			;Put message
	move.l	a2,(a0)
	lea	ieErrorCatcher2(PC),a0
	bsr	InterfaceEngine
	add.w	#1,EC_NoLoop			;Set that we tried to exit
	bra	CatchError

EC_d6null:
	lea	ieEC_Sd6(PC),a0
	bra.s	ErrorCatcher

EC_d6toobig:
	lea	ieEC_d6toobig(PC),a0
	bra.s	ErrorCatcher

EC_Unknown:
	lea	ieEC_SUnknown(PC),a0
	bra.s	ErrorCatcher

EC_Align:
	lea	ieEC_SAlign(PC),a0		;error message
	bra	ErrorCatcher

EC_NoLoop:	dc.w	0			;used to avoid infinite message


;------------------------------------------------
; Draw the About Window
;------------------------------------------------
AboutWin:
	lea     winAbout(PC),a0
	bsr	InterfaceEngine
	lea     winLicense(PC),a0
	bsr	InterfaceEngine

	bra     LoopRDListArea


	




