;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.10
; FILE DESCRIPTION      : Compression Plugin
;=====================================================================

	include "tios.h"                ;library includes files
	include	"APILib.h"
	include "APILibCT.h"
	include "ziplib.h"

	xdef    _main                   ;normal assembly program
	xdef    _comment


;#ifdef TI89
OX	equ	-40
OY	equ	-10
	xdef	_ti89
;#else
OX	equ	0
OY	equ	0

	xdef	_ti92plus
;#endif

;#ifdef TIPLUS
FOLDERLIST_HDL  equ     tios::FolderListHandle
;#else
FOLDERLIST_HDL  equ     $0B
;#endif

	include "pctplug.h"             ;and after we include pctplug.h

;--------------------------------------------------------------------
; Header of PCTOOLS 98 plugin
;--------------------------------------------------------------------

	PRG_AS_PLUGIN

EXTENSION_FILTER:
	dc.b	1,EXT_ZIP
	ds.w	0

PLUGIN_TABLE:
	dc.l	NOT_USED		;start_of_pct98
	dc.l	NOT_USED		;end_of_pct98
	dc.l	KeyPressed		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	NOT_USED		;enter_pressed
	dc.l	CursorMoved		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	MenuString		;menu_string
	dc.l	MenuFunction		;menu_function
	dc.l	CompressionService	;compression_service
	dc.l	HideMenu		;use_menu


;--------------------------------------------------------------------
; Normal launch of the program
;--------------------------------------------------------------------
END_PLUGIN_TABLE:

StartPrgm:
	lea	ieAbout(PC),a0
	jsr	apilib::InterfaceEngine
	rts


;-----------------------------------------------------
; Plugin Function :	when the user select a
;			a PIC file in PCT98
;
; thanks to special extension, we are sure that
; the selected file is a ZIP file
;-----------------------------------------------------
CursorMoved:
	suba.w	#64,a7
	move.l	a7,a2			;create stack frame

	move.w	$10(a0),d0		;Handle of selected file
	beq.s	\exit
	jsr	apilib::DEREFd0a0	;Get address of selected file

	move.w	(a0),d2			;zipped size
	addq.l	#2,d2			;real zipped size
	mulu.w	#100,d2			;*100
	move.w	12(a0),d3		;unzipped size
	addq.l	#2,d3
	divu.w	d3,d2			;never divide by zero
	move.w	#100,d0
	sub.w	d2,d0

	move.w	d0,-(a7)		;ratio
	move.w	d3,-(a7)		;initial size
	pea	szInfo(PC)
	move.l	a2,-(a7)
	jsr	tios::sprintf
	lea	12(a7),a7

	move.l  a2,-(a7)
	jsr	tios::ST_helpMsg
	addq.l  #4,a7

\exit	adda.w	#64,a7
	rtplugin SKIP_NEXTPLUGINS+SKIP_PCTPROCESS


;----------------------------------------------------
;input>	d0.w:hdl
;out>	d1.w = 0 if not, else yes
;----------------------------------------------------
IsFolder:
	movem.l	d0/d2/a0-a1,-(a7)
	move.w	d0,d1
	move.w	#FOLDERLIST_HDL,d0
	jsr	apilib::vat_FindHdl
	move.w	d2,d1
	movem.l	(a7)+,d0/d2/a0-a1
	rts


CompressionService:
	move.l	a0,a4
	move.w	2(a4),d0		;service

	cmp.w	#0,d0
	beq	compress
	cmp.w	#1,d0
	beq	extract
	cmp.w	#2,d0
	beq	needtmpextract
	cmp.w	#3,d0
	beq	tmpextract
	clr.l	d0

exit	move.w	d0,-(a7)		;rtplugin
	bra	PLGRt

;-----------------------------------------------------
; Plugin Function :	called to see if it shows
;			the menu or not
;-----------------------------------------------------
HideMenu:
	move.l	$8(a0),a1		;addr of STYLE
	btst.b	#0,(a1)			;
	beq.s	\nomenu			;if no true VAT

	move.w	$0E(a0),d0		;Handle of list
	beq.s	\nomenu
	jsr	apilib::vat_CountSelection
	tst.w	d0
	beq.s	\noslct
	lea	mnu_s3(PC),a0		;selection
	bra.s	\skip

\noslct	move.w	$10(a0),d0
	beq.s	\nomenu
	bsr	IsFolder		;if it a folder?
	tst.w	d1			;and no selection
	bne.s	\nomenu			;skip
	jsr	apilib::DEREFd0a0
	jsr	apilib::vat_GetFileExt

	lea	mnu_s1(PC),a0
	cmp.w	#EXT_ZIP,d2
	beq.s	\skip
	lea	mnu_s2(PC),a0

\skip	lea	MenuString(PC),a1
\copy	move.b	(a0)+,(a1)+		;copy string
	bne.s	\copy
\copy2	move.b	(a0)+,(a1)+		;copy short cut
	bne.s	\copy2


\exit	rtplugin SKIP_NEXTPLUGINS
\nomenu	rtplugin SKIP_NEXTPLUGINS+SKIP_PCTPROCESS


;----------------------------------------------------
; Key pressed
;----------------------------------------------------
KeyPressed:
	move.l	$8(a0),a1		;addr of STYLE
	btst.b	#0,(a1)			;
	beq.s	exit			;if no true VAT

	cmp.w	#275,2(a0)		;Test if [F8]
	beq.s	MenuFunction		;
	bra.s	exit

;----------------------------------------------------
; Service : NeedTmpExtract
; currently, always YES
;----------------------------------------------------
needtmpextract
	moveq.w	#SKIP_PCTPROCESS+SKIP_NEXTPLUGINS,d0	;yes, need
	bra.s	exit

;----------------------------------------------------
; Service : Extract or Compress
;----------------------------------------------------
MenuFunction:
	move.l	a0,a4
extract:
compress:
	;-----------------------------------
	; Selection or not ?
	;-----------------------------------
	move.w	$0E(a4),d0		;Handle of real list
	jsr	apilib::vat_CountSelection
	tst.w	d0
	beq.s	\noslct


	;-----------------------------------
	; If selection, use a loop
	;-----------------------------------
	move.w	$0E(a4),-(a7)		;handle
	jsr	tios::HeapLock		;Lock VAT

	move.w	(a7),d0			;Get VAT addr
	jsr	apilib::DEREFd0a0
	addq.l	#2,a0
	move.w	(a0)+,d3		;nbfiles
	beq.s	\eol
	subq.w	#1,d3

\loop	btst.b	#VAT_SELECTBIT,VAT_ENTRYFLAG(a0)
	beq.s	\skip
	bclr.b	#VAT_SELECTBIT,VAT_ENTRYFLAG(a0)
	moveq.w	#1,d0			;enable commentary
	jsr	ziplib::zipfile
	tst.b	d0
	beq.s	\skip
	bset.b	#VAT_SELECTBIT,VAT_ENTRYFLAG(a0)
	bra.s	\eol
\skip	lea	VAT_ENTRYSIZE(a0),a0
	dbra.s	d3,\loop

\eol	jsr	tios::HeapUnlock
	addq.l	#2,a7
	bra.s	\err1

	;-----------------------------------
	; If no selection, just process
	; on selected file
	;-----------------------------------
\noslct	move.w	$10(a4),d1		;Handle of selected item
	beq.s	\err1
	move.w	$0E(a4),d0		;Handle of real list
	jsr	apilib::vat_FindHdl
	tst.w	d2
	beq.s	\err1
	move.l	a1,a0			;addr of VAT
	moveq.w	#2,d0			;enable commentary
	jsr	ziplib::zipfile
\err1	moveq.w	#SKIP_NEXTPLUGINS+REDRAW_LIST+REFRESH_PLUGIN_TABLE,d0
	bra	exit

;----------------------------------------------------
; Service : Temporary Extract
;----------------------------------------------------
tmpextract
	move.w	$10(a4),d1		;Handle of selected item
	beq.s	\err2
	move.w	$0E(a4),d0		;Handle of real list
	jsr	apilib::vat_FindHdl
	clr.l	d1			;default value
	tst.w	d2			;if not found, exit
	beq.s	\err2
	move.l	a1,a0			;addr of VAT
	moveq.w	#1,d0			;enable commentary
	jsr	ziplib::tempfile
\err2	moveq.w	#SKIP_NEXTPLUGINS,d0
	move.w	d1,2(a4)
	bra	exit

;====================================================================
; Plugin Data
;====================================================================

ieAbout:	dc.b		IE_ANIMEDWIN2,50,50+OX,40+OY,189+OX,80+OY,"PctZIP Plugin",0
		dc.b		IE_SETFONT,1
		dc.b		IE_STRING,58+OX,53+OY,"PctZIP Plugin",0
		dc.b		IE_SETFONT,0
		dc.b		IE_STRING,58+OX,66+OY,"for Pctools, release 1.0.3",0
		dc.b		IE_STRING,58+OX,72+OY,"Ibrahim/Benoit Scherrer",0
		dc.b		IE_SOLIDRECT,58+OX,62+OY,178+OX,63+OY
		dc.b		IE_WAITKEY
		dc.b		IE_END


MenuString: 
	dc.b 	"                                 ",0

mnu_s1:	dc.b	"Extract File",0,"F8",0
mnu_s2:	dc.b	"Compress File",0,"F8",0
mnu_s3:	dc.b	"Zip/Unzip selection",0,"F8",0

szInfo	dc.b	"initial size:%db   >ratio:%d%%",0


_comment
	dc.b    "PctZIP Plugin",0

	end

