;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		apicall.mdl
;	Utility>	Api92 Call for size optimization
;			(avoid too much relocation)
;
;-----------------------------------------------------------

InterfaceEngine:	jmp	apilib::InterfaceEngine
GetFileExt:		jmp     apilib::vat_GetFileExt
vat_CountSelection	jmp	apilib::vat_CountSelection

_HeapFree:		TIOS_JMP HeapFree
_sprintf:		TIOS_JMP sprintf


;-----------------------------------------------------------
;Encapsulate the api92::vat_GetFileExt function to support
;ZIP files
;
;Input>	a0.l : addr of the beginning of the file
;Out>	d2.w : File Type
;	d1.w : 	VAT_NOTZIPPED (=0) if not zipped
;	 	VAT_ZIPPED (=1) if zipped
;-----------------------------------------------------------
GetFileExt_z:
	bsr     GetFileExt			;Get file extension
	moveq.w	#VAT_NOTZIPPED,d1
	cmp.w   #EXT_ZIP,d2
	bne.s   \no_zip

	move.l	a1,-(a7)			;save a1
	clr.l	d2
	move.b	2(a0),d2			;Get file type
	lea	table_ConvFileLib(PC,d2.w),a1	;Use the conversion table
	move.b	(a1),d2	
	move.l	(a7)+,a1
	moveq.w	#VAT_ZIPPED,d1

\no_zip	rts


;-----------------------------------------------------------
; Conversion table to support ZIP format of Doors
;-----------------------------------------------------------
table_ConvFileLib:
	dc.b	EXT_EXE,EXT_LIB,EXT_PRGM,EXT_FUNC
	dc.b	EXT_MAT,EXT_LIST,EXT_MACR,EXT_TEXT,EXT_STR
	dc.b	EXT_DATA,EXT_FIG,EXT_PIC,EXT_GDB,EXT_EXPR
	dc.b	EXT_OTHER
	ds.w	0

