;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		password.xas
;	Utility>	Password Management
;
;-----------------------------------------------------------


;-----------------------------------------------------------
; Function called to set the supervisor password
;-----------------------------------------------------------
SetPasswordWin:
	movem.l	d0-d2/a0-a2,-(a7)

	suba.w	#40,a7
	move.l	a7,a1			;create stack frame

	;-------------------------------------------
	; Check if a password has been definited
	;-------------------------------------------

	lea	PassStr1(PC),a0		;string to show
	lea	strPassword(PC),a2	;addr of current password
	tst.b	(a2)			;check if a password is
	beq.s	\nopass			;definited

	;-------------------------------------------
	; If a password exists, first ask it
	;-------------------------------------------

	bsr	_CheckPassword
	tst.w	d0
	beq.s	\exit

	;-------------------------------------------
	; Ask a new password and put it in a buffer
	;-------------------------------------------

\nopass	lea	20(a7),a1		;other buffer
	lea	PassStr2(PC),a0		;string to show
	bsr	_passWin		;ask new password
	tst.w	d0			;if esc/cancel
	beq.s	\exit

	;-------------------------------------------
	; Now ask the password for a check
	;-------------------------------------------

	move.l	a1,a2			;password
	move.l	a7,a1			;buffer
	lea	PassStr3(PC),a0		;string to show
	bsr	_CheckPassword
	tst.w	d0
	beq.s	\result

	;-------------------------------------------
	; if successful, copy new password
	;-------------------------------------------

	lea	strPassword(PC),a0
	move.l	(a1)+,(a0)+
	move.l	(a1)+,(a0)+
	move.w	(a1)+,(a0)+

\result	bsr	passResultWin
\exit 	adda.w	#40,a7
	movem.l	(a7)+,d0-d2/a0-a2
	rts


;------------------------------------------------------
;Input>	a0.l : string to show
;	a1.l : addr of buffer
;Out>	d0.w = 0 if cancel/error
;------------------------------------------------------
_passWin:
	move.l	a0,winPassStr
	lea	winPassword(PC),a0
	bsr	InterfaceEngine

	lea	passEdit(PC),a0		;struct
	jsr	apilib::EditComponent	;a1 set
	rts

;------------------------------------------------------
; Show password window, ask for a password and returns
; if it is valid or not
;
;Input>	a0.l : string to show
;	a1.l : addr of buffer
;	a2.l : addr of orignal password
;Out>	d0.w = 0 if cancel/error
;------------------------------------------------------
_CheckPassword:
	movem.l	d1-d4/a0-a2,-(a7)

	;-------------------------------------------
	; Wait for the user to enter the password
	;-------------------------------------------

	bsr	_passWin		;Show password window
	tst.w	d0
	beq.s	\exit

	;-------------------------------------------
	; Check if it is valid
	;-------------------------------------------

	clr.w   d0			;return value
\check  cmp.b   (a1)+,(a2)+		;cmp 
	bne.s   \exit			;if invalid
	tst.b   (a1)
	bne.s   \check
	tst.b   (a2)
	bne.s   \check  
	moveq.w #1,d0   

\exit	movem.l	(a7)+,d1-d4/a0-a2
	rts


passEdit:
	dc.w	80+XO,57+YO		;X,Y
	dc.w	10			;MaxLength
	dc.b	'*'			;Mask
	dc.b	0			;Flag
	dc.l	0			;api92CB_edKeyDown
	dc.l	0			;api92CB_edKeyUp

;-----------------------------------------------------------
; Ask the password, and check if it is valid
; Out>	d0.w = 0 if cancel/error
;-----------------------------------------------------------
AskPasswordWin:
	movem.l	d1-d2/a0-a2,-(a7)

;#ifdef TIPLUS
	lea	$40078,a0
	move.l	(a0),-(a7)
	lea	interrupt_ON(PC),a1
	move.l	a1,(a0)
;#endif

	suba.w	#20,a7
	move.l	a7,a1			;buffer
	lea	PassStr4(PC),a0		;String
	lea	strPassword(PC),a2	;password

	tst.b	(a2)			;Check if a password is
	bne.s	\ok			;definited
	lea	winNoPass(PC),a0
	bsr	InterfaceEngine
	moveq.w	#1,d0			;no error
	bra.s	\exit

\ok	bsr	_CheckPassword

\exit	adda.w	#20,a7

;#ifdef TIPLUS
	lea	$40078,a0
	move.l	(a7)+,(a0)
;#endif
	movem.l	(a7)+,d1-d2/a0-a2
	rts


interrupt_ON:
	nop
	rte

;----------------------------------------------------
;Input>	d0=0 :failed
;	else ok
;----------------------------------------------------
passResultWin:
	move.l	a0,-(a7)

	lea	PassStr5(PC),a0
	tst.w	d0
	beq.s	\failed
	lea	PassStr6(PC),a0
\failed	move.l	a0,winPRStr

	lea	winPassResult(PC),a0
	bsr	InterfaceEngine

	move.l	(a7)+,a0
	rts



	ds.w	0

