;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		style1.xas
;	Utility>	Routines for style1 show
;
;-----------------------------------------------------------

Style1:
	dc.b	%00000001,0
	dc.l	sg1_MakeList
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	s1_DrawItem
	dc.l	sg1_DrawFirstItem
	dc.l	s1_PadDown
	dc.l	s1_PadUp
	dc.l	s1_SelectItem
	dc.l	s1_ClearList
	dc.l	s1_DeleteItem
	dc.l	sg1_ShowComment
	dc.l	sg1_KeyEnter
	dc.l	sg1_EnableMenus
	dc.l	s1_DrawInterface
	dc.l	s1_InitStyle
	dc.l	sg1_GetItemXY
	dc.l	sg1_PadLeft
	dc.l	sg1_PadRight
	dc.l	sg2_OtherKey
	dc.l	s1_BeforeDrawingList
	dc.l	RedrawList		;RedrawListArea
	dc.l	sg1_RefreshUpBar

;tmp
s1_PrintList
s2_PrintList
s1_RedrawList
s2_RedrawList
s1_Rd_WML
s2_Rd_WML
	bra	EC_Unknown

;-----------------------------------------------------------
;	Style1 Datas
;-----------------------------------------------------------
s1_Interface:
	dc.b	IE_SOLIDRECT,0,11,239+LW,121+LH		;NEW
	dc.b	IE_SOLIDRECT,2,21,82,119+LH
rpanel:	dc.b	IE_SOLIDRECT,84,21,237+LW,119+LH
	dc.b	IE_END

	ds.w	0

;-----------------------------------------------------------
; Pad Down routine for style 1
; It quickly scrolls the screen
;-----------------------------------------------------------
s1_PadDown:
;#ifdef NODBG
	move.w  #$500,d0
	trap    #1
;#endif
	move.l  d0,-(a7)
	
	move.w	NbItem(PC),d2
	tst.w	d2
	beq.s	\ex2

	bsr     SelectItem      ;Deselect the current item

	cmp.w   d2,d6       	;d2=NbItem
	bne.s	\nofirst
	clr.w	d6
	clr.w	d7
	bsr     RedrawList_WML
	bsr     ShowComment
	bra.s	\ex2

\nofirst addq.w  #1,d6           ;IPosScreen
	cmp.w   #NBVARPERPAGE-2,d7      ;Need scroll ?
	ble.s   \NoScroll       ;if no, jump

	move.l  #LCD_MEM+(LSTY*30),a0 ;Video Adress
	lea     240(a0),a1
	moveq.w #(8*(NBVARPERPAGE-1)),d3          ;88 lignes      
\SLine	moveq.w #6,d2           ;5 laps
\SCol	move.l  (a1)+,(a0)+     
	dbra.s  d2,\SCol
	move.w  (a1)+,(a0)+
	dbra.s  d3,\SLine

	bsr     DeleteItem
	bsr     GetCurrentVATAddr       
	move.l  a0,a2
	moveq.w	#8,d0					;X
	moveq.w #(LSTY+(8*(NBVARPERPAGE-1))),d1                 ;Y pos
	bsr	DrawItem       
	bra.s   \exit           ;Exit

\NoScroll addq.w  #1,d7		;increase IPosScreen
\exit   bsr     SelectItem      ;Select the item
	bsr	ShowComment
	bsr	DrawScrollBar
\ex2    move.l  (a7)+,d0
;#ifdef NODBG
	trap    #1
;#endif
	rts



;-----------------------------------------------------------
; Pad Down routine for style 1
; It quickly scrolls the screen
;-----------------------------------------------------------
s1_PadUp:
;#ifdef NODBG
	move.w  #$500,d0
	trap    #1
;#endif
	move.l  d0,-(a7)

	move.w	NbItem(PC),d2
	tst.w	d2
	beq.s	\ex2

	tst.w   d6
	bne.s	\nolast
	move.w	d2,d6			;d2=NbItem
	move.w	#NBVARPERPAGE-1,d7
	cmp.w	d7,d6
	bhi.s	\ssk
	move.w	d6,d7
\ssk	bsr     RedrawList_WML
	bsr     ShowComment
	bra.s	\ex2

\nolast	bsr     SelectItem      ;Deselect the current item
	subq.w  #1,d6           ;decrease CurrentItem
	tst.w   d7              ;need scroll ???
	bne.s   \NoScroll       ;if no, jump

	move.l  #LCD_MEM+((LSTY-1+8*(NBVARPERPAGE-1))*30),a0  ;Video Adress (3270)
	lea     240(a0),a1
	moveq.w #(8*(NBVARPERPAGE-1))-1,d3      ;87 lignes
\SLine	moveq.w #6,d2           ;7 laps (7*4 = 28 bytes)
\SCol	move.l  (a0)+,(a1)+     
	dbra.s  d2,\SCol
	move.w  (a0),(a1)
	lea     -58(a0),a0      ;suba   #58,a0
	lea     -58(a1),a1      ;suba   #58,a1
	dbra.s  d3,\SLine

	bsr     DeleteItem
	tst.w   d6
	bne.s   \nofirst
	bsr	DrawFirstItem
	bra.s   \exit

\nofirst bsr     GetCurrentVATAddr
	move.l  a0,a2
	moveq.w	#8,d0
	moveq.w #LSTY,d1
	bsr     DrawItem
	bra.s   \exit

\NoScroll subq.w  #1,d7
	
\exit   bsr     SelectItem
	bsr     ShowComment
	bsr	DrawScrollBar
\ex2    move.l  (a7)+,d0
;#ifdef NODBG
	trap    #1
;#endif
	rts

;--------------------------------------------------------
; Select the current item
;--------------------------------------------------------
s1_SelectItem:
	movem.l	d1/a0,-(a7)

	bsr.s   ItemScrPos
	moveq.w #7,d1           ; 8 lines

\line   not.b   (a0)+
	not.l   (a0)+
	not.l   (a0)+
	lea     21(a0),a0       ;adda.w #21,a0
	dbra.s  d1,\line

	movem.l	(a7)+,d1/a0
	rts

;--------------------------------------------------------
; Clear the list
;--------------------------------------------------------
s1_ClearList:
	movem.l a0/d0-d3/d7,-(a7)
	moveq.w #NBVARPERPAGE-1,d2
	clr.w   d7
\lp     bsr	DeleteItem
	addq.w  #1,d7
	dbra.s  d2,\lp
	movem.l (a7)+,a0/d0-d3/d7
	rts

;--------------------------------------------------------
; delete the item d7
;--------------------------------------------------------
s1_DeleteItem:
	movem.l	d0-d3/a0,-(a7)
	bsr.s   ItemScrPos
	subq.w	#1,a0

	moveq.w #7,d3           ;delete 8 lines
\line	move.b	#%10100000,(a0)
;#ifdef TI89
	moveq.w	#17,d1
;#else
	moveq.w #27,d1          ;and 8 cols
;#endif
	move.b	#%00000101,2(a0,d1.w)
\row	clr.b   1(a0,d1.w)
	cmp.w   #9,d1
	bne.s	\no
	move.b	#%00101000,1(a0,d1.w)
\no     dbra.s  d1,\row
	lea     30(a0),a0       ;adda.w #30,a0
	dbra.s  d3,\line
	movem.l	(a7)+,d0-d3/a0	
	rts

;---------------------------------------------------
;ItemScrPos
;return in a0 the offset of the d7 item in
;the video memory
;Ouput>
;--------------------------------------------------
ItemScrPos:
	move.w  d7,d0
	lsl.w   #3,d0
	add.w   #LSTY,d0
	mulu.w  #30,d0
	
	move.l  #LCD_MEM+1,a0
	adda.w  d0,a0
	rts

;--------------------------------------------------
; Draw the scroll bar
;--------------------------------------------------
DrawScrollBar:
;	lea	ScrollBarHeader(PC),a0
;	move.w	d6,(a0)
;	move.w	NbItem(PC),8(a0)
;	jsr	apilib::VScrollComponent
	rts

;ScrollBarHeader:
;	dc.w	0		;Current value
;	dc.w	WLCD-8		;X
;	dc.w	21		;Y
;	dc.w	HLCD-32		;Height
;	dc.w	0		;MaxValue
;	dc.w	5		;Height of bar

s1_BeforeDrawingList:
	;----------------------------
	; Make d6/d7 valid and set d5
	;----------------------------
	cmp.w   d2,d6           	;if (unsigned) d6<=d2
	bls.s   \skip1			; skip
	move.w  d2,d6
	moveq.w #NBVARPERPAGE-1,d7

\skip1	moveq.w	#NBVARPERPAGE,d5
	cmp.w	d5,d2			;if (unsigned) d2>=NBVARPERPAGE
	bcc.s   \skip2			; skip
	move.w  d6,d7

\skip2	rts



;-------------------------------------------------
; Print an item
;input> a2 : addr in the VAT
;       d1 : Y pos
;out>   d2 : image index
;-------------------------------------------------

s1_DrawItem:
	movem.l d0-d5/a0-a4,-(a7)

	;-------------------------------------------
	; Show File Name
	;-------------------------------------------
	bsr     CpyFileName     ;return a2 in a1 with 8 char+0
	moveq.w #24,d0          ;X pos
	bsr     PrintSp         ;a1&d1 already set


;#ifdef TI89
	moveq.w #0,d0
	jsr     apilib::SetFont
	addq.l  #2,d1
;#endif

	;-------------------------------------------
	; Show attributes (according to flags)
	;-------------------------------------------
	
	clr.w	d0			;default offset
	bsr	sg1_DrawVATFlags

	;-------------------------------------------
	; Selection attribute
	;-------------------------------------------
	btst.b  #SLCT_BIT,ENTRYFLG+1(a2)
	beq.s   \noslct
	moveq.w #15,d2          ;char=selected
	moveq.w #8,d0           ;X pos. Y already set
	bsr     printchar


	;-------------------------------------------
	; Show other information
	;-------------------------------------------

\noslct	move.w  ENTRYHDL(a2),d0		;File Handle
	bsr     DEREFd0a0		;File Address

	btst.b  #7,ENTRYFLG+1(a2)
	bne.s   \folder

	;-------------------------------------------
	; Here we have a file
	;-------------------------------------------
	clr.w	d0
	bsr	sg1_DrawFileInformation		;return d2=ExtID

	;-------------------------------------------
	; Show file associated picture
	;-------------------------------------------
	jsr     apilib::vat_ExtID_Picture ;d2 is set, return a0
	moveq.w #2,d0           	;col (x=16) 
;#ifdef TI89
	subq.w  #2,d1
;#endif
	bsr     PutImgAddr		;put picture giving its address  
	bra.s   \exit


	;-------------------------------------------
	; Here we have a folder
	;-------------------------------------------
\folder	jsr     apilib::nf_GetNestedCount ;Get nb of nested folders (in d2)
	add.w   2(a0),d2		;add nb of files

	moveq.w #FOLD_GFX,d3
;	btst.b  #PRT_BIT,ENTRYFLG(a2)   ;protected ?
;	beq.s   \notprt
;	moveq.w #PSW_GFX,d3
;	subq.w  #1,d2
\notprt	moveq.w	#XINFO_SIZE,d0		;X for PrintNumber
	bsr     PrintNumber

;#ifdef TI89
	subq.w  #2,d1
;#endif
	exg.l   d3,d2
	moveq.w #2,d0			;col (x=16)
	bsr     PutImg			;draw picture

\exit   
;#ifdef TI89
	moveq.w #1,d1
	bsr     FontSet
;#endif

	movem.l (a7)+,d0-d5/a0-a4
	rts

;----------------------------------------------------------
; Draw the 2 rectangles of the style1 interface 
;----------------------------------------------------------
s1_DrawInterface:
	move.l	a0,-(a7)
	lea	s1_Interface(PC),a0
	bsr	InterfaceEngine
	move.l	(a7)+,a0
	rts


;----------------------------------------------------------
;
;----------------------------------------------------------
s1_InitStyle:
	clr.w	d6
	clr.w	d7
	bsr	StyleInterface
	rts

s1_ClearRightPanel:
	lea	rpanel(PC),a0
	bsr	InterfaceEngine
	rts

