;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		style2.xas
;	Utility>	Routines for style2 show
;
;-----------------------------------------------------------

Style2:
	dc.b	%00000001,0
	dc.l	sg1_MakeList
	dc.l	0
	dc.l	0
	dc.l	0
	dc.l	s2_DrawItem
	dc.l	sg1_DrawFirstItem
	dc.l	s2_PadDown
	dc.l	s2_PadUp
	dc.l	s2_SelectItem
	dc.l	s2_ClearList
	dc.l	s2_DeleteItem
	dc.l	sg1_ShowComment
	dc.l	sg1_KeyEnter
	dc.l	sg1_EnableMenus
	dc.l	s2_DrawInterface
	dc.l	s2_InitStyle
	dc.l	s2_GetItemXY
	dc.l	s2_PadLeft
	dc.l	s2_PadRight
	dc.l	s2_OtherKey
	dc.l	s2_BeforeDrawingList
	dc.l	RedrawList		;RedrawListArea
	dc.l	sg1_RefreshUpBar

;-----------------------------------------------------------
;	Style2 Datas
;-----------------------------------------------------------
s2_Interface:
	dc.b	IE_SOLIDRECT,2,21,237+LW,119+LH
	dc.b	IE_END
	ds.w	0


;-----------------------------------------------------------
; 
;-----------------------------------------------------------
s2_BeforeDrawingList:
	;---------------------------
	; Make d6/d7 valid
	;---------------------------
	cmp.w	#NBCOLUMN*NBVARPERPAGE-1,d7 ;d7<=
	bhi.s	\modif
	cmp.w   d2,d6           	;if (unsigned) d6<=d2
	bls.s   \skip1			; skip
\modif	move.w  d2,d6
	clr.l	d0			;for divu.W
	move.w	d2,d0			;nb items
	divu.w	#NBVARPERPAGE,d0	;nb of column at max
	move.w	d0,d7
	cmp.w	#NBCOLUMN-1,d7		;
	ble.s	\skip
	moveq.w	#NBCOLUMN-1,d7
\skip	swap.l	d0			;get offset in column
	mulu.w	#NBVARPERPAGE,d7
	add.w	d0,d7

\skip1	;-------------------------------------------
	; Nb Var Per Page
	;-------------------------------------------
	moveq.w	#NBCOLUMN*NBVARPERPAGE,d5
	rts


;-----------------------------------------------------------
; Draw an item
;-----------------------------------------------------------
s2_DrawItem:
	movem.l	d0-d4/a0-a2,-(a7)

	;-------------------------------------------
	; Draw select char
	;-------------------------------------------
	btst.b  #SLCT_BIT,ENTRYFLG+1(a2)
	beq.s   \noslct
	moveq.w #15,d2          ;char=selected
	bsr     printchar

\noslct	;-------------------------------------------
	; Draw file name
	;-------------------------------------------
	move.w	d0,d3			;Save X
	add.w	#16,d0			;
	bsr     CpyFileName		;return a2 in a1 with 8 char+0
	bsr     PrintSp			;a1&d1 already set


	;-------------------------------------------
	; Draw icon
	;-------------------------------------------
	move.w  ENTRYHDL(a2),d0		;File Handle
	bsr     DEREFd0a0		;File Address
	btst.b  #7,ENTRYFLG+1(a2)
	bne.s   \folder

	move.l	d1,-(a7)		;Save d1 modified by GetFileExt_z
	bsr     GetFileExt_z		;Get file extension
	move.l	(a7)+,d1		;Restore d1=Y
	jsr     apilib::vat_ExtID_Picture ;return a0
	bra.s	\drawicon

\folder	lea	dirgfx(PC),a0
\drawicon move.w	d3,d0
	addq.w	#8,d0
	jsr	apilib::draw_GFX8x8

\exit	movem.l	(a7)+,d0-d4/a0-a2
	rts

;-----------------------------------------------------------
; Pad down
;-----------------------------------------------------------
s2_PadDown:
	INTERRUPT_OFF

	bsr     SelectItem		;Deselect the current item

	cmp.w   NbItem(PC),d6		;Check if end of list
	bne.s	\nofirst
	clr.w	d6
	clr.w	d7
	bra.s	\dlist

\nofirst addq.w  #1,d6           	;IPosScreen
	cmp.w   #NBCOLUMN*NBVARPERPAGE-2,d7 ;Need scroll ?
	ble.s   \NoScroll       	;if no, jump
	sub.w	#NBVARPERPAGE-1,d7
\dlist 	bsr     RedrawList_WML
	bra.s   \ex2			;Exit

\NoScroll addq.w  #1,d7			;increase IPosScreen
	
\exit   bsr     SelectItem		;Select the item
	bsr	ShowComment
\ex2	INTERRUPT_ON
	rts

;-----------------------------------------------------------
; Pad up
;-----------------------------------------------------------
s2_PadUp:
	INTERRUPT_OFF

	tst.w   d6
	bne.s	\nolast
	move.w	NbItem(PC),d6
	clr.l	d0
	move.w	d6,d0
	divu.w	#NBVARPERPAGE,d0
	swap.l	d0
	move.w	#((NBCOLUMN-1)*NBVARPERPAGE),d7
	add.w	d0,d7

	cmp.w	d7,d6
	bhi.s	\ssk
	move.w	d6,d7
\ssk	bra.s	\dlist

\nolast	bsr     SelectItem		;Deselect the current item
	subq.w  #1,d6			;decrease CurrentItem
	tst.w   d7			;need scroll ???
	bne.s   \NoScroll		;if no, jump

	add.w	#NBVARPERPAGE-1,d7
\dlist 	bsr     RedrawList_WML
	bra.s   \ex2			;Exit
	

\NoScroll subq.w  #1,d7

\exit   bsr     SelectItem
	bsr     ShowComment
\ex2	INTERRUPT_ON
	rts

;-----------------------------------------------------------
; Select the current item
;-----------------------------------------------------------
s2_SelectItem:
	movem.l	d0-d1/a0-a1,-(a7)

	bsr	GetItemXY

	mulu.w	#30,d1
	move.l	#LCD_MEM,a0
	adda.w	d1,a0
	lsr.w	#3,d0
	adda.w	d0,a0

	moveq.w	#7,d0			;y loop counter
\ly	moveq.w	#8,d1			;x loop counter
\lx	not.b	(a0)+
	dbra.s	d1,\lx
	lea	30-9(a0),a0
	dbra.s	d0,\ly

	movem.l	(a7)+,d0-d1/a0-a1
	rts

;-----------------------------------------------------------
; Clear the entire list
;-----------------------------------------------------------
s2_ClearList:
	bsr	StyleInterface
	rts

;----------------------------------------------------------
; Delete current selected item
;----------------------------------------------------------
;#ifdef TI89
s2di	equ	0
;#else
s2di	equ	1
;#endif

s2_DeleteItem:
	movem.l	d0-d2/a0,-(a7)

	bsr	GetItemXY

	mulu.w	#30,d1
	move.l	#LCD_MEM,a0
	adda.w	d1,a0
	lsr.w	#3,d0
	adda.w	d0,a0

	moveq.w	#7,d1			;y loop counter
\ly	moveq.w	#8,d2			;x loop counter
	cmp.w	#1,d0
	bne.s	\lx
	move.b	#%10100000,-1(a0)
\lx	clr.b	(a0)+
	dbra.s	d2,\lx
	cmp.w	#(8+COLUMNWIDTH*(NBCOLUMN-1))/8,d0
	bne.s	\skip1
	move.b	#%00000101,s2di(a0)
\skip1	lea	30-9(a0),a0
	dbra.s	d1,\ly

	movem.l	(a7)+,d0-d2/a0
	rts


;----------------------------------------------------------
; Get the pos of current item
;Input>	d7.w : 
;Out>	d0.w : X
;	d1.w : Y
;----------------------------------------------------------
s2_GetItemXY:
	move.l	d2,-(a7)

	clr.l	d0
	move.w	d7,d0
	divu.w	#NBVARPERPAGE,d0	;Column
	move.w	d0,d2
	mulu.w	#COLUMNWIDTH,d0		;width of an item
	add.w	#8,d0

	mulu.w	#NBVARPERPAGE,d2
	move.w	d7,d1
	sub.w	d2,d1
	lsl.w	#3,d1			;d1*8
	add.w	#LSTY,d1

	move.l	(a7)+,d2
	rts

;----------------------------------------------------------
; DrawInterface
;----------------------------------------------------------
s2_DrawInterface:
	lea	s2_Interface(PC),a0
	bsr	InterfaceEngine
	rts

;-------------------------------------------------------
;	- Style Function -
;
; Enter in that new style
;-------------------------------------------------------
s2_InitStyle:
	clr.w	d6
	clr.w	d7
	bsr	StyleInterface
	rts

;-------------------------------------------------------
; Function called when the user press Pad Left
;-------------------------------------------------------
s2_PadLeft:
	moveq.w	#NBVARPERPAGE,d0	;d0 is the value to sub
	cmp.w	d0,d6			;if 
	bcs.s	\back			;d6<NBVARPARPAGE skip
	sub.w	d0,d6

	clr.l	d1
	move.w	d7,d1
	divu.w	d0,d1
	tst.w	d1
	beq.s	\rdraw
	sub.w	d0,d7
\rdraw	bsr     RedrawList_WML
\skip	bra	Loop

\back	clr.w	d6
	bra	KeyEnter

;-------------------------------------------------------
; Function called when the user press Pad Right
;-------------------------------------------------------
s2_PadRight:
	tst.w	d6
	beq.s	\file

	bsr	GetCurrentVATAddr
	btst.b	#VAT_FOLDERBIT,VAT_ENTRYFLAG(a0)
	beq.s	\file
	bra	KeyEnter

\file	INTERRUPT_OFF
	clr.l	d0
	clr.l	d1
	move.w	NbItem(PC),d0
	divu.w	#NBVARPERPAGE,d0	;last column
	move.w	d6,d1
	divu.w	#NBVARPERPAGE,d1	;current column
	cmp.w	d1,d0
	beq.s	\exit

	swap.l	d0
	add.w	#NBVARPERPAGE,d6	;
	cmp.w	NbItem(PC),d6		;if d6>NbItem
	bhi.s	\rdraw			;let RedrawList clear it

	clr.l	d1
	move.w	d7,d1
	divu.w	#NBVARPERPAGE,d1
	cmp.w	#NBCOLUMN-1,d1
	beq.s	\rdraw
	add.w	#NBVARPERPAGE,d7
\rdraw	bsr     RedrawList_WML
\exit	INTERRUPT_ON
	bra	Loop


;---------------------------------------------------
; Key Handler
;---------------------------------------------------
s2_OtherKey:
	cmp.w   #PAD_UP+4096,d0
	beq     sg2_BigUp
	cmp.w   #PAD_DOWN+4096,d0
	beq     sg2_BigDown

;	cmp.w   #97,d0
;	bcs.s   \nolet
;	cmp.w   #122,d0
;	bls	s2_GoLetter

\nolet	bra	OK_Continue



;------------------------------------------------------
; Jump to a file
;------------------------------------------------------
s2_GoLetter:
	bsr	sg2_GoLetter		;common function
	tst.w	d2
	beq.s	\exit

	move.w  d4,d0           ;save d4
	sub.w   d6,d0           ;d4-d6->d0
	add.w   d0,d7

	cmp.w   #NBCOLUMN*NBVARPERPAGE-1,d7
	ble.s   \nosub          ;=< signed
	moveq.w	#NBCOLUMN-1,d1
	bsr	s2_Maked6d7Valid
	bra.s	\draw

\nosub	cmp.w   #0,d7
	bge.s   \nosub2         ;>= signed
	clr.w	d1
	bsr	s2_Maked6d7Valid
\nosub2

\draw	move.w  d4,d6
	bsr     RedrawList_WML
\exit   bra     Loop


;---------------------------------------------------
;Input>	d1.w : column to select (0,1 or 2)
;---------------------------------------------------
s2_Maked6d7Valid:
	movem.l	d0/d2,-(a7)

	move.w	NbItem(PC),d2		;NbItem in d2
	cmp.w   d2,d6           	;if (unsigned) d6<=d2
	bls.s   \skip1			; skip
	move.w  d2,d6

\skip1	clr.l	d0			;for divu.W
	move.w	d6,d0			;nb items
	divu.w	#NBVARPERPAGE,d0	;nb of column at max
	move.w	d0,d7
	cmp.w	d1,d7		;
	ble.s	\skip2
	move.w	d1,d7
\skip2	swap.l	d0			;get offset in column
	mulu.w	#NBVARPERPAGE,d7
	add.w	d0,d7

	movem.l	(a7)+,d0/d2
	rts

