;-----------------------------------------------------------
; 
;	Xetrion Source Code
;
;	(c) NeXO Software, Benoit SCHERRER
;	e-mail : p.c.scherrer@wanadoo.fr
;
;
;	File>		nostub.mdl
;	Utility>	Nostub Definitions
;
;-----------------------------------------------------------

;#ifdef TIPLUS

;---------------------- NOSTUB DEFINITION ------------------
;#ifdef NSTUB
		include "os.h"

TIOS_CALL 	macro
 			move.l 	($C8),a1
 			add.l 	#\1*4,a1
 			move.l 	(a1),a1
 			jsr 	(a1)
 		endm

TIOS_JMP 	macro
 			move.l 	($C8),a1
 			add.l 	#\1*4,a1
 			move.l 	(a1),a1
 			jmp 	(a1)
 		endm

TIOS_ADDR	macro
			move.l	a4,save_a4
 			move.l 	($C8),a4
 			add.l 	#\1*4,a4
 			move.l 	(a4),\2
			move.l	save_a4(PC),a4
 		endm

TIOS_LEAADDR	macro	
			move.l	a4,save_a4
 			move.l 	($C8),a4
 			add.l 	#\1*4,a4
 			move.l 	(a4),\2
			move.l	save_a4(PC),a4
 		endm

API92_MAINHDL	macro
			move.w	MainHandle(PC),\1
		endm

API92_FOLDHDL	macro
			move.w	FolderListHandle(PC),\1
		endm

API92_CMPFOLDHDL macro
			cmp.w	FolderListHandle(PC),\1
		endm

API92_ROMVERSION macro
			move.w	ROM_VERSION,\1
		endm


save_a4:		dc.l	0

;#ifdef TI89
KEY_DIAMOND		equ	$4000
;#else
KEY_DIAMOND		equ	$2000
;#endif


;---------------------- KERNEL DEDINITION -----------------
;#else
		include	"tios.h"

TIOS_CALL 	macro
			jsr	tios::\1
 		endm

TIOS_JMP	macro
			jmp	tios::\1
 		endm

TIOS_ADDR	macro
			move.l	tios::\1,\2
		endm

TIOS_LEAADDR	macro
			lea	tios::\1,\2
		endm

API92_MAINHDL	macro
			move.w	#tios::MainHandle,\1
		endm

API92_FOLDHDL	macro
			move.w	#tios::FolderListHandle,\1
		endm

API92_CMPFOLDHDL macro
			cmp.w	#tios::FolderListHandle,\1
		endm


API92_ROMVERSION macro
			move.w	#ROM_VERSION,\1
		endm
;#endif




;#ifdef NSTUB

hdl_SaveScreen:	dc.w		0

;--------------------------------------------------------------
;Input>	/
;Out>	0 = error
;	else ok
;--------------------------------------------------------------
nostub_InitPct:
		movem.l		d1-d2/a0-a2,-(a7)

		jsr		nostub_InitApi92
		bsr		ac_InstallHandler

		;---------------------------------------------
		; Allocate mem & save previous screen
		;---------------------------------------------
		move.l		#$3840,-(a7)
		TIOS_CALL 	HeapAlloc
		addq.l		#4,a7
		tst.w		d0
		beq.s		\exit

		move.w		d0,hdl_SaveScreen
		bsr		DEREFd0a0
		move.l		a0,a1
		jsr		api92::ScreenToBuffer

\exit		movem.l		(a7)+,d1-d2/a0-a2
		rts





;--------------------------------------------------------------
;Input>	/
;Out>
;--------------------------------------------------------------
nostub_ExitPct:
		;---------------------------------------------
		; Free memory used to save previous screen
		;---------------------------------------------
		move.w		hdl_SaveScreen(PC),d0
		bsr		DEREFd0a0
		move.l		a0,a1
		jsr		api92::BufferToScreen

		pea		hdl_SaveScreen(PC)
		TIOS_CALL	HeapFreeIndir
		addq.l		#4,a7

		bsr		ac_UninstallHandler


		rts

;--------------------------------------------------------------
;Input>	/
;Out>
;--------------------------------------------------------------
kernel::exec:
		movem.l	d0-d2/a0-a2,-(a7)

		suba.w	#14,a7

		move.l	a7,a0
		move.w	4*6+4(a7),d0		;file handle
		jsr	api92::GetTIOSFileName

		move.l	a7,-(a7)
		tst.w	d0
		beq.s	\exit

		jsr	api92::RunProg

\exit		lea	4+14(a7),a7
		movem.l	(a7)+,d0-d2/a0-a2
		rts

;#endif

;#endif


