;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.20
; FILE DESCRIPTION      : include file
;=====================================================================


;---------------------------------------------------------------------
; CONSTANTS DECLARATION
;---------------------------------------------------------------------
NOT_USED        EQU     $0

;GENERAL RETURNS IN rg1
SKIP_PCTPROCESS EQU     1       ;bit 0=request to skip the pct process
REDRAW_SCREEN   EQU     2       ;bit 1=redraw all the screen
REDRAW_LIST     EQU     4       ;bit 2=redraw only the list
SKIP_NEXTPLUGINS EQU    8       ;bit 3=don't exec next plugins
REFRESH_PLUGIN_TABLE EQU 16

NB_PLUGINFCT    EQU     11

;---------------------------------------------------------------------
; Macro to insert in the beginning of a PCT98 plugin
;---------------------------------------------------------------------
PRG_AS_PLUGIN   MACRO
_main:
	bra.s   PLGJp

	dc.b    "PLUG"                  ;signatur
param_addr dc.l 0
vers:   dc.w    $0120                   ;Version
	dc.w    NB_PLUGINFCT            ;Nb of functions
	dc.l    PLUGIN_TABLE            ;Addr of table
	dc.l    EXTENSION_FILTER

PLGJp:  move.l  param_addr(PC),a0       ;
	move.l  a0,d1                   ;if a0=NULL
	beq.s   \nojump                 ; execute like a normal prog
	move.w  (a0)+,d0                ;Get zero based function ID
	addq.w  #2,a0                   ;skip RT1

	lsl.w   #2,d0                   ;FctID * 4
	lea     PLUGIN_TABLE(PC),a2
	move.l  0(a2,d0.w),a2           ;Address of function
	jmp     (a2)                    ;jump

\nojump bra.s   END_PLUGIN_TABLE        ;jump at the end of the table

PLGRt:  lea     param_addr(PC),a1
	move.l  (a1),a0
	clr.l   (a1)                    ;if exec plugin as normal prog
	addq.l  #2,a0                   ;skip function ID
	move.w  (a7)+,(a0)+             ;put RT1
	rts

		ENDM


;---------------------------------------------------------------------
; Macro to call to exit a PCT98 plugin function
;---------------------------------------------------------------------
rtplugin        MACRO
	move.w  #\1,-(a7)
	bra     PLGRt
		ENDM

rtpluginDx        MACRO
	move.w  \1,-(a7)
	bra     PLGRt
		ENDM