;=====================================================================
;                       PCTOOLS 98 PLUGINS SDK
;                (c) Benoit SCHERRER, NeXO Software
;
;---------------------------------------------------------------------
; PLUGINS SDK VERSION   : 1.20
; FILE DESCRIPTION      : Ultimate Search Program
;=====================================================================

	include	"tios.h"
	include	"APILib.h"
	include "APILibCT.h"


;#ifdef TIPLUS
;#ifdef TI89
	xdef	_ti89
OX	equ	-40
OY	equ	-5

;#else
	xdef	_ti92plus
;#endif
;#else
tios::FolderListHandle	equ	$0B
KEY_DIAMOND 		equ	8160
;#endif



;#ifdef TI89

KEY_SWAPMODE	equ	KEY_DIAMOND+'8'
KEY_MATCHCASE	equ	KEY_DIAMOND+')'

;#else

KEY_SWAPMODE	equ	KEY_DIAMOND+'H'
KEY_MATCHCASE	equ	KEY_DIAMOND+'C'
OX	equ	0
OY	equ	0

;#endif



	xdef	_main
	xdef	_comment

	include "pctplug.h"             ;and after we include pctplug.h

;--------------------------------------------------------------------
; Start of PCTOOLS 98 plugin
;--------------------------------------------------------------------

	PRG_AS_PLUGIN

EXTENSION_FILTER:
	dc.b	0
	ds.w	0

PLUGIN_TABLE:
	dc.l	NOT_USED		;start_of_pct98
	dc.l	NOT_USED		;end_of_pct98
	dc.l	KeyPressed		;key_pressed
	dc.l	NOT_USED		;key_pressed_first
	dc.l	NOT_USED		;enter_pressed
	dc.l	NOT_USED		;cursor_moved
	dc.l	NOT_USED		;draw_item
	dc.l	MenuString		;menu_string
	dc.l	MenuFunction		;menu_function
	dc.l	NOT_USED		;compression_service
	dc.l	NOT_USED		;hide_menu

END_PLUGIN_TABLE:

;/////////////////////////////////////////////
;=============================================
; START OF PROGRAM
;=============================================
;/////////////////////////////////////////////

;#ifdef TI89
XGFX equ 1
YGFX equ 36
;#else
XGFX equ 6
YGFX equ 42
;#endif


StartPrgm:
	suba.w	#32,a7
	move.l	a7,a6			;stack frame

	move.b	#50,ieInterface+1
	clr.w	resHdl			;clear it

LoopRD:	move.w	resHdl(PC),d0
	beq.s	\nodel
	move.w	d0,-(a7)
	jsr	tios::HeapFree
	addq.l	#2,a7
	clr.w	resHdl

\nodel	move.w	#$500,d0		;Interrupt OFF
	trap	#1
	move.l	d0,-(a7)		;save previous
	lea	ieInterface(PC),a0
	jsr	apilib::InterfaceEngine
	clr.b	1(a0)

	lea	USearchGFX(PC),a1
	move.l	#LCD_MEM,a0
	adda.w	#30*YGFX+XGFX,a0
	moveq.w	#40-1,d1
\loopy	moveq.w	#12-1,d0
\loopx	move.b	(a1)+,(a0)+
	dbra.s	d0,\loopx
	lea	30-12(a0),a0
	dbra.s	d1,\loopy


	move.l	(a7)+,d0		;restore 
	trap	#1

Loop:	jsr	apilib::WaitKey
_Loop:	move.w	d0,CurrentMode
	cmp.w	#268,d0
	beq.s	SearchFileMode
	cmp.w	#269,d0
	beq	AdvSearchMode

	cmp.w	#264,d0
	bne.s	Loop

Exit	adda.w	#32,a7
	rts

KeyPressed:
	cmp.w	#8275,2(a0)
	beq.s	MenuFunction
	rtplugin 0

MenuFunction:
	bsr	StartPrgm
	rtplugin (REDRAW_LIST)
	

;/////////////////////////////////////////////
;=============================================
; NORMAL SEARCH FILE MODE
;=============================================
;/////////////////////////////////////////////
SearchFileMode:
	lea	ieFileMode(PC),a0
	jsr	apilib::InterfaceEngine

	lea	inputText(PC),a0
	move.l	a6,a1
	jsr	apilib::EditComponent
	cmp.w	#269,d1
	beq.s	newMode
	cmp.w	#264,d1
	beq.s	\exit
	tst.w	d0
	beq.s	\exit

	move.l	a1,a0
	bsr	MakeResultArray
	move.w	d0,resHdl
	beq.s	\exit				;

	lea	ieResult(PC),a0			;draw result window
	jsr	apilib::InterfaceEngine

	jsr	apilib::DEREFd0a0		;Get address of buffer
	lea	2(a0),a1			;skip first word
	lea	lvResult(PC),a0			;
	move.w	(a1)+,(a0)			;Put nb items
	beq.s	\nofile
	jsr	apilib::ListViewComponent	;draw list view

\exit	bra	LoopRD

\nofile	lea	ieNoFileFound(PC),a0
	jsr	apilib::InterfaceEngine
	bra.s	\exit

newMode: move.w	d1,d0
	bra	_Loop


;---------------------------------------------
; Create an array where it puts :
;	---------------------------
;	| Folder Hdl | File Hdl   |
;	---------------------------
; of found items
; using the universal function  ScanFiles
; that loop  all files and call a callback
; function
;
;Input>	a0.l : Reference string to search
;Out>	d0.w : Handle of the array
;		0 if error
;---------------------------------------------
MakeResultArray:
	lea	CBScan_Normal(PC),a2
	bsr	ScanFiles
	rts

;---------------------------------------------
;CallBack function called by ScanFiles
;Input>	a0.l : param passed
;	a1.l : addr of VAT
;	d3.w : Handle of buffer
;---------------------------------------------
CBScan_Normal:
	bsr	CompareStrings
	tst.w	d0
	beq.s	\exit
	
	move.w	VAT_ENTRYHDL(a5),-(a7)
	move.w	VAT_ENTRYHDL(a4),-(a7)
	move.w	d3,d0			;Handle of array
	moveq.w	#4,d1			;size of each item
	move.l	a7,a0
	jsr	apilib::array_AddItem
	addq.l	#4,a7

\exit	rts


;---------------------------------------------
; Compare two strings, using filters '*'
; and '?'
;
;Input>	a0.l : Reference string ( ie: ben?i* )
;	a1.l : String to compare with
;Out>	d0.w : 	0 if invalid
;		1 if match
;---------------------------------------------
CompareStrings:
	movem.l	d2-d3/a0-a1,-(a7)

	moveq.w	#1,d0		;default : sucessful

\loop	move.b	(a0)+,d2
	move.b	(a1)+,d3

	cmp.b	#'*',d2		;if '*' it's ok
	beq.s	\success
	tst.b	d2		;check if the two strings are 
	bne.s	\skip		;finished
	tst.b	d3
	beq.s	\success
	bra.s	\failed		;if 1st terminated, 2nd not terminated
\skip	tst.b	d3
	beq.s	\failed		;if 2nd terminated, 1st not terminated
	cmp.b	#'?',d2
	beq.s	\skipcmp
	cmp.b	d2,d3
	bne.s	\failed
\skipcmp bra.s	\loop

\failed	clr.w	d0
\success movem.l (a7)+,d2-d3/a0-a1
	rts


;/////////////////////////////////////////////
;=============================================
; ADVANCED SEARCH FILE MODE
;=============================================
;/////////////////////////////////////////////
AdvSearchMode:
	;------------------------------------
	; draw graphical interface
	;------------------------------------
	lea	ieAdvMode(PC),a0
	jsr	apilib::InterfaceEngine
	bsr	RefreshCheckBoxes

	;------------------------------------
	; wait for the user to enter text
	;------------------------------------
	lea	inputAdvText(PC),a0		;header
	move.l	a6,a1				;buffer
	jsr	apilib::EditComponent
	cmp.w	#21,d1			;NEWMODE ?
	beq.s	AdvSearchMode
	cmp.w	#268,d1
	beq	newMode
	cmp.w	#264,d0
	beq	\exit
	move.w	d0,strLength
	beq.s	\exit
	move.l	a1,a0

	;------------------------------------
	; Convert Hexa->Str if needed
	;------------------------------------
	tst.b	cbMode
	beq.s	\nohexa

	move.w	d0,d3			;save strLength
	btst.b	#0,d3
	beq.s	\nooffset
	adda.w	d3,a1
	addq.w	#1,d3
	lea	1(a1),a0
	move.w	d3,d0
	subq.w	#1+1,d0
\offset	move.b	-(a1),-(a0)
	dbra.s	d0,\offset
	clr.b	(a1)

\nooffset
	move.l	a1,a2
	move.l	a1,a0

	lsr.w	#1,d3
	move.w	d3,strLength
	subq.w	#1,d3

\convert clr.w	d0
	move.b	(a1)+,d0
	bsr	HexToNb
	move.b	d0,d1
	lsl.w	#4,d1
	move.b	(a1)+,d0
	bsr	HexToNb
	eor.w	d0,d1
	move.b	d1,(a2)+
	dbra.s	d3,\convert	
	clr.b	(a2)+


\nohexa	;------------------------------------
	; Create the array of the result
	;------------------------------------
	bsr	MakeAdvResultArray
	move.w	d0,resHdl
	beq.s	\exit				;

	;------------------------------------
	; and show it
	;------------------------------------
	lea	ieResult(PC),a0			;draw result window
	jsr	apilib::InterfaceEngine
	jsr	apilib::DEREFd0a0		;Get address of buffer
	lea	2(a0),a1			;skip first word
	lea	lvResult(PC),a0			;
	move.w	(a1)+,(a0)			;Put nb items
	beq.s	\nofile
	jsr	apilib::ListViewComponent	;draw list view

\exit	bra	LoopRD

\nofile	lea	ieNoFileFound(PC),a0
	jsr	apilib::InterfaceEngine
	bra.s	\exit


;---------------------------------------------
; Create an array where it puts :
;	---------------------------
;	| Folder Hdl | File Hdl   |
;	---------------------------
; of found items
; using the universal function  ScanFiles
; that loop  all files and call a callback
; function
;
;Out>	d0.w : Handle of the array
;		0 if error
;---------------------------------------------
MakeAdvResultArray:
	lea	CBScan_Adv(PC),a2
	bsr	ScanFiles
	rts

;---------------------------------------------
;CB function:
;Input>	a0.l : param passed
;	a1.l : addr of VAT
;	d3.w : Handle of buffer
;---------------------------------------------
CBScan_Adv:
	;------------------------------------
	; Search a string in a file
	;------------------------------------
	move.w	VAT_ENTRYHDL(a1),d0
	bsr	SearchStringInFile
	tst.w	d0
	beq.s	\exit
	
	;------------------------------------
	; If found, add an item to the
	; array
	;------------------------------------
	move.w	VAT_ENTRYHDL(a5),-(a7)
	move.w	VAT_ENTRYHDL(a4),-(a7)
	move.w	d3,d0			;Handle of array
	moveq.w	#4,d1			;size of each item
	move.l	a7,a0
	jsr	apilib::array_AddItem
	addq.l	#4,a7

\exit	rts

;---------------------------------------------
; Search a string in a file, according 
; to cbCase
;
;Input>	d0.w : Handle of the file
;	strLength.w : Length of the string to search
;	a0.l : 0-terminated string to look for
;Out>	d0.w : 	0 if not found
;		1 if found
;---------------------------------------------
SearchStringInFile:
	movem.l	d1-d6/a0-a4,-(a7)

	move.l	a0,a1			;save addr
	jsr	apilib::DEREFd0a0	;addr of file
	move.w	(a0)+,d3		;size of the file

	move.l	a0,a2			;save registers
	move.l	a1,a3

\next_byte:
	move.w	strLength(PC),d6	;save nb of byte to cmp
\next_char:
	move.w	d3,d4
	subq.w #1,d4		;end of file ?
	beq.s	\notfound

	clr.w	d0		;make it a word
	clr.w	d1
	move.b (a0)+,d0
	move.b	(a1)+,d1

	tst.b	cbCase
	bne.s	\nocase
	tst.b	cbMode
	bne.s	\nocase		;if mode hexa set
	move.w	d0,-(a7)
	move.w	d1,d0
	bsr	CharLowerCase
	move.w	d0,d1
	move.w	(a7)+,d0
	bsr	CharLowerCase

\nocase	cmp.b	d0,d1
	bne.s	\notequal
	subq.w	#1,d6
	beq.s	\found
	bra.s	\next_char

\notequal addq.l #1,a2
	move.l	a2,a0
	move.l	a3,a1			;string to search
	subq.w	#1,d3
	bra.s	\next_byte

\notfound clr.w	d0

\exit	movem.l	(a7)+,d1-d6/a0-a4
	rts

\found	moveq.w	#1,d0
	bra.s	\exit

;------------------------------------------------------
; Refresh checkboxes status
;-------------------------------------------------------
RefreshCheckBoxes:
	clr.w	d0
	jsr	apilib::SetFont

	lea	cbCase(PC),a0
	jsr	apilib::CheckBoxComponent
	lea	cbMode(PC),a0
	jsr	apilib::CheckBoxComponent

	moveq.w	#1,d0
	jsr	apilib::SetFont
	rts


ConvertHexToBuffer:
	move.l	a0,a1
\loop	move.b	(a0)+,d0
	beq.s	\eos
	bsr	HexToNb
	move.w	d0,d1
	move.b	(a0)+,d0
	beq.s	\eos
	bsr	HexToNb
	lsl.w	#4,d1
	or.w	d0,d1
	move.b	d1,(a1)+
	bra.s	\loop
\eos	rts

;d0.w
HexToNb:
	cmp.w	#'9',d0
	bhi.s	\letter
	sub.w	#'0',d0
	bra.s	\exit
\letter	sub.w	#'A'-10,d0
\exit	and.w	#%1111,d0
	rts

;/////////////////////////////////////////////
;=============================================
; MISC ROUTINES
;=============================================
;/////////////////////////////////////////////

;---------------------------------------------
; Scan for All files and call a CB function
;
;Input>	a0.l : Param to pass
;	a2.l : Address of function
;Out>	d0.w : Handle of the array
;		0 if error
;---------------------------------------------
ScanFiles:
	movem.l	d1-d5/a0-a5,-(a7)
	move.l	a0,a3			;save it

	moveq.w	#4,d1			;size of each item
	jsr	apilib::array_Create
	move.w	d0,d3			;save handle
	beq.s	\exit

	move.w	#tios::FolderListHandle,d0
	jsr	apilib::DEREFd0a0
	lea	2(a0),a4		;skip first word
	move.w	(a4)+,d4		;nb items
	beq.s	\failed
	subq.w	#1,d4			;for dbra

\loop_folder
	move.w	VAT_ENTRYHDL(a4),d0
	beq.s	\skip_folder
	jsr	apilib::DEREFd0a0
	lea	2(a0),a5		;skip first word
	move.w	(a5)+,d5		;nb files
	beq.s	\skip_folder
	subq.w	#1,d5			;for dbra

\loop_file move.l a3,a0
	move.l	a5,a1
	jsr	(a2)

\skip_file lea	VAT_ENTRYSIZE(a5),a5
	dbra.s	d5,\loop_file

\skip_folder lea VAT_ENTRYSIZE(a4),a4
	dbra.s	d4,\loop_folder

	move.w	d3,d0			;handle

\exit	movem.l	(a7)+,d1-d5/a0-a5
	rts

\failed	clr.w	d0
	bra.s	\exit






;---------------------------------------------
; Function called to draw an item in the 
; ListView component
;---------------------------------------------
lvDrawItem:
	move.w	d0,d4			;save X / Y
	move.w	d1,d5

	move.w	(a1),d0			;Handle of folder
	move.w	2(a1),d1		;Handle of file
	jsr	apilib::vat_FindHdl
	tst.w	d2
	beq.s	\exit

	subq.w	#1,d2
	suba.w	#30,a7
	move.l	a7,a0
	moveq.w	#25,d1
	jsr	apilib::nf_GetVatName
	tst.w	d1
	bne.s	\ex2

	move.l	a0,a1			;
	move.w	d4,d0			;restore X / Y
	move.w	d5,d1
	jsr	apilib::draw_StringSpecial	

\ex2	adda.w	#30,a7
\exit	rts

;---------------------------------------------
; 
;---------------------------------------------
api92CB_edKeyDown:
	clr.w	d1

	cmp.w	#KEY_SWAPMODE,d0	;Mode Hexa/String
	bne.s	\nomode
	bchg.b	#0,cbMode
	bsr	RefreshCheckBoxes
	moveq.w	#21,d1			;d1=21 = NEWMODE
	bra.s	\exit

\nomode	cmp.w	#KEY_MATCHCASE,d0	;Match Case
	bne.s	\nocase
	bchg.b	#0,cbCase
	bsr	RefreshCheckBoxes
	clr.w	d0		;ignore key
	bra.s	\exit

\nocase	cmp.w	#264,d0
	beq.s	\esc
	cmp.w	#268,d0
	beq.s	\ok
	cmp.w	#269,d0
	bne.s	\skip

\ok	cmp.w	CurrentMode(PC),d0
	beq.s	\skip
\esc	move.w	d0,d1
	bra.s	\exit

\skip
;#ifdef TI89
	cmp.w	#270,d0			;F3='*' on TI89
	bne.s	\nostar
	move.w	#'*',d0
	bra.s	\exit
\nostar	cmp.w	#271,d0			;F4='?' on TI89
	bne.s	\noi
	move.w	#'?',d0
	bra.s	\exit
\noi
;#endif

	cmp.w	#16,4(a6)
	bne.s	\exit

	tst.b	cbMode
	beq.s	\exit
	cmp.w	#48,d0			;'0'
	bcs.s	\invalid
	cmp.w	#57,d0			;'9'
	bls.s	\exit			;valid
	cmp.w	#97,d0			;'A'
	bcs.s	\invalid
	cmp.w	#102,d0			;'F'
	bhi.s	\invalid		;
	sub.w	#'a'-'A',d0
	bra.s	\exit

\skipMode	
\invalid clr.w	d0
\exit
	rts

;a0.l: addr of string
StrLowerCase:
	movem.l	d0/a0,-(a7)
\loop	clr.w	d0
	move.b	(a0),d0
	beq.s	\exit
	bsr	CharLowerCase
	move.b	d0,(a0)+
	bra.s	\loop
\exit	movem.l	(a7)+,d0/a0
	rts

;d0.w : char
CharLowerCase:
	cmp.w	#'A',d0
	bcs.s	\skip
	cmp.w	#'Z',d0
	bhi.s	\skip
	sub.w	#'A'-'a',d0
\skip	rts

;*****************************************************
; Program data
;*****************************************************

inputText:
	dc.w	50+OX,55+OY
	dc.w	8
	dc.b	0,%00000001
	dc.l	api92CB_edKeyDown
	dc.l	0

inputAdvText:
	dc.w	50+OX,55+OY
	dc.w	16
	dc.b	0,%00000000
	dc.l	api92CB_edKeyDown
	dc.l	0

strLength dc.w	0
CurrentMode: dc.w 0
resHdl	dc.w	0


lvResult:
	dc.w	0			;Nb Item
	dc.w	5			;NbItemPerPage
	dc.w	52+OX,45+OY		;X,Y
	dc.w	0,0			;reserved
	dc.w	124			;Width of component
	dc.w	4			;Constant Size
	dc.w	0			;Constant Height
	dc.b	%01000010		;Flags
	dc.b	0
	dc.l	0			;api92CB_lvKeyDown
	dc.l	0			;api92CB_lvKey
	dc.l	0			;api92CB_OnSelect
	dc.l	lvDrawItem		;api92CB_lvDrawItem
	dc.l	0			;api92_lvItemsProperties
	
ieResult
	dc.b	IE_ANIMEDWIN2,50,50+OX,35+OY,185+OX,79+OY,"Result of the Search",0
	dc.b	IE_SETFONT,0
	dc.b	IE_END

ieNoFileFound:
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,65+OX,56+OY,"No File Found",0
	dc.b	IE_WAITKEY
	dc.b	IE_END


ieInterface
	dc.b	IE_ANIMEDWIN2,50,40+OX,30+OY,199+OX,85+OY,"Ultimate Search",0
	dc.b	IE_SOLIDRECT,40+OX,85+OY,105+OX,93+OY
	dc.b	IE_SOLIDRECT,105+OX,85+OY,185+OX,93+OY
	dc.b	IE_SETFONT,0
	dc.b	IE_STRING,46+OX,87+OY,"F1:Search File",0
	dc.b	IE_STRING,119+OX,87+OY,"F2:Adv Search",0
	dc.b	IE_STRING,145+OX,70+OY,"release 1.0.2",0
	dc.b	IE_STRING,145+OX,76+OY,"Ibrahim",0
	dc.b	IE_END

ieFileMode:
	dc.b	IE_SOLIDRECT,42+OX,40+OY,197+OX,83+OY
	dc.b	IE_SETFONT,0
;#ifdef TI89
	dc.b	IE_STRING,45+OX,75+OY,"(you can use F3='*' or F4='?' for filters)",0
;#else
	dc.b	IE_STRING,45+OX,75+OY,"(you can use '*' or '?' for filters)",0
;#endif
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,45+OX,45+OY,"Search File :",0
	dc.b	IE_END

ieAdvMode:
	dc.b	IE_SOLIDRECT,42+OX,40+OY,197+OX,83+OY
	dc.b	IE_SETFONT,1
	dc.b	IE_STRING,45+OX,45+OY,"Containing the string  :",0
	dc.b	IE_SETFONT,0
	dc.b	IE_END

cbCase	dc.b	1		;checked
	dc.b	0		;style
	dc.b	48+OX,75+OY	;X,Y
	dc.b	"Match Case (",127,"C)",0	;

cbMode	dc.b	0
	dc.b	0
	dc.b	125+OX,75+OY
	dc.b	"Mode HEXA (",127,"H)",0

mode:	dc.b	0

	ds.w	0
	include "usgfx.h"

MenuString:
_comment:
	dc.b	"Ultimate Search",0,0


;*************** End of Fargo program ****************

	end
