//Algorithme de compression et de dcompression AFE
#include "Header.h"
#include "fonctions.h"
#include "AFE.h"

using namespace std;

//Initialise la table des caractres
void AFE_InitializeTable (unsigned char *car, unsigned char *TableCar, unsigned char *TableHeader)
{
  unsigned char nbit=1;
  unsigned char code=0;
  
  for (int i=0; i<MAX_ASCII; i++)
  {
    TableCar [i]=code;
    TableHeader [i]=nbit-1;
    
    code++;
    if (code>((1<<nbit)-1)) 
    {
      nbit++; 
      code=0;
    }
    
    car [i]=i;
  }
  
  /*unsigned char nbit=1;
  unsigned char code=0;
  
  car [0]=0;
  car [1]=1;
  TableCar [0]=0;
  TableCar [1]=1;
  TableHeader [0]=0;
  TableHeader [1]=0;
  
  for (int i=2; i<256; i++)
  {
    TableCar [i]=code;
    TableHeader [i]=nbit;
    
    code++;
    if (code>((1<<nbit)-1)) 
    {
      nbit++; 
      code=0;
    }
    
    car [i]=i;
  }*/
}

//Echange de donnes frquences
void AFE_SwapFreq (unsigned long *a, unsigned long *b)
{
  unsigned long temp = *a;
  *a = *b;
  *b = temp;
}

//Echange de donnes caractres
void AFE_SwapCar (unsigned char *a, unsigned char *b)
{
  unsigned char temp = *a;
  *a = *b;
  *b = temp;
}

//Trie les frquences par ordre dcroissant ainsi que la table de caractres
void AFE_SortTable (unsigned char *TableCar, unsigned char *TableHeader, unsigned long *freq, unsigned char *car)
{
  BOOL permut=true;
  unsigned char start=0;
  unsigned char endpermut=0;
  int i;
  
  //Tant qu'il y a des donnes  trier
  while (permut==true)
  {
    //Parcours table  l'envers
    for (permut=false, i=(MAX_ASCII-1); i>start; i--)
    {
      //Trier
      if (freq [i]>freq [i-1])
      {
        //Echange l'ordre
        AFE_SwapFreq ((freq+i), (freq+(i-1)));
        AFE_SwapCar ((car+i), (car+(i-1)));
        AFE_SwapCar ((TableCar+i), (TableCar+(i-1)));
        AFE_SwapCar ((TableHeader+i), (TableHeader+(i-1)));
        permut=true;
        endpermut=(unsigned char)i;
      }
    }
    
    start=endpermut;
  }
} 

//Recherche caractre
unsigned char AFE_FindCar (unsigned char *car, unsigned char c)
{
  for (int i=0; i<256; i++)
    if (car [i]==c)
      return i;
}

//Application algorithme de compression AFE
void AFE_Compress (unsigned char *TableCar, unsigned char *TableHeader, unsigned long *freq, unsigned char *car, FILE *input,FILE *output)
{
  //Variables fichier
  unsigned char c;
  unsigned char byte=0;
  unsigned char start=0;
  
  //Affichage pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
  
  //Parcours fichier
  while (!feof (input))
  {
    //Caractre en cours
    c=fgetc (input);
    purcent=((unsigned long long)++k*100)/TPE_FILE.size;
    
    //Fin du fichier
    if (feof (input)) break;
    
    //Ecriture de l'en tte
    BitWrite (TableHeader [AFE_FindCar (car, c)], byte, start, 3, output);
    
    //Ecriture caractre
    BitWrite (TableCar [AFE_FindCar (car, c)], byte, start, TableHeader [AFE_FindCar (car, c)]+1, output);
    
    //Ajoute frquence
    freq [AFE_FindCar (car, c)]++;
    
    //Trie
    AFE_SortTable (TableCar, TableHeader, freq, car);
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rCompress in progress... %u%% achieved.", purcent);}
  }
  
  //Octet restant
  if (start!=0)
    //Ecriture octet
    fputc (byte,output);
}

//Compression AFE
int CompressAFE (FILE *input,FILE *output)
{  
  unsigned long freq [MAX_ASCII]={};
  unsigned char car [MAX_ASCII];
  
  unsigned char TableCar [MAX_ASCII];
  unsigned char TableHeader [MAX_ASCII];
  
  printf ("Compress in progress... 0%% achieved.");
  
  AFE_InitializeTable (car, TableCar, TableHeader);
  AFE_Compress (TableCar, TableHeader, freq, car, input, output);
               
  return -1;
}

//Recherche caractre dcompression
unsigned char AFE_FindChar2 (unsigned char *TableCar, unsigned char *TableHeader, unsigned char nbit, unsigned char code)
{
  for (int i=0; i<256; i++)
  {
    if ((nbit==TableHeader [i]) && (code==TableCar [i]))
      return i;
  }
}

//Application algorithme de dcompression RLE
void AFE_Uncompress (unsigned char *TableCar, unsigned char *TableHeader, unsigned long *freq, unsigned char *car, FILE *input,FILE *output)
{
  unsigned char start=0;
  unsigned char byte=fgetc (input);
  
  unsigned char nbit;
  unsigned char c;
  
  //Affichage pourcentage
  unsigned char purcent=0, purcent2=0;
  unsigned long counter=0;
  
  //Parcours fichier
  while (!feof (input) && (counter!=TPE_FILE.size))
  {
    //Nombres de bits pour caractre
    nbit=BitRead (byte, start, 3, input);
    c=BitRead (byte, start, nbit+1, input);
    
    //Fin du fichier
    if (feof (input)) break;
    
    //Caractre en cours
    c=AFE_FindChar2 (TableCar, TableHeader, nbit, c);
    fputc (car [c], output);
    
    //Ajoute frquence
    freq [car [c]]++;
    
    //Trie
    AFE_SortTable (TableCar, TableHeader, freq, car);
    
    //*******************
    //Affiche pourcentage
    //*******************
    purcent=((unsigned long long)++counter*100)/TPE_FILE.size;
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rUncompress in progress... %u%% achieved.", purcent);}
  }
}

//Dcompression AFE
int UncompressAFE (FILE *input,FILE *output)
{
  unsigned long freq [MAX_ASCII]={};
  unsigned char car [MAX_ASCII]={};
  
  unsigned char TableCar [MAX_ASCII];
  unsigned char TableHeader [MAX_ASCII];
  
  printf ("Uncompress in progress... 0%% achieved.");
  
  AFE_InitializeTable (car, TableCar, TableHeader);
  AFE_Uncompress (TableCar, TableHeader, freq, car, input, output);
    
  return -1;
}
