#include "fonctions.h"
#include "ArbreBin.h"

//Insertion d'un item dans l'arbre
Tree *TREE_Insertion (Tree *ABR, unsigned char *string, unsigned short size, unsigned long index)
{  
  //Branche inexistante
  if (!ABR)
  {
    //Allocation tmp
    Tree *temp=(Tree *)malloc (sizeof (struct Tree));
    
    temp->ptr=string;
    temp->size=size;
    
    //temp->size=size;           //Taille item
    temp->index=index;           //Index
    temp->FGauche=NULL;          //Branche vide
    temp->FDroite=NULL;          //Branche vide
    return temp;
  }
  
  //Mthode de cration type rcurrent
  //----------------------------------
  //Si courant<=value alors placer  droite
  if (ABR->size<=size)
    ABR->FDroite=TREE_Insertion (ABR->FDroite, string, size, index);
  //Sinon placer  gauche
  else
    ABR->FGauche=TREE_Insertion (ABR->FGauche, string, size, index);
  
  //Retourne pointeur du noeud cre    
  return ABR;
}

//Recherche valeur
Tree *TREE_Recherche (Tree *ARB, unsigned char *string, unsigned short size)
{
  //Recherche rcurrente
  while (ARB)
  {
    //Si lment trouv
    if (ARB->size==size) 
      if (!memcmp (ARB->ptr, string, size)) 
        return ARB;
      
    //Parcours branche pour optimisation recherche
    if (size<ARB->size)
      ARB=ARB->FGauche;
    else
      ARB=ARB->FDroite;
  }
  
  //Retourne recherche
  return ARB;
}

//Parcours tout l'arbre
void TREE_ParcoursPre (Tree *ABR)
{
  printf ("%lu\n",ABR->index);
  if (ABR->FGauche) TREE_ParcoursPre (ABR->FGauche); 
  if (ABR->FDroite) TREE_ParcoursPre (ABR->FDroite);
}

//Suppression de l'arbre
Tree *TREE_Suppression (Tree *ABR)
{
  if (ABR)
  {
    if (ABR->FGauche) ABR->FGauche=TREE_Suppression (ABR->FGauche);
    if (ABR->FDroite) ABR->FDroite=TREE_Suppression (ABR->FDroite);
    free (ABR);
  }
  
  return NULL;
}
