//Algorithme de compression et de dcompression LZSS
#include "Header.h"
#include "fonctions.h"
#include "ArbreBin.h"
#include "Huffman.h"
#include "LZSS.h"

using namespace std;

//Recherche une dfinition dans le tampon
BOOL LZ_Find (unsigned char *tampon, unsigned char *buffer, unsigned long &pos, unsigned short &size)
{
  void *ptr;                    //Pointeur rsultat de memchr
  unsigned long t_pos=0;        //Position entre le caractre et le tampon
  unsigned short t_size;         //Taille de la chane trouve
  
  unsigned short buffer_pos=1;   //Position dans le buffer
  
  BOOL find=false;
  
  size=0;
  pos=0;
  
  //Cherche la meilleur chane
  while (t_pos<WINDOW_SIZE)
  {
    //Recherche caractre de dbut
    ptr=memchr (tampon+t_pos, buffer[0], (WINDOW_SIZE-t_pos));
  
    //Recherche echoue
    if (!ptr) 
      return find;
  
    //Position entre le caractre et le tampon
    t_pos=(unsigned char*)ptr-tampon;
  
    //Cherche longeur de la chane
    t_size=1; //Taille
    buffer_pos=1;
    
    //Parcours buffer
    while ((buffer_pos<BUFFER_SIZE) && ((t_pos+buffer_pos)<WINDOW_SIZE))
    {
      //Si caractre suivant=caractre tampon
      if (tampon [t_pos+buffer_pos]==buffer [buffer_pos++])
        t_size++;
      //Fin de la recherche
      else
        break;
    }
  
    //Si c'est la plus longue chane trouve
    if (t_size>size) {
      size=t_size;
      pos=WINDOW_SIZE-t_pos;}
      
    //Avance dans le tampon
    t_pos++;
    
    //Si la taille de la chane est suprieur  1    
    if (size>=3) find=true;
  }
  
  //Retourne rsultat de la recherche
  return find;
}

//Application de l'algorithme de compression
int LZSS_Compress (unsigned char *tampon, H_ASCII *Table_ASCII, unsigned short &DimAscii, unsigned char EndTableByte, unsigned char EndTableStart, FILE *input, FILE *output, BOOL mode)
{
  //Dfinition du buffer
  #define buffer (unsigned char *)(tampon+START_BUFFER)
    
  //Variables compression  
  unsigned char read=1;
  unsigned char endread;
  BOOL find;
  
  //Variables temporaires
  unsigned long pos;
  unsigned short size;
  
  //Variables temporaire gestion bit  bit du fichier de sortie
  unsigned char byte=0;
  unsigned char start=0;
  
  if (mode==Mode_LZH_1) {
    byte=EndTableByte;
    start=EndTableStart;}
  
  //Affichage pourcentage
  unsigned long k=(BUFFER_SIZE*2)-1;
  unsigned char purcent=0, purcent2=0;
  
  //Remplissage buffer
  fread (buffer-BUFFER_SIZE, (BUFFER_SIZE*2)-1, 1, input);
  
  //Ecriture permettant la communication avec le dcompresseur
  for (int i=0; i<BUFFER_SIZE; i++) {
    if (mode!=Mode_LZH_0) BitWrite (BIT_CHAR, byte, start, 1, output);
    //BitWrite (*(unsigned char*)(buffer-BUFFER_SIZE+i), byte, start, 8, output);}
    LZ_WriteCode (*(unsigned char*)(buffer-BUFFER_SIZE+i), byte, start, Table_ASCII, DimAscii, output, mode);}
     
  //Parcours fichier
  while (!feof (input))
  {
    //Ajoute caractre
    endread=fread (tampon+TAMPON_SIZE-read, 1, read, input);
    purcent=((unsigned long long)(k+=read)*100)/TPE_FILE.size;
    
    //Dpassement du fichier
    if (endread!=read)
      break;
       
    //Recherche de dfinition
    find=LZ_Find (tampon, buffer, pos, size);
    
    //Recherche russie
    if (find)
    {
      read=size;
    
      //Ecriture dans fichier du COUPLE (pos, size)
      if (mode!=Mode_LZH_0) 
      {
        BitWrite (BIT_INDEX, byte, start, 1, output);
        BitWrite (pos-1, byte, start, BITS_POS, output);
        BitWrite (size-1, byte, start, BITS_SIZE, output);
      }
    }
    //Recherche choue
    else
    {
      read=1;
      
      //Ecriture dans fichier
      if (mode!=Mode_LZH_0) BitWrite (BIT_CHAR, byte, start, 1, output);
      //BitWrite (tampon [START_BUFFER], byte, start, 8, output);
      LZ_WriteCode (tampon [START_BUFFER], byte, start, Table_ASCII, DimAscii, output, mode);
    }
    
    //Dcalage tampon
    memmove (tampon, tampon+read, TAMPON_SIZE-read);
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      if (mode==Mode_LZSS)
        printf ("\rCompress in progress... %u%% achieved.", purcent);
      else if (mode==Mode_LZH_0)
        printf ("\rPass 1: Make table of frequency with output characters... %u%% achieved.", purcent);
      else
        printf ("\rPass 2: LZSS, created output characters with Huffman codes... %u%% achieved.", purcent);}
  }
  
  //Ecriture reste buffer
  for (int i=0; i<(BUFFER_SIZE-read)+endread; i++) {
    if (mode!=Mode_LZH_0) BitWrite (BIT_CHAR, byte, start, 1, output);
    //BitWrite (*(unsigned char*)(buffer+i), byte, start, 8, output);}
    LZ_WriteCode (*(unsigned char *)(buffer+i), byte, start, Table_ASCII, DimAscii, output, mode);}
    
  //Affiche pourcentage restant
  purcent=((unsigned long long)(k+=(BUFFER_SIZE-read)+endread)*100)/TPE_FILE.size;
  if (mode==Mode_LZSS)
    printf ("\rCompress in progress... %u%% achieved.", purcent);
  else if (mode==Mode_LZH_0)
    printf ("\rPass 1: Make table of frequency with output characters... %u%% achieved.", purcent);
  else
    printf ("\rPass 2: LZSS, created output characters with Huffman codes... %u%% achieved.", purcent);
  
  //Octet restant
  if (start!=0)
    fputc (byte, output);
}


//Compression mthode de compression LZSS
int CompressLZSS (FILE *input,FILE *output)
{
  //Ecriture de l'header
  fwrite (&WINDOW_SIZE, 4, 1, output);
  fwrite (&BUFFER_SIZE, 2, 1, output);
  
  //Taille des donnes couple (pos, size)
  BITS_POS=NBitInt (WINDOW_SIZE-1);
  BITS_SIZE=NBitInt (BUFFER_SIZE-1);
    
  //Allocation du tampon
  unsigned char *TAMPON=(unsigned char*)malloc (TAMPON_SIZE);
  //Vide tampon
  memset (TAMPON, 0, TAMPON_SIZE);
  
  unsigned short DimAscii;
  
  printf ("Window size: %lu\n", WINDOW_SIZE);
  printf ("Buffer size: %u\n\n", BUFFER_SIZE);    
  printf ("Compress in progress... 0%% achieved.");
  
  //Compression
  LZSS_Compress (TAMPON, NULL, DimAscii, 0, 0, input, output, Mode_LZSS);
  
  //Libre mmoire
  free (TAMPON);
   
  return -1;
}


//Application de l'algorithme de dcompression
int LZSS_Uncompress (unsigned char *tampon, FILE *input, FILE *output, BOOL mode)
{
  //Dfinition buffer
  #define buffer (unsigned char *)(tampon+START_BUFFER)
     
  //Variables lecture bit  bit du fichier
  unsigned char byte=fgetc (input);
  unsigned char start=0;
  
  //Variables temporaire
  unsigned long pos;
  unsigned short size;
  
  //Compteur d'octet
  unsigned long counter=BUFFER_SIZE;
  
  //Affichage pourcentage
  unsigned char purcent=0, purcent2=0;
  
  //Remplissage buffer
  for (int i=0; i<BUFFER_SIZE; i++)  {
    BitRead (byte, start, 1, input);
    tampon [START_BUFFER+i]=BitRead (byte, start, 8, input);
    fputc (tampon [START_BUFFER+i],output);}
  
  //Parcours fichier
  while (!feof (input) && (counter!=TPE_FILE.size))
  {
    //CARACTERE
    if (BitRead (byte, start, 1, input)==0) 
    {
      //Dcalage d'un caractre du tampon
      memmove (tampon, tampon+1, TAMPON_SIZE-1);
      
      //Ajout dans c_buffer
      tampon [END_BUFFER]=BitRead (byte,start, 8, input);
            
      //Ecriture caractre
      fputc (tampon [END_BUFFER], output);
      counter++;
    }
    //COUPLE
    else
    {
      //Lecture du couple
      pos=BitRead (byte, start, BITS_POS, input)+1;
      size=BitRead (byte, start, BITS_SIZE, input)+1;
            
      //Dcalage tampon
      memmove (tampon, tampon+size, TAMPON_SIZE-size);
      
      //Ecriture du couple
      fwrite (tampon+(TAMPON_SIZE-pos)-size, size, 1, output);
      counter+=size;
      
      //Copie dfinition
      memcpy ((tampon+TAMPON_SIZE)-size, tampon+(TAMPON_SIZE-pos)-size, size);
    }
    
    //*******************
    //Affiche pourcentage
    //*******************
    purcent=((unsigned long long)counter*100)/TPE_FILE.size;
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rUncompress in progress... %u%% achieved.", purcent);}
  }
}

//Dcompression mthode de compression LZSS
int UncompressLZSS (FILE *input,FILE *output)
{
  //Lecture de l'header
  fread (&WINDOW_SIZE, 4, 1, input);
  fread (&BUFFER_SIZE, 2, 1, input);
  
  //Taille des donnes couple (pos, size)
  BITS_POS=NBitInt (WINDOW_SIZE-1);
  BITS_SIZE=NBitInt (BUFFER_SIZE-1);
  
  //Allocation du tampon
  unsigned char *TAMPON=(unsigned char *)malloc (TAMPON_SIZE);
  //Vide tampon
  memset (TAMPON, 0, TAMPON_SIZE);
  
  printf ("Window size: %lu\n", WINDOW_SIZE);
  printf ("Buffer size: %u\n\n", BUFFER_SIZE);    
  printf ("Uncompress in progress... 0%% achieved.");
  
  //Dcompression
  LZSS_Uncompress (TAMPON, input, output, Mode_LZSS);
  
  //Libre mmoire
  free (TAMPON);
  
  return -1;
}

//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
//Recherche de divers paramtres
//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
int LZSS_SearchParameters (int argc, char *argv[])
{
  //Taille par dfaut
  unsigned long window_size=DEFAULT_WINDOW_SIZE;
  unsigned short buffer_size=DEFAULT_BUFFER_SIZE;
  
  //Taille des donnes couple (pos, size)
  BITS_POS=13;
  BITS_SIZE=6;
  
  //Parcours arguments
  for (int i=1; i<argc; i++)
  {
    //Argument WINDOW_SIZE
    if (!strncmp (StrCnvL (argv [i]), "/dico_size=", 11))
      //Recherche nombre
      window_size=StrToInt (argv [i]+11, strlen (argv [i]+11));
      
    if (!strncmp (StrCnvL (argv [i]), "/window_size=", 13))
      //Recherche nombre
      window_size=StrToInt (argv [i]+13, strlen (argv [i]+13));
      
    else if (!strncmp (StrCnvL (argv [i]), "/buffer_size=", 13))
      //Recherche nombre
      buffer_size=StrToInt (argv [i]+13, strlen (argv [i]+13));
  }
  
  //Erreur argument
  if (window_size<8) {
    cerr << "Error: Incorrect parameter WINDOW_SIZE (DICO_SIZE).\n";
    return 19;}
  
  if ((buffer_size==0) ||(buffer_size>255)) {
    cerr << "Error: Incorrect parameter BUFFER_SIZE.\n";
    return 20;}
    
  if (window_size<buffer_size) {
    cerr << "Error: WINDOW_SIZE is inferior as BUFFER_SIZE.\n";
    return 21;}
    
  if (TPE_FILE.size<((buffer_size*2)-1)) {
    printf ("Error: The size of input file is inferior as %u octets.\n", (buffer_size*2)-1);
    return 22;}
  
  //Assignation de la taille du dictionnaire
  WINDOW_SIZE=window_size;
  BUFFER_SIZE=buffer_size;
  
  //Aucune erreur
  return -1;
}

//Compression hybride LZSS et LZH
void LZ_WriteCode (unsigned char c, unsigned char &byte, unsigned char &start, H_ASCII *Table_ASCII, unsigned short &DimAscii, FILE *file, BOOL mode)
{
  //-- Code LZSS --
  if (mode==Mode_LZSS)
    BitWrite (c, byte, start, 8, file);
    
  //-- Code LZH -- Pass 1
  if (mode==Mode_LZH_0)
    //Ajoute frquence
    if (!((Table_ASCII [c]).freq)++) DimAscii++;
  
  //-- Code LZH -- Pass 2    
  if (mode==Mode_LZH_1)
    //Ecriture du code de Huffman
    BitWrite (Table_ASCII [c].code, byte, start, Table_ASCII [c].bits, file);
}

