#ifndef LZSS_H
#define LZSS_H

#define DEFAULT_WINDOW_SIZE     8192
#define DEFAULT_BUFFER_SIZE     64

#define WINDOW_SIZE     LZSS_HEADER.window_size
#define BUFFER_SIZE     LZSS_HEADER.buffer_size
#define TAMPON_SIZE     WINDOW_SIZE+BUFFER_SIZE

#define START_BUFFER    WINDOW_SIZE
#define START_WINDOW    0
#define END_WINDOW      WINDOW_SIZE-1
#define END_BUFFER      WINDOW_SIZE+BUFFER_SIZE-1

#define BIT_CHAR        0
#define BIT_INDEX       1

#define Mode_LZSS       0
#define Mode_LZH_0      1           //Pass n0
#define Mode_LZH_1      2           //Pass n1

#define LZ_ASCII_SIZE   256

//Taille des donnes couple (pos, size)
static unsigned char BITS_POS;      //12
static unsigned char BITS_SIZE;     //5

//Prototypes LZSS
int CompressLZSS (FILE *input,FILE *output);
int UncompressLZSS (FILE *input,FILE *output);

//Autres prototypes
//Recherche une dfinition dans le tampon
BOOL LZ_Find (unsigned char *tampon, unsigned char *buffer, unsigned long &pos, unsigned short &size);

//Application de l'algorithme
int LZSS_Compress (unsigned char *tampon, H_ASCII *Table_ASCII, unsigned short &DimAscii, unsigned char EndTableByte, unsigned char EndTableStart, FILE *input, FILE *output, BOOL mode);
int LZSS_Uncompress (unsigned char *tampon, FILE *input, FILE *output, BOOL mode);
int LZSS_SearchParameters (int argc, char *argv[]);

//Prototypes hybride LZSS ou LZH
//Ecriture d'un character non dfinie
void LZ_WriteCode (unsigned char c, unsigned char &byte, unsigned char &start, H_ASCII *Table_ASCII, unsigned short &DimAscii, FILE *file, BOOL mode);

#endif
