//Algorithme de compression et de dcompression LZW (Lempel Ziv Welch)
#include "Header.h"
#include "fonctions.h"
#include "ArbreBin.h"
#include "LZW.h"

using namespace std;

//Initialisation du dictionnaire et de certaines variables
void LZW_Initialize (unsigned char *dico [], unsigned short dico_len [], unsigned long &dico_pos)
{ 
  //Parcours code ASCII (Cration de la table du dictionnaire de base surtout utilise lors de la dcompression)
  for (int i=0;i<256;i++)
  {
    dico [i]=(unsigned char*)malloc (1);
    dico [i][0]=i;
    
    dico_len [i]=1;
  }
    
  //Position dans le dictionnaire
  dico_pos=DICO_START;
}

//Recherche d'une occurence dans le dictionnaire
unsigned long LZW_DicoFind (unsigned char *dico [], Tree *hach_tree [], unsigned char *tampon, unsigned short tampon_size)
{  
  //Parcours dictionnaire
  /*for (unsigned long i=DICO_START; i!=dico_pos; i++)
    if (dico_len [i]==tampon_size)
      //if (tampon [0]==dico [i][0])
        //if (tampon [tampon_size-1]==dico [i][tampon_size-1]) 
          if (!memcmp (tampon, dico [i], tampon_size)) 
        return i;

  return 0;*/
   
  /*for (unsigned long i=0; i!=hach_size [tampon [0]]; i++)
  {
    if ((dico_len [hach_index [tampon [0]][i]])==tampon_size)
      if ((tampon [0]==dico [hach_index [tampon [0]][i]][0]) && (tampon [tampon_size-1]==dico [hach_index [tampon [0]][i]][tampon_size-1]))
        if (!memcmp (tampon, dico [hach_index [tampon [0]][i]], tampon_size))
          return hach_index [tampon [0]][i];
  }

  return 0;*/
  
  unsigned short value=(tampon [1]<<8) | tampon [0];
  Tree *find=NULL;
  
  find=TREE_Recherche (hach_tree [value], tampon, tampon_size);
    
  if (find) return find->index;
  return 0;
}

//Ecriture dans le dictionnaire
void LZW_DicoWrite (unsigned char *dico [], unsigned short dico_len [], unsigned long &dico_pos, Tree *hach_tree [], unsigned char *tampon, unsigned short tampon_size, unsigned char mode)
{
  unsigned short value=(tampon [1]<<8) | tampon [0];
  
  //Allocation
  if (dico [dico_pos]) free (dico [dico_pos]);
  dico [dico_pos]=(unsigned char*)malloc (tampon_size);
  
  //Longueur de la chane
  dico_len [dico_pos]=tampon_size;
  
  //Ecriture de la chane dans le dictionnaire
  memcpy (dico [dico_pos], tampon, tampon_size);
    
  //Table de hachage (COMPRESSION)
  if (mode==Mode_LZW_Compress) 
    hach_tree [value]=TREE_Insertion (hach_tree [value], dico [dico_pos], tampon_size, dico_pos);
  
  //Augmenter l'index dans le dictionnaire
  dico_pos++;
}

//Vrifie dpassement dictionnaire, VIDER DICTIONNAIRE
BOOL LZW_CheckFullDico (unsigned long &dico_pos, Tree *hach_tree [], unsigned char &nbit, unsigned char &byte, unsigned char &start, FILE *output)
{
  //Si dictionnaire non plein
  if (dico_pos!=(DICO_SIZE-1)) return false;
  
  //Dictionnaire plein, VIDER
  dico_pos=DICO_START;        //Dictionnaire au dbut
  
  BitWrite (LZW_CLEAR_DICO, byte, start, nbit, output);  //Ecriture commande
  nbit=LZW_BITSTART;  //Codage des adresse sur n bits
  
  //printf ("Dictionnary clear.\n");

  //Efface table de hachage
  for (int i=0; i!=65536; i++) 
    hach_tree [i]=TREE_Suppression (hach_tree [i]);
  
  //On a vid le dictionnaire
  return true;
}

//Efface le dictionnaire
void LZW_DeleteDico (unsigned char *dico [], unsigned short dico_len [], Tree *hach_tree [], unsigned char mode)
{
  //Parcours dictionnaire et efface
  for (unsigned long i=0; i!=DICO_SIZE ;i++)
    if (dico [i]) 
      free (dico [i]);
      
  //Mmoire alloue    
  free (dico); free (dico_len);
      
  //Efface table de hachage
  if (mode==Mode_LZW_Compress)
  {
    for (int i=0; i<65536; i++) 
      hach_tree [i]=TREE_Suppression (hach_tree [i]);
    
    //Libre mmoire alloue
    free (hach_tree);
  }
}

//Application de l'algorithme de compression
void LZW_Compress (unsigned char *dico [], unsigned short dico_len [], unsigned long &dico_pos, Tree *hach_tree [], FILE *input, FILE *output)
{
  //Tampon
  unsigned char tampon [MAX_STR]={};
  unsigned short tampon_size=0;
  
  //Tampon latent (latent a un caractre d'avance que tampon)
  unsigned char latent [MAX_STR]={};
  unsigned short latent_size=1;
        
  //Variable criture fichier
  unsigned char byte=0;
  unsigned char start=0;
  unsigned char tmp;
  
  //Variables divers
  unsigned char nbit=LZW_BITSTART;          //nbits forme un caractre,  la rencontre de BITPLUS soit -1 on augmente
  
  //Variables recherche
  unsigned long find;
  
  //Affichage pourcentage
  unsigned long k=1;
  unsigned char purcent=0, purcent2=0;
        
  //Caractre de dbut
  latent [0]=fgetc (input);
  
  //Parcours fichier
  while (!feof (input))
  {       
    //Lit caractre
    tmp=fgetc (input);
    
    //Fin du fichier
    if (feof (input)) break;
    
    //Pourcentage de progression
    purcent=((unsigned long long)++k*100)/TPE_FILE.size;
    
    //Ajoute caractre
    memcpy (tampon, latent, latent_size);
    tampon [latent_size]=tmp;
    tampon_size=latent_size+1;
    
    //Dpassement buffer
    if ((tampon_size>=(MAX_STR-1)) || (latent_size>=(MAX_STR-1)))
      printf ("\nBuffer overflow!\n");
    
    //Recherche
    find=LZW_DicoFind (dico, hach_tree, tampon, tampon_size);
    
    //Recherche russie
    if (find) 
    {
      //Copie tampon dans latent, meilleur dfinition
      memcpy (latent, tampon, tampon_size);
      latent_size=tampon_size;
    }
    //Recherche choue
    else
    {
      //Ecrire tampon dans le dictionnaire
      LZW_DicoWrite (dico, dico_len, dico_pos, hach_tree, tampon, tampon_size, Mode_LZW_Compress);
      
      //Recherche de latent
      find=LZW_DicoFind (dico, hach_tree, latent, latent_size);
      
      //Echoue
      if (!find)
        find=latent [0];
      //Ecriture de SP
      while (find>=(1<<nbit))
        BitWrite (LZW_BITPLUS,byte,start,nbit++,output);
        //printf ("%SP\n");}
      
      //Ecrit index ou octet
      BitWrite (find, byte, start, nbit, output);
      //printf ("%u\n", find);
      
      //Latent  zro
      latent [0]=tmp;
      latent_size=1;
      
      //Si on arrive au bout du dictionnaire
      if (LZW_CheckFullDico (dico_pos, hach_tree, nbit, byte, start, output)) //{
        LZW_DicoWrite (dico, dico_len, dico_pos, hach_tree, tampon, tampon_size, Mode_LZW_Compress);
        //printf ("\nClear dictionnary.\n");}
    }
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rCompress in progress... %u%% achieved.", purcent);}
  }
  
  //On crit le buffer latent si il n'existe pas dans le dictionnaire
  find=LZW_DicoFind (dico, hach_tree, latent, latent_size);
    
  //Echoue
  if (!find)
    find=latent [0];
  //Russie (dpassement de bits)
  while (find>=(1<<nbit))
    BitWrite (LZW_BITPLUS,byte,start,nbit++,output);
        
  //Ecrit index ou octet
  BitWrite (find, byte, start, nbit, output);
  
  ////Ecriture code LZW_EOF
  BitWrite (LZW_EOF, byte, start, nbit, output);
  
  //Ecriture bits restant
  if (start!=0)
    fputc (byte, output);
}

//Compression mthode de compression LZW
int CompressLZW (FILE *input,FILE *output)
{
  //Ecriture de l'header
  fwrite (&DICO_SIZE, 4, 1, output);
  
  //Variables (Dictionnaire)                   
  unsigned char **DICO=(unsigned char**)malloc (sizeof (unsigned char*)*DICO_SIZE);        //Pointeur sur les chanes
  unsigned short *DICO_LEN=(unsigned short*)malloc (sizeof (unsigned short)*DICO_SIZE);    //Nombres de caractres composant une chane
  unsigned long DICO_POS;  //Position dans le dictionnaire
    
  //Tables de hachages
  Tree **HACH_TREE=(Tree **)malloc (sizeof (struct Tree)*65536);
   
  printf ("Dictionnary size: %lu\n\n",DICO_SIZE);    
  printf ("Compress in progress... 0%% achieved.");
  
  //Initialisation du dictionnaire
  LZW_Initialize (DICO, DICO_LEN, DICO_POS);
  
  //Cration du dictionnaire et compression
  LZW_Compress (DICO, DICO_LEN, DICO_POS, HACH_TREE, input, output);
    
  //Efface le dictionnaire
  LZW_DeleteDico (DICO, DICO_LEN, HACH_TREE, Mode_LZW_Compress);
      
  return -1;
}


//*************
//DECOMPRESSION
//*************
//Cration du dictionnaire et dcompression du fichier
int LZW_Uncompress (unsigned char *dico [], unsigned short dico_len [], unsigned long &dico_pos, FILE *input, FILE *output)
{  
  //Tampon
  unsigned char tampon [MAX_STR]={};
  unsigned short tampon_size=0;
  
  //Buffer
  unsigned char latent [MAX_STR]={};
  unsigned short latent_size=1;
  unsigned short nbdata;
    
  //Variables de recherche
  unsigned long find;
  
  //Variable criture fichier
  unsigned char byte=0;
  unsigned char start=0;
  
  //Variables divers
  unsigned char nbit=LZW_BITSTART;          //nbits forme un caractre,  la rencontre de BITPLUS soit -1 on augmente
  unsigned long tmp;
  
  //Affichage pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
        
  //Prpare lecture bit  bit
  byte=fgetc (input);
  
  //Caractre de dbut
  latent [0]=BitRead (byte,start,LZW_BITSTART,input);
  
  //Parcours fichier
  while (!feof (input))
  { 
    //Caractre, index ou code en cours
    tmp=BitRead (byte, start, nbit, input);
    
    //Fin du fichier
    if (feof (input)) break;
    
    //Code de fin
    if (tmp==LZW_EOF) break;
                
    //Codage CLEAR DICO
    else if (tmp==LZW_CLEAR_DICO) {
      //Vider dictionnaire
      dico_pos=DICO_START;            //Pos Dico  zro
      nbit=LZW_BITSTART;              //Codage sur 9 bits
      //printf ("\nClear dictionnary.\n");
      continue;}
      
    //Codage SP
    else if (tmp==LZW_BITPLUS) {
      nbit++;
      //printf ("SP %u - %u\n",LZW_BITPLUS,nbit);
      continue;}
           
    //Ajoute caractre ou index   
    nbdata=latent_size;
    memcpy (tampon, latent, latent_size);
    
    //Si donne pas dans le dico alors, le caractre  ajouter au buffer
	//est la latence. Se produit quand succession du mme caractre
	if (tmp==dico_pos)
      tampon [nbdata]=latent [0];
    //Code ASCII ou dfinition
    else if (tmp<dico_pos)
      tampon [nbdata]=dico [tmp][0];
    //Erreur
    else {
      printf ("\n\nError: Unknown index %lu.\n",tmp);
      return 14;}
    
    //Taille du tampon    
    tampon_size=nbdata+1;
    
    //Ecrire tampon dans le dictionnaire
    LZW_DicoWrite (dico, dico_len, dico_pos, NULL, tampon, tampon_size, Mode_LZW_Uncompress);
        
    //On crit les caractres latent dans le fichier de sortie
    fwrite (latent, 1, nbdata, output);
    purcent=((unsigned long long)(k+=nbdata)*100)/TPE_FILE.size;
    
    //Nouveau buffer latent
    memcpy (latent, dico [tmp], dico_len [tmp]);
    latent_size=dico_len [tmp];
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rUncompress in progress... %u%% achieved.", purcent);}
  }
  
  //Erreur LZW_EOF
  if (tmp!=LZW_EOF) {
    printf ("\n\nError: Abnormal terminated file, no code LZW_EOF.\n");
    return 15;}
  
  //Caractre(s) latent restant
  fwrite (latent, 1, latent_size, output);
    
  //Affiche pourcentage restant
  purcent=((unsigned long long)(k+=latent_size)*100)/TPE_FILE.size;
  printf ("\rUncompress in progress... %u%% achieved.", purcent);
  
  return -1;
}

//Dcompression mthode de compression LZW
int UncompressLZW (FILE *input,FILE *output)
{
  //Lecture de l'header
  fread (&DICO_SIZE, 4, 1, input);
  
  //Variables (Dictionnaire)                            
  unsigned char **DICO=(unsigned char**)malloc (sizeof (unsigned char*)*DICO_SIZE);        //Pointeur sur les chanes
  unsigned short *DICO_LEN=(unsigned short*)malloc (sizeof (unsigned short)*DICO_SIZE);    //Nombres de caractres composant une chane
  unsigned long DICO_POS;  //Position dans le dictionnaire
  
  //Erreur retourne?
  int error;
  
  printf ("Dictionnary size: %lu\n\n",DICO_SIZE);
  printf ("Uncompress in progress... 0%% achieved.");
  
  //Initialisation du dictionnaire
  LZW_Initialize (DICO, DICO_LEN, DICO_POS);
  
  //Cration du dictionnaire et dcompression du fichier
  error=LZW_Uncompress (DICO, DICO_LEN, DICO_POS, input, output);
  if (error!=-1) {
    //Libre la mmoire allou pour le dictionnaire
    LZW_DeleteDico (DICO, DICO_LEN, NULL, Mode_LZW_Uncompress);
    return error;}
  
  //Efface le dictionnaire
  LZW_DeleteDico (DICO, DICO_LEN, NULL, Mode_LZW_Uncompress);
   
  return -1;
}


//*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-
//Recherche de divers paramtres
//-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
int LZW_SearchParameters (int argc, char *argv[])
{
  //Taille par dfaut
  unsigned long size=DEFAULT_DICO_SIZE;
  
  //Parcours arguments
  for (int i=1; i<argc; i++)
  {
    //Argument trouv
    if (!strncmp (StrCnvL (argv [i]), "/dico_size=", 11))
    {
      //Recherche nombre
      size=StrToInt (argv [i]+11, strlen (argv [i]+11));
      
      break;
    }
  }
  
  //Erreur argument
  if (size<512) {
    cerr << "Error: Incorrect parameter DICO_SIZE.\n";
    return 18;}
  
  //Assignation de la taille du dictionnaire
  DICO_SIZE=size;
  
  //Aucune erreur
  return -1;
}
