//Algorithme de compression et de dcompression Huffman
#include "Header.h"
#include "fonctions.h"
#include "huffman.h"

using namespace std;

//Efface la table des frquences
void HUFF_ClearTable (H_ASCII *ptr_table, unsigned short ASCII_MAX)
{
  //Parcours code ASCII sur 1 octets soit 0  255
  for (int i=0; i<ASCII_MAX; i++) {
    ptr_table [i].freq=0;
    ptr_table [i].codifie=false;
    
    ptr_table [i].donnee.noeud=false;
    ptr_table [i].donnee.ascii_code=i;
    ptr_table [i].code=0;
    ptr_table [i].bits=0;}
}

//Remplie la table des frquences
void HUFF_MakeFreq (H_ASCII *Table_ASCII, unsigned short &DimAscii, FILE *input)
{
  unsigned char c;
  DimAscii=0;
  
  //Variables pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
  
  //Parcours fichier
  while (!feof (input))
  {
    //Caractre en cours
    c=fgetc (input);
    
    //Fin du fichier
    if (feof (input)) break;
    
    //Ajoute frquence
    if (!((Table_ASCII [c]).freq)++) DimAscii++;
    
    //Affichage pourcentage
    purcent=((unsigned long long)++k*100)/TPE_FILE.size;
    
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rCreate and sort table of frequency. %u%% achieved.",purcent);}
  }
  
  //Repositionne au dbut du fichier
  fseek (input, 0, SEEK_SET);
}


//Echange de donnes
void HUFF_Swap(H_ASCII *a, H_ASCII *b)
{
   H_ASCII temp;
   temp = *a;
   *a = *b;
   *b = temp;
}

//Trie les frquences par ordre dcroissant
void HUFF_SortTable (H_ASCII *ptr_table, unsigned short ASCII_MAX)
{
  BOOL permut=true;
  unsigned short start=0;
  unsigned short endpermut=0;
  int i;
  
  //Tant qu'il y a des donnes  trier
  while (permut==true)
  {
    //Parcours table  l'envers
    for (permut=false, i=(ASCII_MAX-1); i>start; i--)
    {
      //Trier
      if (ptr_table [i].freq>ptr_table [i-1].freq)
      {
        //Echange l'ordre
        HUFF_Swap ((ptr_table+i),(ptr_table+i-1));
        permut=true;
        endpermut=(unsigned char)i;
      }
    }
    
    start=endpermut;
  }
} 

//Cration de l'arbre
int HUFF_MakeTree (H_ASCII *Table_ASCII, unsigned short DimAscii, H_Tree **PtrRacine)
{
  H_ASCII tmp_table;           //Table temporaire
  H_Tree *PtrNoeud;
  
  BOOL insert;
  unsigned short index;
  unsigned short i, j;
  
  //Parcours frquences ASCII ordre croissant
  for (i=DimAscii-1; i>0; i--)
  {
    //Allocation pour noeud
    PtrNoeud=(H_Tree *)malloc (sizeof (H_Tree));
    PtrNoeud->FGauche=(H_Tree *)malloc (sizeof (H_Tree));
    PtrNoeud->FDroite=(H_Tree *)malloc (sizeof (H_Tree));
        
    //Erreur out of memory
    if (PtrNoeud==NULL) return 0;
    
    //Partie droite (plus petite frquence)
    memcpy (PtrNoeud->FDroite, &Table_ASCII [i].donnee, sizeof (H_Tree));
    //Partie gauche (plus grande frquence)
    memcpy (PtrNoeud->FGauche, &Table_ASCII [i-1].donnee, sizeof (H_Tree));
    
    //Cumul des donnes
    //Ajoute les frquences
    tmp_table.freq=Table_ASCII [i].freq+Table_ASCII [i-1].freq;
    tmp_table.donnee.noeud=true;
    tmp_table.donnee.ptr=PtrNoeud;
    
    //Reclassement du noeud dans la table
    for (j=i, insert=false; (j>0) && (!(insert)); j--)
      //Redfinition de la table ASCII (enleve item)
      if (Table_ASCII [j-1].freq < tmp_table.freq)
        *(Table_ASCII+j)=*(Table_ASCII+j-1);
      else {
        insert=true;
        index=j;}
    
    if (!insert) index=0;
    
    //Combine ASCII
    *(Table_ASCII+index)=tmp_table;
  }
  
  //Cration du pointeur vers la racine de l'arbre
  *PtrRacine=PtrNoeud;
  
  //Pas d'erreur
  return -1;
}

//Suppression d'un arbre de huffman.
H_Tree *HUFF_DeleteTree (H_Tree *arbre)
{
  if (arbre->noeud)
  {
    if (arbre->FGauche) arbre->FGauche=HUFF_DeleteTree (arbre->FGauche);
    if (arbre->FDroite) arbre->FDroite=HUFF_DeleteTree (arbre->FDroite);
    free (arbre);
  }
  
  return NULL;
}

//Cration du codage des caractres
void HUFF_CreateCode (H_ASCII *Table_ASCII, H_Tree *arbre)
{
  unsigned long code;
  unsigned char bits;
  
  //--Partie droite--
  code=arbre->code;
  bits=arbre->bits;
  code|=(1<<bits++);
  //Noeud
  if (arbre->FDroite->noeud==true)
  {
    //Code prcdent
    arbre->FDroite->ptr->code=code;
    arbre->FDroite->ptr->bits=bits;
    //Codage du noeud
    HUFF_CreateCode (Table_ASCII, arbre->FDroite->ptr);
  }
  //Fin de la branche
  else
  {
    //Ajoute code
    Table_ASCII [arbre->FDroite->ascii_code].code=code;
    Table_ASCII [arbre->FDroite->ascii_code].bits=bits;
    //Codification finie
    Table_ASCII [arbre->FDroite->ascii_code].codifie=true;
  }
  
  //--Partie gauche--
  code=arbre->code;
  bits=arbre->bits;
  code&=~(1<<bits++);
  if (arbre->FGauche->noeud==true)
  {
    //Code prcdent
    arbre->FGauche->ptr->code=code;
    arbre->FGauche->ptr->bits=bits;
    //Codage du noeud
    HUFF_CreateCode (Table_ASCII, arbre->FGauche->ptr);
  }
  //Fin de la branche
  else
  {
    //Ajoute code
    Table_ASCII [arbre->FGauche->ascii_code].code=code;
    Table_ASCII [arbre->FGauche->ascii_code].bits=bits;
    //Codification finie
    Table_ASCII [arbre->FGauche->ascii_code].codifie=true;
  }
}

//Inversion du code
void HUFF_InvertCode (H_ASCII *Table_ASCII, unsigned short DimAscii, unsigned short ASCII_MAX)
{
  unsigned long code=0;
  
  //Parcours caractres
  for (int i=0; i<ASCII_MAX; i++, code=0)
  {
    //Reconstitution du code
    if (Table_ASCII [i].codifie) 
    {
      //Parcours code
      for (int j=0; j<Table_ASCII [i].bits; j++)
        BitPoke (code, BitPeek (Table_ASCII [i].code, j), Table_ASCII [i].bits-j-1);
        
      //Attribution du code  
      Table_ASCII [i].code=code;
    }
  }
}

//Cration de la table de correspondance de caractres dans le fichier
void HUFF_CreateTableInFile (H_ASCII *ptr_table, unsigned short DimAscii, unsigned short ASCII_MAX, FILE *file, unsigned char &EndByte, unsigned char &EndStart)
{
  //Format de la table:
  //-------------------
  //1er octet=Nombre de caractre-1
  
  //4 Octets = Taille du fichier d'origine
  //8 Bits= Numro du caractre
  //5 bits = Nombres de bits pour code de huffman-1
  //variable = Code de Huffman
  //Donnes sans repositionnement sur un octet
  
  //Variables fichier
  unsigned char start=0;
  unsigned char byte=0;
   
  //Nombres de caractres
  fputc ((unsigned char)(DimAscii-1), file);
        
  //Parcours caractre
  for (int i=0; i<ASCII_MAX; i++)
  {
    //Caractre codifi
    if (ptr_table [i].codifie==true)
    {
      //Numro du caractre
      BitWrite (i,byte,start, 8, file);
      //Nombres de bits code huffman
      BitWrite (ptr_table [i].bits-1, byte, start, 5, file);
      //Code de Huffman
      BitWrite (ptr_table [i].code, byte, start, ptr_table [i].bits, file);
    }
  }
    
  //Valeurs suivante pour l'criture
  EndByte=byte;
  EndStart=start;
}

//Ecriture des donnes dans le fichier de destination
void HUFF_WriteDataInFile (H_ASCII *ptr_table, FILE *input, FILE *output, unsigned char EndByte, unsigned char EndStart)
{
  //Variable fichier
  unsigned char byte=EndByte;
  unsigned char start=EndStart;
  unsigned short ascii_code;
  
  //Variables pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
  
  //Parcours fichier
  while (!feof (input))
  {
    ascii_code=fgetc (input);
    
    //Fin du fichier source
    if (feof (input)) break;
    
    //Ecriture du code de Huffman
    BitWrite (ptr_table [ascii_code].code, byte, start, ptr_table [ascii_code].bits, output);
  
    //Affichage pourcentage
    purcent=((unsigned long long)++k*100)/TPE_FILE.size;
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rWrite data with Huffman code. %u%% achieved.", purcent);}
  }
  
  //Octet restant
  if (start!=0)
    //Ecriture octet
    fputc (byte, output);
}

//Compression methode de Huffman
int CompressHuffman (FILE *input,FILE *output)
{  
  //Table ASCII final trie
  H_ASCII *Table_ASCII=(H_ASCII *)malloc (sizeof (H_ASCII)*H_ASCII_SIZE);
  
  //Variables
  unsigned short DimAscii;        //Nombres de caractres...
  H_Tree *Racine;                 //Pointeur racine de l'arbre
  unsigned char EndTableByte;     //Octet de fin de la table
  unsigned char EndTableStart;    //Dbut de l'octet de fin de la table
     
  //Efface la table de frquences
  HUFF_ClearTable (Table_ASCII, H_ASCII_SIZE);
  
  printf ("Compress in progress...\n\n");
  
  //Table de frquences
  printf ("Create and sort table of frequency. 0%% achieved.");
  HUFF_MakeFreq (Table_ASCII, DimAscii, input);
  //Tri les frquences par ordre dcroissant
  HUFF_SortTable (Table_ASCII, H_ASCII_SIZE);
  
  //Erreur 1 caractre connue dans le fichier
  if (DimAscii<=1) {
    cerr << "\nImpossible to compress input file, because Huffman method is not exploitable.\n\n";
    free (Table_ASCII);
    //Racine=HUFF_DeleteTree (Racine);
    return 16;}  
        
  //Cration de l'arbre
  printf ("\nMake Tree of Huffman.\n");
  if (!HUFF_MakeTree (Table_ASCII, DimAscii, &Racine)) {
    cerr << "\nError: Out of memory.\n\n";
    free (Table_ASCII);
    //Racine=HUFF_DeleteTree (Racine);
    return 17;}
      
  //Cration du codage
  printf ("Create code table.\n");
  Racine->code=0; Racine->bits=0;
  HUFF_CreateCode (Table_ASCII, Racine);
  //HUFF_InvertCode (Table_ASCII, DimAscii, H_ASCII_SIZE);
  
  HUFF_CreateTableInFile (Table_ASCII, DimAscii, H_ASCII_SIZE, output, EndTableByte, EndTableStart);
  
  //Ce repositionne sur un octet
  printf ("Write data with Huffman code. 0%% achieved.");
  HUFF_WriteDataInFile (Table_ASCII, input, output, EndTableByte, EndTableStart); 

  /*for (int i=0; i<256; i++)
  {
    if (Table_ASCII [i].codifie)
    {
      printf ("%u - %u - %lu\n", i, Table_ASCII [i].bits, Table_ASCII [i].code);
    }
  }*/

  //Efface arbre de Huffman
  //Racine=HUFF_DeleteTree (Racine);
  free (Table_ASCII);
  
  return -1;
}

//*******************
//-- DECOMPRESSION --
//*******************

//Lecteur de la table ASCCI contenu dans le fichier
void HUFF_ReadTableInFile (H_ASCII *ptr_table, unsigned short &DimAscii, FILE *file, unsigned char &EndByte, unsigned char &EndStart)
{
  unsigned char byte=0;
  unsigned char start=0;
  
  //Variables temporaire de gestion de la table
  unsigned char charn;
  unsigned char huffbit;
  unsigned long huffcode;
    
  //Nombre de caractres
  DimAscii=(unsigned char)fgetc (file)+1;
  byte=(unsigned char)fgetc (file);
  
  //Parcours la table
  for (int i=0;i<DimAscii;i++)
  {
    //8 bits= Numro du caractre
    //5 bits = Nombres de bits pour code de huffman-1
    //variable = Code de Huffman
    //Donnes sans repositionnement sur un octet
    
    charn=BitRead (byte, start, 8, file);
    huffbit=BitRead (byte, start, 5, file)+1;
    huffcode=BitRead (byte, start, huffbit, file);
    
    (ptr_table+charn)->codifie=true;            //Caractre codifie
    (ptr_table+charn)->code=huffcode;           //Code de Huffman
    (ptr_table+charn)->bits=huffbit;            //Nombre de bit pour code de Huffman
  }
  
  //Valeurs suivantes pour la lecture des codes de Huffman (des donnes)
  EndByte=byte;
  EndStart=start;
}

//Cration de l'arbre de Huffman pour la dcompression
void HUFF_CreateUncompressTree (H_ASCII *ptr_table, unsigned short ASCII_MAX, H_Tree **PtrRacine)
{
  //Pointeur temporaire
  H_Tree *ptr;
  H_Tree *tmp;
    
  //Parcours des caractres ASCII
  for (int i=0; i<ASCII_MAX; i++)
  {
    //Le caractre existe
    if ((ptr_table+i)->codifie==true)
    {      
      //Reviens  la racine
      ptr=*PtrRacine;
            
      //Parcours binaire du code de Huffman du caractre
      for (int j=0; j<(ptr_table+i)->bits; j++)
      {
        //Bit  1
        if (BitPeek ((ptr_table+i)->code, j))
        {
          //Cration d'une feuille Droite
          //Pas encore arriv  la fin du code de Huffman
          if (j==((ptr_table+i)->bits-1))
          {
            //Code ASCII correspondant  la feuille
            ptr->FDroite->ascii_code=i;
          
            //Ce n'est pas un noeud
            ptr->FDroite->noeud=false;
          }
          //C'est encore un noeud
          else
          {
            //Noeud inexistant
            if (ptr->FDroite->ptr==NULL)
            {
              //Allocation de mmoire
              tmp=(H_Tree *) malloc (sizeof (H_Tree));
              tmp->FGauche=(H_Tree *)malloc (sizeof (H_Tree));
              tmp->FDroite=(H_Tree *)malloc (sizeof (H_Tree));
              ptr->FDroite->ptr=tmp;
              ptr->FDroite->noeud=true;
                            
              //Initialisation du pointeur
              tmp->FDroite->ptr=NULL;
              tmp->FGauche->ptr=NULL;
              ptr=tmp;
            }
            else
              ptr=ptr->FDroite->ptr;
          }
        }
        //Bit  0
        else
        {
          //Cration d'une feuille Gauche
          //Pas encore arriv  la fin du code de Huffman
          if (j==((ptr_table+i)->bits-1))
          {
            //Code ASCII correspondant  la feuille
            ptr->FGauche->ascii_code=i;
            
            //Ce n'est pas encore un noeud
            ptr->FGauche->noeud=false;
          }
          //C'est encore un noeud
          else
          {
            //Noeud inexistant
            if (ptr->FGauche->ptr==NULL)
            {
              //Allocation de mmoire
              tmp=(H_Tree *) malloc (sizeof (H_Tree));
              tmp->FGauche=(H_Tree *)malloc (sizeof (H_Tree));
              tmp->FDroite=(H_Tree *)malloc (sizeof (H_Tree));
              ptr->FGauche->ptr=tmp;
              ptr->FGauche->noeud=true;
              
              //Initialisation du pointeur
              tmp->FDroite->ptr=NULL;
              tmp->FGauche->ptr=NULL;
              ptr=tmp;  
            }
            else
              ptr=ptr->FGauche->ptr;
          }
        }
      }
    }
  }
}

//Lecture des donnes et criture dans le fichier dcompress
void HUFF_WriteUncompressData (H_ASCII *ptr_table, H_Tree *ptr_arbre, FILE *input, FILE *output,unsigned char EndByte, unsigned char EndStart)
{
  //Arbre temporaire
  H_Tree *ptr;
  ptr=ptr_arbre;
  
  //Compteur d'octet
  unsigned long counter=0;
  
  //Caractre de dpart
  unsigned char byte=EndByte;
  unsigned char start=EndStart;
  
  unsigned char bit;
  
  unsigned char purcent=0, purcent2=0;
  
  //Tant que fin du fichier d'entre ou fin de la taille relle!
  while (!feof (input) && (counter!=TPE_FILE.size))
  {    
    //Lecture d'un bit
    bit=BitRead (byte,start, 1, input);
    
    //Feuille droite
    if (bit)
    {
      //Si c'est un noeud
      if (ptr->FDroite->noeud==true)
        ptr=ptr->FDroite->ptr;
      //Fin de la feuille
      else
      {
        //Ecriture de l'octet
        fputc (ptr->FDroite->ascii_code, output);
        counter++;
        //Reviens au dbut de l'arbre soit la racine
        ptr=ptr_arbre;
      }
    }
    //Feuille Gauche
    else
    {
      //Si c'est un noeud
      if (ptr->FGauche->noeud==true)
        ptr=ptr->FGauche->ptr;
      //Fin de la feuille
      else
      {
        //Ecriture de l'octet
        fputc (ptr->FGauche->ascii_code, output);
        counter++;
        //Reviens au dbut de l'arbre soit la racine
        ptr=ptr_arbre;
      }
    }
    
    //Affichage pourcentage
    purcent=((unsigned long long)counter*100)/TPE_FILE.size;
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rRead input file and write data in uncompress file. %u%% achieved.",purcent);}
  }
}

//Dcompression mthode de compression Huffman
int UncompressHuffman (FILE *input,FILE *output)
{
  //Table ASCII interne au fichier
  H_ASCII *Table_ASCII=(H_ASCII *)malloc (sizeof (H_ASCII)*H_ASCII_SIZE);
  
  //Variables
  unsigned short DimAscii;        //Nombres de caractres...
  H_Tree *Racine;                 //Pointeur racine de l'arbre
  unsigned char EndTableByte;     //Octet de fin de la table
  unsigned char EndTableStart;    //Dbut de l'octet de fin de la table
  
  //Allocation racine de l'arbre
  Racine=(H_Tree *) malloc (sizeof (H_Tree));
  Racine->FGauche=(H_Tree *) malloc (sizeof (H_Tree));
  Racine->FDroite=(H_Tree *) malloc (sizeof (H_Tree));
  Racine->FGauche->ptr=NULL;
  Racine->FDroite->ptr=NULL;
  
  //Vide la table
  HUFF_ClearTable (Table_ASCII, H_ASCII_SIZE);
  
  printf ("Uncompress in progress... \n\n");
  
  //Lecture de la table
  printf ("Read ASCII table.\n");
  HUFF_ReadTableInFile (Table_ASCII, DimAscii, input, EndTableByte, EndTableStart);
  //HUFF_InvertCode (Table_ASCII, DimAscii);
       
  //Cration de l'arbre
  printf ("Make Tree of Huffman.\n");
  HUFF_CreateUncompressTree (Table_ASCII, H_ASCII_SIZE, &Racine);
  
  //Lecture du fichier et criture dans output
  printf ("Read input file and write data in uncompress file. 0%% achieved.");
  HUFF_WriteUncompressData (Table_ASCII, Racine, input, output, EndTableByte, EndTableStart);

  //Efface arbres
  //Racine=HUFF_DeleteTree (Racine);
  free (Table_ASCII);
  
  return -1;
}
