#include "Header.h"
#include "fonctions.h"
#include "ArbreBin.h"

#include "huffman.h"
#include "LZW.h"
#include "LZSS.h"
#include "RLE2.h"
#include "LZH.h"
#include "LZ77.h"
#include "ARITH.h"
#include "AFE.h"
#include "huffman2.h"

using namespace std;

//Dfinitions des Headers
struct _TPE_FILE TPE_FILE;
struct _LZW_HEADER LZW_HEADER;
struct _LZSS_HEADER LZSS_HEADER;
struct _RLE2_HEADER RLE2_HEADER;

//Dclaration de prototypes:
int CompressFile (const char *input, const char *output, const char *method, int argc, char *argv[]); //Compression
int UncompressFile (const char *input, const char *output); //Dcompression

//RLE (Run Length Encoding)
int CompressRLE (FILE *input, FILE *output);
int UncompressRLE (FILE *input, FILE *output);

//TPE (Format Personnalis bas sur une variante du RLE)
int CompressTPE (FILE *input, FILE *output);
int UncompressTPE (FILE *input, FILE *output);

//Programme principal (Gestion paramtres)
int main(int argc, char *argv[])
{
  int i;
 
  char *input_file=NULL;
  char *output_file=NULL;
  char *method=NULL;
  int value;
  
  //output_file tmp
  const char buffer[50]={};
  
  char *ext;

  //Efface cran affiche texte
  //clrscr();
  system ("CLS");
  printf ("Compressor and uncompressor - version 1.36\n");
  printf ("Copyright 2004 by ANNEHEIM Geoffrey and MONCHAMPS Sebastien\n\n");
  printf ("Usage: source file [destination file] /c or /u [/method]\n\n");
  printf ("/c = compress file with method parameter.\n");
  printf ("/u = uncompress file, method parameter is omit.\n\n");
  printf ("Methods: \n");
  printf ("-------- \n");
  printf ("RLE   = Compress with a technology RLE.\n");
  printf ("RLE2  = Hybride RLE method.\n");
  printf ("TPE   = Compress with personnal method.\n");
  printf ("HUFF  = Compress with algorithme HUFFMAN.\n");
  printf ("HUFF2 = Compress with progressif HUFFMAN.\n");
  printf ("LZW   = Compress with method LZW (Lempel-Ziv Welch).\n");
  printf ("LZ77  = Compress with method LZ77 (Lempel-Ziv 1977).\n");
  printf ("LZSS  = Compress with method LZSS (Lempel-Ziv Storer Szymanski).\n");
  printf ("LZH   = Compress with methods LZSS + Huffman.\n");
  printf ("ARITH = Arithmetic codage.\n");
  printf ("AFE   = Adaptative Frequence Encoding.\n\n");
  
  //Parcours paramtres
  for (i=1;i<argc;i++)
  {
   //Mthode de compression
   if (strncmp (StrCnvL (argv [i]),"/c",2)==0)
   {
    //Find input File and Output File
    for (int j=1; j<argc; j++)
    {
     //Si different d'un paramtre indique un fichier
     if (strncmp (argv [j],"/",1)!=0)
     {
       if ((input_file!=NULL) && (output_file==NULL)) output_file=argv[j];
       else if (input_file==NULL) input_file=argv[j];
     }

     //Find Method (Si diffrent de /c)
     //Recherche mthode
     if (!strncmp (argv [j],"/",1) && (j!=i) && (method==NULL))
     {
       //Parcours liste
       for (int k=0; k<method_n; k++)
       {
         //Si paramtre!
         if (!strncmp (StrCnvL (argv [j]+1),method_lst [k], strlen (method_lst [k])))
           method=(char *)(StrCnvL (argv [j]+1));
       }
     }
    }
    
    //Vrification des paramtres
    //Pas de fichier d'entr
    if (input_file==NULL) {
      cerr << "Error: No input file.\n"; system ("PAUSE"); return 1;}
    //Aucune mthode de compression
    if (method==NULL) {
      cerr << "Error: No method specified.\n"; system ("PAUSE"); return 2;}
    
    //Aucun fichier destination
    if (output_file==NULL)
    {
      //Recherche extension
      output_file=strrchr (input_file,'.');
      
      //Fichier sans extension
      if (output_file==NULL) {
        strncpy ((char *)(buffer),input_file,strlen (input_file));
        strcat ((char *)(buffer),".tpe");}
      else {
        strncpy ((char *)(buffer),input_file,strlen (input_file)-strlen (output_file));
        strcat ((char *)(buffer),".tpe");}
      
      output_file=(char *)(buffer);
    }
    
    //Compression de fichier
    value=CompressFile (input_file, output_file, method, argc, argv);
    system ("PAUSE");
    return value;
   }
   //Mthode de dcompression
   else if (strncmp (StrCnvL (argv [i]),"/u",2)==0)
   {
    //Find input File and Output File
    for (int j=1;j<argc;j++)
    {
     //Si different d'un paramtre indique un fichier
     if (strncmp (argv [j],"/",1)!=0)
     {
       if ((input_file!=NULL) && (output_file==NULL)) output_file=argv[j];
       else if (input_file==NULL) input_file=argv[j];
     }
    }
    
    //Vrification des paramtres
    //Pas de fichier d'entr
    if (input_file==NULL) {
      cerr << "Error: No input file.\n"; system ("PAUSE"); return 1;}
       
    //Dcompresson d'un fichier
    value=UncompressFile (input_file, output_file);
    system ("PAUSE");
    return value;
   }
  }
  
  //Erreur commandes inconnus
  if (i==argc) {
    cerr << "Error: Unknown commands.\n";
    system ("PAUSE"); 
    return 3;}

  //Attente appuie sur une touche
  system ("PAUSE");
  return -1;
}

//Compresse un fichier suivant la mthode de compression voulue
int CompressFile (const char *input, const char *output, const char *method, int argc, char *argv[])
{
  int error;
  
  //Tailles fichiers
  unsigned long input_size,output_size;
  
  //Extension
  static char ext[8]={};
  char *tmp;
  unsigned char compress;
  
  //Variables fichiers
  FILE *file_input;
  FILE *file_output;
    
  //Mthode de compression non trouve
  if (strncmp (method,"rle2",4)==0) compress=RLE2;
  else if (strncmp (method,"huff2",5)==0) compress=HUFF2;
  else if (strncmp (method,"tpe",3)==0) compress=TPE;
  else if (strncmp (method,"huff",4)==0) compress=HUFF;
  else if (strncmp (method,"lzw",3)==0) compress=LZW;
  else if (strncmp (method,"lzss",4)==0) compress=LZSS;
  else if (strncmp (method,"rle",3)==0) compress=RLE;
  else if (strncmp (method,"lzh",3)==0) compress=LZH;
  else if (strncmp (method,"lz77",4)==0) compress=LZ77;
  else if (strncmp (method,"arith",5)==0) compress=ARITH;
  else if (strncmp (method,"afe",3)==0) compress=AFE;
  else {
    cerr << "Error: Incorrect method parameter.\n";
    return 4;}
  
  //Recherche extension
  tmp=strrchr (input,'.');
  if (tmp==NULL) {
    cerr << "Error: The input file has not extension.\n";
    return 12;}
  
  //Si extension
  if (tmp) {
    strncpy ((char *)(ext),tmp+1,strlen (tmp)-1);
    //Fin de string
    ext [strlen (tmp)]=0;}
  
  //Fichiers identiques
  if (!strcmp (output,input)) {
    cerr << "Error: The input file and output file are the same ones.\n";
    return 13;}
    
  //Ouverture des fichiers
  //FILES STREAM  
  file_input=fopen (input,"rb");               //Lecture seule (BINAIRE)
  if (!file_input) {
    cerr << "Error: Impossible to open the input file.\n";
    return 5;}
  
  //Fichier vide  
  if (!FileSize (file_input)) {
    fclose (file_input);
    cerr << "Error: The input file is empty.\n";
    return 11;}
          
  file_output=fopen (output,"wb");
  if (!file_output) {
    fclose (file_input);
    cerr << "Error: Impossible to create the destination file.\n";
    return 6;}
    
  //Ecriture de l'HEADER
  //Prpare Header
  memcpy (&TPE_FILE.header,"HTPE",4);
  TPE_FILE.compress=compress;
  TPE_FILE.extension_size=strlen (ext);
  TPE_FILE.size=FileSize (file_input);
    
  //Ecriture de l'Header
  fwrite (&TPE_FILE.header, sizeof (TPE_FILE.header), 1, file_output);
  fwrite (&TPE_FILE.compress, sizeof (TPE_FILE.compress), 1, file_output);
  fwrite (&TPE_FILE.extension_size, sizeof (TPE_FILE.extension_size), 1, file_output);
  fwrite (ext,strlen (ext),1,file_output);
  fwrite (&TPE_FILE.size, sizeof (TPE_FILE.size), 1, file_output);
    
  //***********
  //COMPRESSION
  //***********
  //Compression -- RLE --
  if (compress==RLE) 
    error=CompressRLE (file_input, file_output);
    
  //Compression TPE
  if (compress==TPE)
    error=CompressTPE (file_input, file_output);
    
  //Compression HUFFMAN
  if (compress==HUFF)
    error=CompressHuffman (file_input, file_output);
    
  //Compression LZW (Lempel-Ziv Welch)
  if (compress==LZW) 
  {
    //Recherche paramtres
    error=LZW_SearchParameters (argc, argv);
    
    //Si tout s'est bien pass
    if (error==-1) 
      error=CompressLZW (file_input, file_output);
  }
  
  //Compression LZSS
  if (compress==LZSS)
  {
    //Recherche paramtres
    error=LZSS_SearchParameters (argc, argv);
    
    //Si tout s'est bien pass  
    if (error==-1)
      error=CompressLZSS (file_input, file_output);
  }
  
  //Compression RLE2
  if (compress==RLE2) 
  {
    //Recherche paramtres
    error=RLE2_SearchParameters (argc, argv);
    
    //Si tout s'est bien pass
    if (error==-1)
      error=CompressRLE2 (file_input, file_output);
  }
  
  //Compression LZH
  if (compress==LZH)
  {
    //Recherche paramtres
    error=LZH_SearchParameters (argc, argv);
    
    //Si tout s'est bien pass
    if (error==-1)
      error=CompressLZH (file_input, file_output);
  }
  
  //Compression LZ77
  if (compress==LZ77)
  {
    //Recherche paramtres
    error=LZ77_SearchParameters (argc, argv);
    
    //Si tout s'est bien pass
    if (error==-1)
      error=CompressLZ77 (file_input, file_output);
  }
  
  //Compression Arithmtique
  if (compress==ARITH)
    error=CompressARI (file_input, file_output);
    
  //Compression AFE
  if (compress==AFE)
    error=CompressAFE (file_input, file_output);
    
  //Compression Huffman progressif
  if (compress==HUFF2)
    error=CompressHuffman2(file_input, file_output);
        
  //Une erreur est signale  
  if (error!=-1) {
    fclose (file_input);
    fclose (file_output);
    cerr << "Error: Input file no valid or abnormal terminated compression.\n";
    return error;}       
  
  //Affiche rapport de compression
  if (error==-1)
  {
    //Taille des fichiers
    input_size=FileSize (file_input);
    output_size=FileSize (file_output);
  
    //Affiche rapport
    printf ("\n\nOriginal size: %lu octets     Final size: %lu octets\n",input_size,output_size);
    printf ("Gain: %ld octets\n",input_size-output_size);
    printf ("Ratio: %ld%%\n",100-(((unsigned long long)output_size*100)/input_size));
  }
  
  //Erreur de fermeture
  if ((fclose (file_input)) || (fclose (file_output))) {
    cerr << "Error: Abnormal terminated processing.\n";
    return 8;}   
  
  printf ("\nEnd compression with no error!\n");
  return -1;
}

//Dcompresse un fichier
int UncompressFile (const char *input, const char *output)
{
  int error;
  
  //Variables Header
  unsigned char header[5]={};
  short method;
  short extension_size;
  
  //Buffer fichier de destination
  const char buffer[50]={};
       
  //FILES STREAM  
  FILE *file_input=fopen (input,"rb");               //Lecture seule (BINAIRE)
  if (!file_input) {
    cerr << "Error: Impossible to open the input file.\n";
    return 5;}
    
  //Fichier vide  
  if (!FileSize (file_input)) {
    fclose (file_input);
    cerr << "Error: The input file is empty.\n";
    return 11;}  
  
  //Lecture de l'Header
  fread ((char *)(header),4,1,file_input);
  
  //Vrification de l'header
  if (strcmp ((char *)(header),"HTPE")!=0) {
    cerr << "Error: Format of input file is not valid.\n";
    return 9;}
  
  //Methode de compression
  method=fgetc (file_input);
  
  //Taille de l'extension
  extension_size=fgetc (file_input);
  
  //Vrification fichier de destination
  if (output==NULL)
  {
    output=strrchr (input,'.');
    strncpy ((char *)(buffer),input,strlen (input)-strlen (output));
    strcat ((char *)(buffer),".");
    fread ((char *)(buffer+strlen (buffer)),extension_size,1,file_input);
  }
  //Avance dans le fichier
  else {
    fseek (file_input,extension_size,SEEK_CUR);
    
    //Fichier personnel
    strcpy ((char *)buffer, output);}
  
  //Fichiers identiques
  if (!strcmp (output,input)) {
    fclose (file_input);
    cerr << "Error: The input file and output file are the same ones.\n";
    return 13;}
    
  //Ouverture du fichier de destination
  FILE *file_output=fopen (buffer,"wb");
  if (!file_output) {
    fclose (file_input);
    cerr << "Error: Impossible to create the destination file.\n";
    return 6;}
  
  //Lecture Header
  fread (&TPE_FILE.size, 4, 1, file_input); 
   
  //Methode de compression
  // -- RLE --
  if (method==RLE)
    error=UncompressRLE (file_input, file_output);
    
  //-- TPE --
  else if (method==TPE)
    error=UncompressTPE (file_input, file_output);

  //-- HUFFMAN --
  else if (method==HUFF)
    error=UncompressHuffman (file_input, file_output);
    
  //-- LZW --
  else if (method==LZW)
    error=UncompressLZW (file_input, file_output);
    
  //-- LZSS --
  else if (method==LZSS)
    error=UncompressLZSS (file_input, file_output);
    
  //-- RLE2 --
  else if (method==RLE2)
    error=UncompressRLE2 (file_input, file_output);
    
  //-- LZH --
  else if (method==LZH)
    error=UncompressLZH (file_input, file_output);
    
  //-- LZ77 --
  else if (method==LZ77)
    error=UncompressLZ77 (file_input, file_output);
    
  //-- ARITHMETIQUE --
  else if (method==ARITH)
    error=UncompressARI (file_input, file_output);
  
  //-- AFE --
  else if (method==AFE)
    error=UncompressAFE (file_input, file_output);
  
  //-- HUFF2 --
  else if (method==HUFF2)
    error=UncompressHuffman2 (file_input, file_output);
  
  else {
    fclose (file_input); fclose (file_output);
    cerr << "Error: Unknow method of compression.\n";
    return 10;}  
    
  //Erreur
  if (error!=-1) {
    fclose (file_input);
    fclose (file_output);
    cerr << "Error: Input file no valid or abnormal terminated uncompression.\n";
    return error;}
    
  //Affiche rapport
  if (error==-1)
  {
    //Rapport
    printf ("\n\nCompress size: %lu octets \n",FileSize (file_input));
    printf ("Uncompress size: %lu octets \n",FileSize (file_output));
  }
  
  //Erreur de fermeture
  if ((fclose (file_input)) || (fclose (file_output))) {
    cerr << "Error: Abnormal terminated processing.\n";
    return 8;}
  
  //Fin de la dcompression
  printf ("\nEnd uncompression with no error!\n");    
  return -1;
}


//***************************************
//DEBUT ALOGRITHMES DE COMPRESSION SIMPLE
//***************************************
//
//Compression du type RLE
int CompressRLE (FILE *input, FILE *output)
{
  short nbyte=0;                    //Rptition d'octets.
  short character;                  //Caractre en cours
  short rchar;                      //Repeat character
    
  //Affichage pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
           
  //Prparation de dbut (Premire octet)
  rchar=fgetc (input);
  nbyte=1;
  
  //Parcours fichier
  printf ("Compress in progress... 0%% achieved.");
  while (!feof (input))
  {
    //Octet en cours
    character=fgetc (input);
        
    //Pourcentage de progression
    purcent=((unsigned long long)++k*100)/TPE_FILE.size;
    
    //Rption d'occurences
    if (character==rchar)
    {
      nbyte++;
      
      //Dpassement de capacit
      if (nbyte==256)
      {
        //Octet occurence
        fputc (255,output);
        //Octet caractre
        fputc (rchar,output);
        
        //Prpare occurence suivante
        nbyte=1;
      }
    }
    //Fin occurence
    else
    {
      //Octet occurence
      fputc (nbyte,output);
      //Octet caractre
      fputc (rchar,output);
      
      //Comptreur initialis
      nbyte=1;
      rchar=character;
    }
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rCompress in progress... %u%% achieved.", purcent);}
  } 
  
  //Occurence restante
  if (nbyte!=1)
  {
    //Octet occurence
    fputc (nbyte,output);
    //Octet caractre
    fputc (rchar,output);
  }

  return -1;
}

//Dcompression du type RLE
int UncompressRLE (FILE *input, FILE *output)
{
  short character;
  short nbyte;
  
  char buffer[256];
  
  //Affichage pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
  
  //Parcours fichier
  printf ("Uncompress in progress... 0%% achieved.");
  
  while (!feof (input))
  {
    //Occurence + caractre
    nbyte=fgetc (input);
    character=fgetc (input);
    
    //Dernire opration effectue
    if (feof (input)) break;
    
    //Rptition du caractre  
    memset (buffer,character,nbyte);
    fwrite (buffer,nbyte,1,output);
    
    //Pourcentage de progression
    purcent=((unsigned long long)(k+=nbyte)*100)/TPE_FILE.size;
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rUncompress in progress... %u%% achieved.", purcent);}
  } 
   
  return -1;
}

//Compression du type TPE (format personnalis)
int CompressTPE (FILE *input, FILE *output)
{
  FILE *_input=input;
  FILE *_output=output;
    
  unsigned char bbyte=0;        //Bit en cours dans l'octet.
  unsigned char byte=0;         //Octet en cours d'criture
  unsigned char tmp; 
    
  unsigned char bitm=0;         //Bit de poids fort
  unsigned char tmp_bitm=0;     //Bit de poids fort
  unsigned char occur=0;
  
  short character;              //Caractre en cours
  
  unsigned char buffer [32]={};         //Buffer rcurrences
  
  unsigned long i=0;
  
  //Affichage pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
  unsigned long size;
  
  //Ouverture fichier temporaire
  output=fopen (TEMP_FILE,"wb");
  if (!output) return 0;
   
  //Cration du fichier temporaire
  //Parcours fichier
  printf ("Create tempory file...  0%% achieved.");
  while (!feof (input))
  {
    //Caractre en cours
    character=fgetc (input);
    
    //Atteint fin
    //if (feof (input)) break;
    
    //Pourcentage de progression
    purcent=((unsigned long long)++k*100)/TPE_FILE.size;
    
    //Octet null
    if (character==0) 
      tmp_bitm=255;
    //Recherche bit de poids fort
    else {
      //Cherche bit de poids fort de l'octet
      tmp=character;
      for (int j=0;j<8;j++)
      {
        //Bit de poids fort
        tmp=tmp>>1;
        if (tmp==0) {
          tmp_bitm=j;
          break;}
      }
    }
        
    //Premier octet
    if (i==0) {
      bitm=tmp_bitm;
      buffer [0]=character;
      occur=0;}
    
    //Occurence
    else if (tmp_bitm==bitm)
    {
      occur++;
            
      //Dpassement de capacit
      if (occur==32)
      {
        //Occurences
        fputc (31,output);
        //Bit de poids fort
        fputc (bitm,output);
        //Caractres...
        fwrite (buffer,32,1,output);
        
        //Occurence  zro
        occur=0;
        
        buffer [0]=character;
      }
      else
        buffer [occur]=character;
    }
    //Pas d'occurences
    else
    {
      //Occurences
      fputc (occur,output);
      //Bit de poids fort
      fputc (bitm,output);
      //Caractres...
      fwrite (buffer,occur+1,1,output);
      
      //Occurence  zro
      occur=0;
      
      buffer [0]=character;
      bitm=tmp_bitm;
    }       
                         
    i++;
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rCreate tempory file...  %u%% achieved.", purcent);}
  }

  //Ecriture finale
  if ((i==1) || (occur!=0)) {
    //Occurences
    fputc (occur,output);
    //Bit de poids fort
    fputc (bitm,output);
    //Caractres...
    fwrite (buffer,occur+1,1,output);}
  
  //Rouverture du fichier temporaire
  input=freopen (TEMP_FILE,"rb",output);
 
  if (!input) return 7;
  output=_output;
  
  size=FileSize (input);
  
  //Parcours fichier temporaire en lecture
  i=0;
  printf ("\nCompress in progress... 0%% achieved.");
  //Variable index octet
  byte=0;
  bbyte=0;
  
  //Pourcentage
  k=0;
  purcent2=0;
  purcent=0;
  
  while (!feof (input))
  {
    //Occurences
    occur=fgetc (input);
    
    //Fin du fichier
    if (feof (input)) break;           
                               
    //Bit de poids fort
    bitm=fgetc (input);
    k+=2;
       
    //Occurences
    BitWrite ((unsigned long)occur,byte,bbyte,5,output);
  
    //Occurence de 0
    if (bitm==255)
    {
      //Bit  1
      BitWrite (1,byte,bbyte,1,output);
      
      //Parcours occurences
      for (int i=0;i<occur+1;i++) {
        fgetc (input); 
        k++;}
    }
    //Pas de 0
    else
    {
      //Bit  0
      BitWrite (0,byte,bbyte,1,output);
      
      //Ecriture bit de poids fort
      BitWrite ((unsigned long)bitm,byte,bbyte,3,output);
      
      //Parcours occurences
      for (int i=0;i<occur+1;i++)
      {
        //Caractre en cours dans occurence
        character=fgetc (input);
        k++;
        
        //Copie des bits variable
        BitWrite (character,byte,bbyte,bitm,output);
      }
    }
    
    //Pourcentage de progression
    purcent=((unsigned long long)k*100)/size;
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rCompress in progress... %u%% achieved.", purcent);}
  }
  
  //Octet restant
  if (bbyte!=0)
    fputc (byte,output);
  
  //Erreur de fermeture fichier temporaire
  if (fclose (input)) return 7;
  
  return -1;
}

//Dcompression du type TPE (format personnalis)
int UncompressTPE (FILE *input, FILE *output)
{
  unsigned char character;
  unsigned char bbyte=0;
  
  //Informations
  unsigned char occur;
  unsigned char bitzero;
  unsigned char bitm;
  
  unsigned char tmp;
  
  char buffer [32];
  
  //Affichage pourcentage
  unsigned long k=0;
  unsigned char purcent=0, purcent2=0;
  
  printf ("Uncompress in progress... 0%% achieved.");
  character=fgetc (input);
  while (!feof (input))
  {
    occur=(unsigned char)BitRead (character,bbyte,5,input)+1;
    
    //Fin du fichier
    if (feof (input)) break;
    
    bitzero=(unsigned char)BitRead (character,bbyte,1,input);
    
    //Aucune rptitions de 0
    if (!bitzero)
    {
      bitm=(unsigned char)BitRead (character,bbyte,3,input);
      
      //Fin du fichier
      if (feof (input)) break;
      
      //Parcours occurences
      for (int i=0;i<occur;i++)
      {
        tmp=0;
        
        //Prpare bit de poids fort
        tmp|=(1<<bitm);
        
        //Reconstruction du caractre
        tmp|=(unsigned char)BitRead (character,bbyte,bitm,input);
        
        //Ecriture du caractre dans le fichier
        fputc (tmp,output);
        k++;
      }
    }
    //Rptition de 0
    else {
      memset (buffer, 0, occur);
      fwrite (buffer, occur, 1, output);
      k+=occur;}
    
    //Pourcentage de progression
    purcent=((unsigned long long)k*100)/TPE_FILE.size;
    
    //*******************
    //Affiche pourcentage
    //*******************
    if (purcent!=purcent2) {
      purcent2=purcent;
      printf ("\rUncompress in progress... %u%% achieved.", purcent);}
  }
  
  return -1;
}
