# Copyright (c) 2003-2004, Richard Dillingham
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
#
#     * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
#     * Neither the name of the copyright holder nor the names of contributors may be used to endorse or promote products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER(S) AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
from __future__ import division
import os, sys, os.path, string
import cPickle
import getpass
import telnetlib
import time
import socket
import threading
from threading import Thread, Event, Lock

sourcefolder = 'c:\\rich\\programming\\tidocs\\89tToAndFromTxt\\source'
sourceFiles = ['shared.cpp', 'shared.hpp']
copyFiles = ['compile.sh', 'FromTxt.hpp', 'FromTxt.cpp', 'ToTxt.hpp', 'ToTxt.cpp', 'Sync.hpp', 'Sync.cpp']
def main():
	tc = Tracer()
	tc.run()

class Tracer:
	def __init__(self):
		pass
	def StripText(self, txt):
		self.writetxt=''
		rtxt=txt
		
		if (self.inComment):
			i=rtxt.find('*/')
			if (i>-1):
				self.inComment=0
				rtxt=rtxt[i+2:]
				i=rtxt.find('/*')
				if (i>-1):
					print "Recursive comments, BAD! (line "+self.lineNumber+" of "+self.curFileName+")"
			else:
				return ''
		i=rtxt.find('//')
		if (i>-1):
			rtxt=rtxt[:i]
		i=rtxt.find('/*')
		if (i>-1):
			i2=rtxt.find('*/', i+2)
			if (i2>-1):
				rtxt=rtxt[:i]+rtxt[i2+2:]
			else:
				rtxt=rtxt[:i]
				self.inComment=1
		i=rtxt.find('#')
		if (i>-1):
			rtxt=rtxt[:i]
		rtxt=rtxt.strip(' \t')
		return rtxt
	def run(self):
		try:
			os.mkdir(sourcefolder+'\\debugtest')
		except OSError:
			pass
		for self.curFileName in copyFiles:
			self.curFile=open(sourcefolder+'\\'+self.curFileName,'r')
			self.curOutFile=open(sourcefolder+'\\debugtest\\'+self.curFileName,'w')
			txt=self.curFile.readline()
			while (len(txt)>0 and txt[-1]=='\n'):
				self.curOutFile.write(txt)
				txt=self.curFile.readline()
			self.curOutFile.write(txt)
			self.curFile.close()
				
		for self.curFileName in sourceFiles:
			self.curFile=open(sourcefolder+'\\'+self.curFileName,'r')
			self.curOutFile=open(sourcefolder+'\\debugtest\\'+self.curFileName,'w')
			#for each line, determine whether to add a debug message or not, and write out to curOutFile
			txt=self.curFile.readline()
			self.inFunction=0;
			self.inComment=0
			self.inBlock=0
			self.inAsm=0
			self.lineNumber=1
			self.inSplitLine=0
			self.inOneLineBlock=0
			self.printThisLine=0
			self.printNextLine=0
			self.inClass=0
			self.blocky=0
			while (len(txt)>0 and txt[-1]=='\n'):
				self.printThisLine=self.printNextLine
				self.printNextLine=1
				self.readtext=self.StripText(txt)
				if (len(self.readtext)==0):
					self.curOutFile.write(txt)
					txt=self.curFile.readline()
					self.lineNumber+=1
					continue
				if (self.inFunction==0):
					if (self.inBlock==0):
						ia=self.readtext.find('struct')
						ib=self.readtext.find('union')
						ic=self.readtext.find('typedef')
						ie=self.readtext.find('enum')
						ig=self.readtext.find('class')
						ih=self.readtext.find('extern')
						ii=self.readtext.find('template')
						if (ia>-1 or ib>-1 or ic>-1 or ie>-1 or ig>-1 or ih>-1 or ii>-1):
							i2=self.readtext.find('{')
							if (i2>-1):
								while (i2>-1):
									if ig>-1 or ih>-1:
										self.inClass+=1
									else:
										self.inBlock+=1
									i2=self.readtext.find('{',i2+1)
							else:
								i2=self.readtext.find(';')
								if (i2>-1):
									self.inSplitLine=0
								else:
									self.inSplitLine=1
									if ig>-1 or ih>-1:
										self.blocky=2
									else:
										self.blocky=1
						else:
							i2=self.readtext.find('{')
							if (i2>-1):
								temptxt=self.readtext[:i2].strip(' \t')
								if (len(temptxt)==0 or temptxt[-1]!='='):
									self.inFunction=0
									self.inSplitLine=1
									while (i2>-1):
										if self.blocky==1:
											self.inBlock+=1
										elif self.blocky==2:
											self.inClass+=1
										else:
											self.inFunction+=1
										i2=self.readtext.find('{',i2+1)
									
								if (i2==-1):
									i2=0	
								i2=self.readtext.find('}',i2)
								if (i2>-1):
									while (i2>-1):
										if self.blocky==1:
											if (self.inBlock>0):
												self.inBlock-=1
										elif self.blocky==2:
											if (self.inClass>0):
												self.inClass-=1
										else:
											if (self.inFunction>0):
												self.inFunction-=1
											
										i2=self.readtext.find('}',i2+1)
									self.inSplitLine=0
								blocky=0
							else:
								i2=self.readtext.find(';')
								if (i2>-1):
									self.inSplitLine=0
								else:
									self.inSplitLine=1
					else:	#inBlock
						i2=self.readtext.find('{')
						if (i2>-1):
							while (i2>-1):
								self.inBlock+=1
								i2=self.readtext.find('{',i2+1)
						else:
							i2=self.readtext.find(';')
							if (i2>-1):
								self.inSplitLine=0
							else:
								self.inSplitLine=1
						i2=self.readtext.find('}')
						if (i2>-1):
							while (i2>-1):
								if self.inBlock>0:
									self.inBlock-=1
								elif self.inClass>0:
									self.inClass-=1
								i2=self.readtext.find('}',i2+1)
								
						
				else:	#inFunction
					i2 = self.readtext.find('asm')
					if (i2>-1):
						self.inAsm=1
					if (self.inAsm==0):
						ii = self.readtext.find('if')
						if (ii==0):
							if ((self.readtext[-1]==')' or self.readtext.find('{')==-1) and self.readtext[-1]!=';'):
								#no {, treat as split line read next line
								#self.inSplitLine=2
								self.printNextLine=0
						ii = self.readtext.find('else')
						if (ii>-1):
							if ((self.readtext[-1]==')' or self.readtext.find('{')==-1) and self.readtext[-1]!=';'):
								#no {, treat as split line read next line
								#self.inSplitLine=2
								self.printNextLine=0
							self.printThisLine=0
					
					i2=self.readtext.find('{')
					c=i2
					while (i2>-1):
						self.inFunction+=1
						if (self.inAsm):
							self.inAsm+=1
						i2=self.readtext.find('{',i2+1)
					
					if (self.inAsm==0):
						if (c>-1):
							i2=self.readtext.find(';',i2)
							if (i2==-1):
								#self.inSplitLine=2
								self.printNextLine=0
						else:
							i2=self.readtext.find(';')
							if (i2==-1):
								#self.inSplitLine=2
								self.printNextLine=0
					i2=self.readtext.find('}')
					while (i2>-1):
						self.inFunction-=1
						if (self.inAsm>1):
							self.inAsm-=1
						i2=self.readtext.find('}',i2+1)
				#if (self.curFileName=='noctis-0.cpp' and self.lineNumber>1117 and self.lineNumber<1150):
				##if (self.curFileName=='noctis-0.cpp' and self.lineNumber<1101 and self.inFunction<0):
				#	print 'f='+self.curFileName+'l='+str(self.lineNumber)+' pTL='+str(self.printThisLine)+' iSL='+str(self.inSplitLine)+' iA='+str(self.inAsm)+' iF='+str(self.inFunction)
				
				if (self.printThisLine and self.inSplitLine!=1 and self.inAsm==0 and self.inFunction>0):
					#self.writetxt='{ unsigned int ics; unsigned long ieip; asm {mov ics, cs; mov ieip, ip}\n'
					#tmptxt='DebugPrintf("%x:%x: %s:%i",ics, ieip, "'+self.curFileName+'",'+str(self.lineNumber)+');'
					tmptxt='printf("'+self.curFileName+':%i\\n",'+str(self.lineNumber)+');'
					self.writetxt+=tmptxt;
				else:
					self.writetxt=''
				if (self.inSplitLine>0):
					self.inSplitLine-=1
				if (self.inAsm==1):
					self.inAsm=0
				self.curOutFile.write(self.writetxt+txt)
				txt=self.curFile.readline()
				self.lineNumber+=1
			self.curOutFile.write(txt)
			self.curFile.close()
		#copy compile.bat to 'debugtest'
		#compile it all
		
		
		
if __name__ == '__main__': main()